/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SimpleFutureAction;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.receiver.UpdateRateLimit;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.AllReceiverIds$;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.GetAllReceiverInfo$;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTracker;
import org.apache.spark.streaming.scheduler.ReceiverErrorInfo;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicy;
import org.apache.spark.streaming.scheduler.ReceiverState$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$TrackerState$;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.RestartReceiver;
import org.apache.spark.streaming.scheduler.StartAllReceivers;
import org.apache.spark.streaming.scheduler.StopAllReceivers$;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.UpdateReceiverRateLimit;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\ree!\u0002)R\u0001M[\u0006\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u00119\u0004!\u0011!Q\u0001\n=DQA\u001d\u0001\u0005\u0002MDq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002(\u0001\u0001\u000b\u0011\u0002>\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA\u001b\u0001\u0001\u0006I!!\f\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002CA!\u0001\u0001\u0006I!a\u000f\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0003\u0002CA'\u0001\u0001\u0006I!a\u0012\b\u000f\u0005=\u0003\u0001#\u0001\u0002R\u00199\u0011Q\u000b\u0001\t\u0002\u0005]\u0003B\u0002:\u000e\t\u0003\ty&\u0002\u0004\u0002V5\u0001\u0011\u0011\r\u0005\n\u0003Sj!\u0019!C\u0001\u0003WB\u0001\"!\u001c\u000eA\u0003%\u0011\u0011\r\u0005\n\u0003_j!\u0019!C\u0001\u0003WB\u0001\"!\u001d\u000eA\u0003%\u0011\u0011\r\u0005\n\u0003gj!\u0019!C\u0001\u0003WB\u0001\"!\u001e\u000eA\u0003%\u0011\u0011\r\u0005\n\u0003oj!\u0019!C\u0001\u0003WB\u0001\"!\u001f\u000eA\u0003%\u0011\u0011\r\u0005\n\u0003w\u0002\u0001\u0019!C\u0005\u0003{B\u0011\"a!\u0001\u0001\u0004%I!!\"\t\u0011\u0005E\u0005\u0001)Q\u0005\u0003\u007fB\u0011\"a'\u0001\u0001\u0004%I!!(\t\u0013\u0005-\u0006\u00011A\u0005\n\u00055\u0006\u0002CAY\u0001\u0001\u0006K!a(\t\u0013\u0005M\u0006A1A\u0005\n\u0005U\u0006\u0002CA_\u0001\u0001\u0006I!a.\t\u0013\u0005}\u0006A1A\u0005\n\u0005\u0005\u0007\u0002CAl\u0001\u0001\u0006I!a1\t\u0013\u0005e\u0007A1A\u0005\n\u0005m\u0007\u0002CAz\u0001\u0001\u0006I!!8\t\u0013\u0005U\bA1A\u0005\n\u0005]\b\u0002\u0003B\f\u0001\u0001\u0006I!!?\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9!Q\u0004\u0001\u0005\u0002\t}\u0001b\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u0011\u001d\u00119\u0006\u0001C\u0001\u00053BqA!\u0019\u0001\t\u0003\u0011\u0019\u0007C\u0004\u0003j\u0001!\tAa\u001b\t\u000f\t=\u0004\u0001\"\u0001\u0003r!9!1\u000f\u0001\u0005\n\tU\u0004b\u0002BJ\u0001\u0011%!Q\u0013\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011\u0019\f\u0001C\u0005\u0005kCqAa/\u0001\t\u0013\u0011i\fC\u0004\u0003F\u0002!IAa2\t\u000f\te\u0007\u0001\"\u0003\u0003\\\"9!1\u001d\u0001\u0005\u0002\t\u0015\bb\u0002Bt\u0001\u0011%!\u0011\u001e\u0005\b\u0005g\u0004A\u0011\u0002B\u000e\u0011\u001d\u0011)\u0010\u0001C\u0005\u00057AqAa>\u0001\t\u0013\u0011)\u000fC\u0004\u0003z\u0002!IA!:\t\u000f\tm\b\u0001\"\u0003\u0003f\u001a1!Q \u0001\u0005\u0005\u007fD!ba\u0002=\u0005\u000b\u0007I\u0011IB\u0005\u0011)\u0019\t\u0002\u0010B\u0001B\u0003%11\u0002\u0005\u0007er\"\taa\u0005\t\u0013\reAH1A\u0005\n\rm\u0001\u0002CB\u0014y\u0001\u0006Ia!\b\t\u0013\r%B\b1A\u0005\n\t\u0015\b\"CB\u0016y\u0001\u0007I\u0011BB\u0017\u0011\u001d\u0019\t\u0004\u0010Q!\n=Dqa!\u000e=\t\u0003\u001a9\u0004C\u0004\u0004@q\"\te!\u0011\t\u000f\r5C\b\"\u0003\u0004P!911\u000b\u001f\u0005\n\rU\u0003bBB8y\u0011\u0005#1\u0004\u0005\b\u0007cbD\u0011BB:\u0011\u001d\u00199\b\u0010C\u0005\u000579!b!\u001fR\u0003\u0003E\taUB>\r%\u0001\u0016+!A\t\u0002M\u001bi\b\u0003\u0004s\u001b\u0012\u00051q\u0010\u0005\n\u0007\u0003k\u0015\u0013!C\u0001\u0007\u0007\u0013qBU3dK&4XM\u001d+sC\u000e\\WM\u001d\u0006\u0003%N\u000b\u0011b]2iK\u0012,H.\u001a:\u000b\u0005Q+\u0016!C:ue\u0016\fW.\u001b8h\u0015\t1v+A\u0003ta\u0006\u00148N\u0003\u0002Y3\u00061\u0011\r]1dQ\u0016T\u0011AW\u0001\u0004_J<7c\u0001\u0001]EB\u0011Q\fY\u0007\u0002=*\tq,A\u0003tG\u0006d\u0017-\u0003\u0002b=\n1\u0011I\\=SK\u001a\u0004\"a\u00194\u000e\u0003\u0011T!!Z+\u0002\u0011%tG/\u001a:oC2L!a\u001a3\u0003\u000f1{wmZ5oO\u0006\u00191o]2\u0004\u0001A\u00111\u000e\\\u0007\u0002'&\u0011Qn\u0015\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR\f!c]6jaJ+7-Z5wKJd\u0015-\u001e8dQB\u0011Q\f]\u0005\u0003cz\u0013qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0004iZ<\bCA;\u0001\u001b\u0005\t\u0006\"\u00025\u0004\u0001\u0004Q\u0007b\u00028\u0004!\u0003\u0005\ra\\\u0001\u0015e\u0016\u001cW-\u001b<fe&s\u0007/\u001e;TiJ,\u0017-\\:\u0016\u0003i\u00042!X>~\u0013\tahLA\u0003BeJ\f\u0017\u0010M\u0002\u007f\u0003\u001b\u0001Ra`A\u0003\u0003\u0013i!!!\u0001\u000b\u0007\u0005\r1+A\u0004egR\u0014X-Y7\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0015%\u0016\u001cW-\u001b<fe&s\u0007/\u001e;E'R\u0014X-Y7\u0011\t\u0005-\u0011Q\u0002\u0007\u0001\t-\ty\u0001AA\u0001\u0002\u0003\u0015\t!!\u0007\u0003\u0007}#\u0003(\u0003\u0003\u0002\u0014\u0005U\u0011aF4fiJ+7-Z5wKJLe\u000e];u'R\u0014X-Y7t\u0013\r\t9b\u0015\u0002\r\tN#(/Z1n\u000fJ\f\u0007\u000f[\t\u0005\u00037\t\t\u0003E\u0002^\u0003;I1!a\b_\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!XA\u0012\u0013\r\t)C\u0018\u0002\u0004\u0003:L\u0018!\u0006:fG\u0016Lg/\u001a:J]B,Ho\u0015;sK\u0006l7\u000fI\u0001\u0017e\u0016\u001cW-\u001b<fe&s\u0007/\u001e;TiJ,\u0017-\\%egV\u0011\u0011Q\u0006\t\u0005;n\fy\u0003E\u0002^\u0003cI1!a\r_\u0005\rIe\u000e^\u0001\u0018e\u0016\u001cW-\u001b<fe&s\u0007/\u001e;TiJ,\u0017-\\%eg\u0002\nAC]3dK&4X\r\u001a\"m_\u000e\\GK]1dW\u0016\u0014XCAA\u001e!\r)\u0018QH\u0005\u0004\u0003\u007f\t&\u0001\u0006*fG\u0016Lg/\u001a3CY>\u001c7\u000e\u0016:bG.,'/A\u000bsK\u000e,\u0017N^3e\u00052|7m\u001b+sC\u000e\\WM\u001d\u0011\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0003\u0003\u000f\u00022!^A%\u0013\r\tY%\u0015\u0002\u0015'R\u0014X-Y7j]\u001ed\u0015n\u001d;f]\u0016\u0014()^:\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\u0002\u0019Q\u0013\u0018mY6feN#\u0018\r^3\u0011\u0007\u0005MS\"D\u0001\u0001\u00051!&/Y2lKJ\u001cF/\u0019;f'\ri\u0011\u0011\f\t\u0004;\u0006m\u0013bAA/=\nYQI\\;nKJ\fG/[8o)\t\t\t\u0006\u0005\u0003\u0002d\u0005\u0015T\"A\u0007\n\t\u0005\u001d\u00141\f\u0002\u0006-\u0006dW/Z\u0001\f\u0013:LG/[1mSj,G-\u0006\u0002\u0002b\u0005a\u0011J\\5uS\u0006d\u0017N_3eA\u000591\u000b^1si\u0016$\u0017\u0001C*uCJ$X\r\u001a\u0011\u0002\u0011M#x\u000e\u001d9j]\u001e\f\u0011b\u0015;paBLgn\u001a\u0011\u0002\u000fM#x\u000e\u001d9fI\u0006A1\u000b^8qa\u0016$\u0007%\u0001\u0007ue\u0006\u001c7.\u001a:Ti\u0006$X-\u0006\u0002\u0002\u0000A!\u0011\u0011QA3\u001d\r\t\u0019\u0006D\u0001\u0011iJ\f7m[3s'R\fG/Z0%KF$B!a\"\u0002\u000eB\u0019Q,!#\n\u0007\u0005-eL\u0001\u0003V]&$\b\"CAH3\u0005\u0005\t\u0019AA@\u0003\rAH%M\u0001\u000eiJ\f7m[3s'R\fG/\u001a\u0011)\u0007i\t)\nE\u0002^\u0003/K1!!'_\u0005!1x\u000e\\1uS2,\u0017\u0001C3oIB|\u0017N\u001c;\u0016\u0005\u0005}\u0005\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015V+A\u0002sa\u000eLA!!+\u0002$\nq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0017\u0001D3oIB|\u0017N\u001c;`I\u0015\fH\u0003BAD\u0003_C\u0011\"a$\u001d\u0003\u0003\u0005\r!a(\u0002\u0013\u0015tG\r]8j]R\u0004\u0013\u0001E:dQ\u0016$W\u000f\\5oOB{G.[2z+\t\t9\fE\u0002v\u0003sK1!a/R\u0005a\u0011VmY3jm\u0016\u00148k\u00195fIVd\u0017N\\4Q_2L7-_\u0001\u0012g\u000eDW\rZ;mS:<\u0007k\u001c7jGf\u0004\u0013\u0001\u0006:fG\u0016Lg/\u001a:K_\n,\u00050\u001b;MCR\u001c\u0007.\u0006\u0002\u0002DB!\u0011QYAj\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017AC2p]\u000e,(O]3oi*!\u0011QZAh\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0017\u0001\u00026bm\u0006LA!!6\u0002H\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017!\u0006:fG\u0016Lg/\u001a:K_\n,\u00050\u001b;MCR\u001c\u0007\u000eI\u0001\u0016e\u0016\u001cW-\u001b<feR\u0013\u0018mY6j]\u001eLeNZ8t+\t\ti\u000e\u0005\u0005\u0002`\u0006%\u0018qFAw\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003Ot\u0016AC2pY2,7\r^5p]&!\u00111^Aq\u0005\u001dA\u0015m\u001d5NCB\u00042!^Ax\u0013\r\t\t0\u0015\u0002\u0015%\u0016\u001cW-\u001b<feR\u0013\u0018mY6j]\u001eLeNZ8\u0002-I,7-Z5wKJ$&/Y2lS:<\u0017J\u001c4pg\u0002\n!D]3dK&4XM\u001d)sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N,\"!!?\u0011\u0011\u0005}\u0017\u0011^A\u0018\u0003w\u0004R!XA\u007f\u0005\u0003I1!a@_\u0005\u0019y\u0005\u000f^5p]B!!1\u0001B\t\u001d\u0011\u0011)A!\u0004\u0011\u0007\t\u001da,\u0004\u0002\u0003\n)\u0019!1B5\u0002\rq\u0012xn\u001c;?\u0013\r\u0011yAX\u0001\u0007!J,G-\u001a4\n\t\tM!Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t=a,A\u000esK\u000e,\u0017N^3s!J,g-\u001a:sK\u0012dunY1uS>t7\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003\u000f\u000bAa\u001d;paR!\u0011q\u0011B\u0011\u0011\u0019\u0011\u0019c\na\u0001_\u0006AqM]1dK\u001a,H.A\u000bbY2|7-\u0019;f\u00052|7m[:U_\n\u000bGo\u00195\u0015\t\u0005\u001d%\u0011\u0006\u0005\b\u0005WA\u0003\u0019\u0001B\u0017\u0003%\u0011\u0017\r^2i)&lW\rE\u0002l\u0005_I1A!\rT\u0005\u0011!\u0016.\\3\u0002!\u001d,GO\u00117pG.\u001cxJ\u001a\"bi\u000eDG\u0003\u0002B\u001c\u0005+\u0002\u0002Ba\u0001\u0003:\u0005=\"QH\u0005\u0005\u0005w\u0011)BA\u0002NCB\u0004bAa\u0010\u0003J\t=c\u0002\u0002B!\u0005\u000brAAa\u0002\u0003D%\tq,C\u0002\u0003Hy\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003L\t5#aA*fc*\u0019!q\t0\u0011\u0007U\u0014\t&C\u0002\u0003TE\u0013\u0011CU3dK&4X\r\u001a\"m_\u000e\\\u0017J\u001c4p\u0011\u001d\u0011Y#\u000ba\u0001\u0005[\t\u0011dZ3u\u00052|7m[:PM\n\u000bGo\u00195B]\u0012\u001cFO]3b[R1!Q\bB.\u0005;BqAa\u000b+\u0001\u0004\u0011i\u0003C\u0004\u0003`)\u0002\r!a\f\u0002\u0011M$(/Z1n\u0013\u0012\f!d\u00197fC:,\bo\u00147e\u00052|7m[:B]\u0012\u0014\u0015\r^2iKN$B!a\"\u0003f!9!qM\u0016A\u0002\t5\u0012!E2mK\u0006tW\u000f\u001d+ie\u0016\u001c\b\u000eV5nK\u0006\u0011\u0012\r\u001c7pG\u0006$X\rZ#yK\u000e,Ho\u001c:t)\t\u0011i\u0007\u0005\u0005\u0003\u0004\te\u0012qFA~\u00031qW/\u001c*fG\u0016Lg/\u001a:t)\t\ty#\u0001\tsK\u001eL7\u000f^3s%\u0016\u001cW-\u001b<feRiqNa\u001e\u0003z\tu$\u0011\u0011BC\u0005\u0013CqAa\u0018/\u0001\u0004\ty\u0003C\u0004\u0003|9\u0002\rA!\u0001\u0002\u0007QL\b\u000fC\u0004\u0003\u00009\u0002\rA!\u0001\u0002\t!|7\u000f\u001e\u0005\b\u0005\u0007s\u0003\u0019\u0001B\u0001\u0003))\u00070Z2vi>\u0014\u0018\n\u001a\u0005\b\u0005\u000fs\u0003\u0019AAP\u0003A\u0011XmY3jm\u0016\u0014XI\u001c3q_&tG\u000fC\u0004\u0003\f:\u0002\rA!$\u0002\u001bM,g\u000eZ3s\u0003\u0012$'/Z:t!\u0011\t\tKa$\n\t\tE\u00151\u0015\u0002\u000b%B\u001c\u0017\t\u001a3sKN\u001c\u0018A\u00053fe\u0016<\u0017n\u001d;feJ+7-Z5wKJ$\u0002\"a\"\u0003\u0018\ne%Q\u0014\u0005\b\u0005?z\u0003\u0019AA\u0018\u0011\u001d\u0011Yj\fa\u0001\u0005\u0003\tq!\\3tg\u0006<W\rC\u0004\u0003 >\u0002\rA!\u0001\u0002\u000b\u0015\u0014(o\u001c:\u0002\u001dM,g\u000e\u001a*bi\u0016,\u0006\u000fZ1uKR1\u0011q\u0011BS\u0005SCqAa*1\u0001\u0004\ty#A\u0005tiJ,\u0017-\\+J\t\"9!1\u0016\u0019A\u0002\t5\u0016a\u00028foJ\u000bG/\u001a\t\u0004;\n=\u0016b\u0001BY=\n!Aj\u001c8h\u0003!\tG\r\u001a\"m_\u000e\\GcA8\u00038\"9!\u0011X\u0019A\u0002\t=\u0013!\u0005:fG\u0016Lg/\u001a3CY>\u001c7.\u00138g_\u0006Y!/\u001a9peR,%O]8s)!\t9Ia0\u0003B\n\r\u0007b\u0002B0e\u0001\u0007\u0011q\u0006\u0005\b\u00057\u0013\u0004\u0019\u0001B\u0001\u0011\u001d\u0011yJ\ra\u0001\u0005\u0003\t\u0001c]2iK\u0012,H.\u001a*fG\u0016Lg/\u001a:\u0015\t\t%'Q\u001b\t\u0007\u0005\u007f\u0011IEa3\u0011\t\t5'\u0011[\u0007\u0003\u0005\u001fT!AU+\n\t\tM'q\u001a\u0002\r)\u0006\u001c8\u000eT8dCRLwN\u001c\u0005\b\u0005/\u001c\u0004\u0019AA\u0018\u0003)\u0011XmY3jm\u0016\u0014\u0018\nZ\u0001!kB$\u0017\r^3SK\u000e,\u0017N^3s'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148\u000f\u0006\u0004\u0002\b\nu'q\u001c\u0005\b\u0005/$\u0004\u0019AA\u0018\u0011\u001d\u0011\t\u000f\u000ea\u0001\u0005\u0013\f!c]2iK\u0012,H.\u001a3M_\u000e\fG/[8og\u0006!\u0002.Y:V]\u0006dGn\\2bi\u0016$'\t\\8dWN,\u0012a\\\u0001\rO\u0016$X\t_3dkR|'o]\u000b\u0003\u0005W\u0004bAa\u0010\u0003J\t5\b\u0003\u0002Bg\u0005_LAA!=\u0003P\nIR\t_3dkR|'oQ1dQ\u0016$\u0016m]6M_\u000e\fG/[8o\u0003A\u0011XO\u001c#v[6L8\u000b]1sW*{'-A\bmCVt7\r\u001b*fG\u0016Lg/\u001a:t\u0003AI7\u000f\u0016:bG.,'o\u0015;beR,G-A\tjgR\u0013\u0018mY6feN#x\u000e\u001d9j]\u001e\f\u0001#[:Ue\u0006\u001c7.\u001a:Ti>\u0004\b/\u001a3\u0003/I+7-Z5wKJ$&/Y2lKJ,e\u000e\u001a9pS:$8\u0003\u0002\u001f]\u0007\u0003\u0001B!!)\u0004\u0004%!1QAAR\u0005U!\u0006N]3bIN\u000bg-\u001a*qG\u0016sG\r]8j]R\faA\u001d9d\u000b:4XCAB\u0006!\u0011\t\tk!\u0004\n\t\r=\u00111\u0015\u0002\u0007%B\u001cWI\u001c<\u0002\u000fI\u00048-\u00128wAQ!1QCB\f!\r\t\u0019\u0006\u0010\u0005\b\u0007\u000fy\u0004\u0019AB\u0006\u0003U9\u0018\r\u001c\"bi\u000eD\u0017N\\4UQJ,\u0017\r\u001a)p_2,\"a!\b\u0011\t\r}11E\u0007\u0003\u0007CQ1!!3_\u0013\u0011\u0019)c!\t\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW-\u0001\fxC2\u0014\u0015\r^2iS:<G\u000b\u001b:fC\u0012\u0004vn\u001c7!\u0003\u0019\t7\r^5wK\u0006Q\u0011m\u0019;jm\u0016|F%Z9\u0015\t\u0005\u001d5q\u0006\u0005\t\u0003\u001f\u001b\u0015\u0011!a\u0001_\u00069\u0011m\u0019;jm\u0016\u0004\u0003f\u0001#\u0002\u0016\u00069!/Z2fSZ,WCAB\u001d!\u001di61HA\u0011\u0003\u000fK1a!\u0010_\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0017a\u0004:fG\u0016Lg/Z!oIJ+\u0007\u000f\\=\u0015\t\re21\t\u0005\b\u0007\u000b2\u0005\u0019AB$\u0003\u001d\u0019wN\u001c;fqR\u0004B!!)\u0004J%!11JAR\u00059\u0011\u0006oY\"bY2\u001cuN\u001c;fqR\f1dZ3u'R|'/\u001a3TG\",G-\u001e7fI\u0016CXmY;u_J\u001cH\u0003\u0002Be\u0007#BqAa6H\u0001\u0004\ty#A\u0007ti\u0006\u0014HOU3dK&4XM\u001d\u000b\u0007\u0003\u000f\u001b9f!\u001c\t\u000f\re\u0003\n1\u0001\u0004\\\u0005A!/Z2fSZ,'\u000f\r\u0003\u0004^\r%\u0004CBB0\u0007G\u001a9'\u0004\u0002\u0004b)\u00191\u0011L*\n\t\r\u00154\u0011\r\u0002\t%\u0016\u001cW-\u001b<feB!\u00111BB5\t1\u0019Yga\u0016\u0002\u0002\u0003\u0005)\u0011AA\r\u0005\ryFe\r\u0005\b\u0005CD\u0005\u0019\u0001Be\u0003\u0019ygn\u0015;pa\u0006\u0019rN\u001c*fG\u0016Lg/\u001a:K_\n4\u0015N\\5tQR!\u0011qQB;\u0011\u001d\u00119N\u0013a\u0001\u0003_\tQb\u001d;paJ+7-Z5wKJ\u001c\u0018a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u0011\u0005Ul5CA'])\t\u0019Y(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007\u000bS3a\\BDW\t\u0019I\t\u0005\u0003\u0004\f\u000eUUBABG\u0015\u0011\u0019yi!%\u0002\u0013Ut7\r[3dW\u0016$'bABJ=\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r]5Q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ReceiverTracker
implements Logging {
    private volatile ReceiverTracker$TrackerState$ TrackerState$module;
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final boolean skipReceiverLaunch;
    private final ReceiverInputDStream<?>[] receiverInputStreams;
    private final int[] receiverInputStreamIds;
    private final ReceivedBlockTracker receivedBlockTracker;
    private final StreamingListenerBus listenerBus;
    private volatile Enumeration.Value trackerState;
    private RpcEndpointRef endpoint;
    private final ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    private final CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    private final HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    private final HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return ReceiverTracker$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public ReceiverTracker$TrackerState$ TrackerState() {
        if (this.TrackerState$module == null) {
            this.TrackerState$lzycompute$1();
        }
        return this.TrackerState$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ReceiverInputDStream<?>[] receiverInputStreams() {
        return this.receiverInputStreams;
    }

    private int[] receiverInputStreamIds() {
        return this.receiverInputStreamIds;
    }

    private ReceivedBlockTracker receivedBlockTracker() {
        return this.receivedBlockTracker;
    }

    private StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    private Enumeration.Value trackerState() {
        return this.trackerState;
    }

    private void trackerState_$eq(Enumeration.Value x$1) {
        this.trackerState = x$1;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    }

    public CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    }

    public HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    }

    public HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    }

    public synchronized void start() {
        block2: {
            if (this.isTrackerStarted()) {
                throw new SparkException("ReceiverTracker already started");
            }
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).isEmpty()) break block2;
            this.endpoint_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().setupEndpoint("ReceiverTracker", (RpcEndpoint)new ReceiverTrackerEndpoint(this, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv())));
            if (!this.skipReceiverLaunch) {
                this.launchReceivers();
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "ReceiverTracker started");
            this.trackerState_$eq(this.TrackerState().Started());
        }
    }

    public synchronized void stop(boolean graceful) {
        boolean isStarted = this.isTrackerStarted();
        this.trackerState_$eq(this.TrackerState().Stopping());
        if (isStarted) {
            if (!this.skipReceiverLaunch) {
                Seq receivers;
                this.endpoint().askSync((Object)StopAllReceivers$.MODULE$, ClassTag$.MODULE$.Boolean());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await(10L, TimeUnit.SECONDS);
                if (graceful) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for receiver job to terminate gracefully");
                    this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waited for receiver job to terminate gracefully");
                }
                if ((receivers = (Seq)this.endpoint().askSync((Object)AllReceiverIds$.MODULE$, ClassTag$.MODULE$.apply(Seq.class))).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Not all of the receivers have deregistered, ").append(receivers).toString());
                } else {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "All of the receivers have deregistered successfully");
                }
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().stop(this.endpoint());
            this.endpoint_$eq(null);
        }
        this.receivedBlockTracker().stop();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "ReceiverTracker stopped");
        this.trackerState_$eq(this.TrackerState().Stopped());
    }

    public void allocateBlocksToBatch(Time batchTime) {
        block0: {
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).nonEmpty()) break block0;
            this.receivedBlockTracker().allocateBlocksToBatch(batchTime);
        }
    }

    public scala.collection.immutable.Map<Object, Seq<ReceivedBlockInfo>> getBlocksOfBatch(Time batchTime) {
        return this.receivedBlockTracker().getBlocksOfBatch(batchTime);
    }

    public Seq<ReceivedBlockInfo> getBlocksOfBatchAndStream(Time batchTime, int streamId) {
        return this.receivedBlockTracker().getBlocksOfBatchAndStream(batchTime, streamId);
    }

    public void cleanupOldBlocksAndBatches(Time cleanupThreshTime) {
        this.receivedBlockTracker().cleanupOldBatches(cleanupThreshTime, false);
        if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf())) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleanup old received batch data: ").append(cleanupThreshTime).toString());
            ReceiverTracker receiverTracker = this;
            synchronized (receiverTracker) {
                if (this.isTrackerStarted()) {
                    this.endpoint().send((Object)new CleanupOldBlocks(cleanupThreshTime));
                }
            }
        }
    }

    public synchronized scala.collection.immutable.Map<Object, Option<String>> allocatedExecutors() {
        return this.isTrackerStarted() ? ((scala.collection.immutable.MapLike)this.endpoint().askSync((Object)GetAllReceiverInfo$.MODULE$, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class))).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.runningExecutor().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.executorId())).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
    }

    public int numReceivers() {
        return this.receiverInputStreams().length;
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(int streamId, String typ, String host, String executorId, RpcEndpointRef receiverEndpoint, RpcAddress senderAddress) {
        boolean bl;
        Seq<TaskLocation> acceptableExecutors;
        if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.receiverInputStreamIds())).contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            throw new SparkException(new StringBuilder(36).append("Register received for unexpected id ").append(streamId).toString());
        }
        if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped()) {
            return false;
        }
        Option<Seq<TaskLocation>> scheduledLocations = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)streamId))).scheduledLocations();
        Seq<TaskLocation> seq = acceptableExecutors = scheduledLocations.nonEmpty() ? (Seq<TaskLocation>)scheduledLocations.get() : this.scheduleReceiver(streamId);
        if (!ReceiverTracker.isAcceptable$1(acceptableExecutors, executorId, host)) {
            bl = false;
        } else {
            String name = new StringBuilder(1).append(typ).append("-").append(streamId).toString();
            ReceiverTrackingInfo receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.ACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)new Some((Object)new ExecutorCacheTaskLocation(host, executorId)), (Option<String>)new Some((Object)name), (Option<RpcEndpointRef>)new Some((Object)receiverEndpoint), ReceiverTrackingInfo$.MODULE$.apply$default$7());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)receiverTrackingInfo);
            this.listenerBus().post(new StreamingListenerReceiverStarted(receiverTrackingInfo.toReceiverInfo()));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Registered receiver for stream ").append(streamId).append(" from ").append(senderAddress).toString());
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(int streamId, String message, String error) {
        if (error == null) ** GOTO lbl-1000
        v0 = error;
        var7_4 = "";
        if (!(v0 != null ? v0.equals(var7_4) == false : var7_4 != null)) lbl-1000:
        // 2 sources

        {
            v1 = -1L;
        } else {
            v1 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis();
        }
        lastErrorTime = v1;
        errorInfo = new ReceiverErrorInfo(message, error, lastErrorTime);
        var10_7 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
        if (var10_7 instanceof Some) {
            var11_8 = (Some)var10_7;
            oldInfo = (ReceiverTrackingInfo)var11_8.value();
            x$1 = ReceiverState$.MODULE$.INACTIVE();
            x$2 = new Some((Object)errorInfo);
            x$3 = oldInfo.copy$default$1();
            x$4 = oldInfo.copy$default$3();
            x$5 = oldInfo.copy$default$4();
            x$6 = oldInfo.copy$default$5();
            x$7 = oldInfo.copy$default$6();
            var4_17 = oldInfo.copy(x$3, x$1, x$4, x$5, x$6, x$7, (Option<ReceiverErrorInfo>)x$2);
        } else if (None$.MODULE$.equals(var10_7)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$deregisterReceiver$1(), ()Ljava/lang/String;)());
            var4_17 = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
        } else {
            throw new MatchError((Object)var10_7);
        }
        newReceiverTrackingInfo = var4_17;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
        this.listenerBus().post(new StreamingListenerReceiverStopped(newReceiverTrackingInfo.toReceiverInfo()));
        messageWithError = error != null && error.isEmpty() == false ? new StringBuilder(3).append(message).append(" - ").append(error).toString() : String.valueOf(message);
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$deregisterReceiver$2(int java.lang.String ), ()Ljava/lang/String;)((int)streamId, (String)messageWithError));
    }

    public synchronized void sendRateUpdate(int streamUID, long newRate) {
        block0: {
            if (!this.isTrackerStarted()) break block0;
            this.endpoint().send((Object)new UpdateReceiverRateLimit(streamUID, newRate));
        }
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(ReceivedBlockInfo receivedBlockInfo) {
        return this.receivedBlockTracker().addBlock(receivedBlockInfo);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(int streamId, String message, String error) {
        ReceiverTrackingInfo receiverTrackingInfo;
        Option option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
        if (option instanceof Some) {
            Some some = (Some)option;
            ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.value();
            ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, BoxesRunTime.unboxToLong((Object)oldInfo.errorInfo().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.lastErrorTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
            Some x$1 = new Some((Object)errorInfo);
            int x$2 = oldInfo.copy$default$1();
            Enumeration.Value x$3 = oldInfo.copy$default$2();
            Option<Seq<TaskLocation>> x$42 = oldInfo.copy$default$3();
            Option<ExecutorCacheTaskLocation> x$5 = oldInfo.copy$default$4();
            Option<String> x$6 = oldInfo.copy$default$5();
            Option<RpcEndpointRef> x$7 = oldInfo.copy$default$6();
            receiverTrackingInfo = oldInfo.copy(x$2, x$3, x$42, x$5, x$6, x$7, (Option<ReceiverErrorInfo>)x$1);
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No prior receiver info");
            ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis());
            receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
        } else {
            throw new MatchError((Object)option);
        }
        ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
        this.listenerBus().post(new StreamingListenerReceiverError(newReceiverTrackingInfo.toReceiverInfo()));
        String messageWithError = error != null && !error.isEmpty() ? new StringBuilder(3).append(message).append(" - ").append(error).toString() : String.valueOf(message);
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Error reported by receiver for stream ").append(streamId).append(": ").append(messageWithError).toString());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TaskLocation> scheduleReceiver(int receiverId) {
        void var3_3;
        Option preferredLocation = (Option)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().getOrElse((Object)BoxesRunTime.boxToInteger((int)receiverId), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        Seq<TaskLocation> scheduledLocations = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiverId, (Option<String>)preferredLocation, (Map<Object, ReceiverTrackingInfo>)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiverId, scheduledLocations);
        return var3_3;
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(int receiverId, Seq<TaskLocation> scheduledLocations) {
        ReceiverTrackingInfo receiverTrackingInfo;
        Option option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)receiverId));
        if (option instanceof Some) {
            Some some = (Some)option;
            ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.value();
            Enumeration.Value x$1 = ReceiverState$.MODULE$.SCHEDULED();
            Some x$2 = new Some(scheduledLocations);
            int x$3 = oldInfo.copy$default$1();
            Option<ExecutorCacheTaskLocation> x$4 = oldInfo.copy$default$4();
            Option<String> x$5 = oldInfo.copy$default$5();
            Option<RpcEndpointRef> x$6 = oldInfo.copy$default$6();
            Option<ReceiverErrorInfo> x$7 = oldInfo.copy$default$7();
            receiverTrackingInfo = oldInfo.copy(x$3, x$1, (Option<Seq<TaskLocation>>)x$2, x$4, x$5, x$6, x$7);
        } else if (None$.MODULE$.equals(option)) {
            receiverTrackingInfo = new ReceiverTrackingInfo(receiverId, ReceiverState$.MODULE$.SCHEDULED(), (Option<Seq<TaskLocation>>)new Some(scheduledLocations), (Option<ExecutorCacheTaskLocation>)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7());
        } else {
            throw new MatchError((Object)option);
        }
        ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)receiverId), (Object)newReceiverTrackingInfo);
    }

    public boolean hasUnallocatedBlocks() {
        return this.receivedBlockTracker().hasUnallocatedReceivedBlocks();
    }

    public Seq<ExecutorCacheTaskLocation> org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors() {
        Seq seq;
        if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().isLocal()) {
            BlockManagerId blockManagerId = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().blockManagerId();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation(blockManagerId.host(), blockManagerId.executorId())}));
        } else {
            seq = ((TraversableOnce)((TraversableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().master().getMemoryStatus().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReceiverTracker.$anonfun$getExecutors$1(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                ExecutorCacheTaskLocation executorCacheTaskLocation = new ExecutorCacheTaskLocation(blockManagerId.host(), blockManagerId.executorId());
                return executorCacheTaskLocation;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        return seq;
    }

    private void runDummySparkJob() {
        Object object = !this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? RDD$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> ReceiverTracker.$anonfun$runDummySparkJob$1(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6, 20).collect() : BoxedUnit.UNIT;
        Predef$.MODULE$.assert(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().nonEmpty());
    }

    private void launchReceivers() {
        Receiver[] receivers = (Receiver[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).map((Function1 & Serializable & scala.Serializable)nis -> {
            void var1_1;
            Receiver rcvr = nis.getReceiver();
            rcvr.setReceiverId(nis.id());
            return var1_1;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
        this.runDummySparkJob();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Starting ").append(receivers.length).append(" receivers").toString());
        this.endpoint().send((Object)new StartAllReceivers((Seq<Receiver<?>>)Predef$.MODULE$.wrapRefArray((Object[])receivers)));
    }

    private boolean isTrackerStarted() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopping();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private final void TrackerState$lzycompute$1() {
        ReceiverTracker receiverTracker = this;
        synchronized (receiverTracker) {
            if (this.TrackerState$module == null) {
                this.TrackerState$module = new ReceiverTracker$TrackerState$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerReceiver$1(String executorId$1, String host$1, TaskLocation x0$1) {
        boolean bl;
        TaskLocation taskLocation = x0$1;
        if (taskLocation instanceof ExecutorCacheTaskLocation) {
            ExecutorCacheTaskLocation executorCacheTaskLocation = (ExecutorCacheTaskLocation)taskLocation;
            String string = executorCacheTaskLocation.executorId();
            String string2 = executorId$1;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else if (taskLocation != null) {
            TaskLocation taskLocation2 = taskLocation;
            String string = taskLocation2.host();
            String string3 = host$1;
            bl = !(string != null ? !string.equals(string3) : string3 != null);
        } else {
            throw new MatchError((Object)taskLocation);
        }
        return bl;
    }

    private static final boolean isAcceptable$1(Seq acceptableExecutors$1, String executorId$1, String host$1) {
        return acceptableExecutors$1.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReceiverTracker.$anonfun$registerReceiver$1(executorId$1, host$1, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$deregisterReceiver$1() {
        return "No prior receiver info";
    }

    public static final /* synthetic */ String $anonfun$deregisterReceiver$2(int streamId$2, String messageWithError$1) {
        return new StringBuilder(35).append("Deregistered receiver for stream ").append(streamId$2).append(": ").append(messageWithError$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getExecutors$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
        String string = blockManagerId.executorId();
        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$runDummySparkJob$1(int x) {
        return new Tuple2.mcII.sp(x, 1);
    }

    public ReceiverTracker(StreamingContext ssc, boolean skipReceiverLaunch) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        this.skipReceiverLaunch = skipReceiverLaunch;
        Logging.$init$((Logging)this);
        this.receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamIds = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.receivedBlockTracker = new ReceivedBlockTracker(ssc.sparkContext().conf(), ssc.sparkContext().hadoopConfiguration(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(this.receiverInputStreamIds()), ssc.scheduler().clock(), ssc.isCheckpointPresent(), (Option<String>)Option$.MODULE$.apply((Object)ssc.checkpointDir()));
        this.listenerBus = ssc.scheduler().listenerBus();
        this.trackerState = this.TrackerState().Initialized();
        this.endpoint = null;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy = new ReceiverSchedulingPolicy();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch = new CountDownLatch(this.receiverInputStreams().length);
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos = new HashMap();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations = new HashMap();
    }

    public class ReceiverTrackerEndpoint
    implements ThreadSafeRpcEndpoint {
        private final RpcEnv rpcEnv;
        private final ExecutionContextExecutorService org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool;
        private volatile boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active;
        public final /* synthetic */ ReceiverTracker $outer;

        public final RpcEndpointRef self() {
            return RpcEndpoint.self$((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            RpcEndpoint.onDisconnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.onStart$((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.stop$((RpcEndpoint)this);
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public ExecutionContextExecutorService org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool() {
            return this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool;
        }

        public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active() {
            return this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active;
        }

        private void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active_$eq(boolean x$1) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active = x$1;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof StartAllReceivers) {
                        StartAllReceivers startAllReceivers = (StartAllReceivers)A1;
                        Seq<Receiver<?>> receivers = startAllReceivers.receiver();
                        Map<Object, Seq<TaskLocation>> scheduledLocations = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().scheduleReceivers(receivers, this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        receivers.foreach((Function1 & Serializable & scala.Serializable)receiver -> {
                            ReceiverTrackerEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$1(this, scheduledLocations, receiver);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof RestartReceiver) {
                        Seq<TaskLocation> seq;
                        RestartReceiver restartReceiver = (RestartReceiver)A1;
                        Receiver<?> receiver2 = restartReceiver.receiver();
                        Seq<TaskLocation> oldScheduledExecutors = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(receiver2.streamId());
                        if (oldScheduledExecutors.nonEmpty()) {
                            seq = oldScheduledExecutors;
                        } else {
                            ReceiverTrackingInfo oldReceiverInfo = (ReceiverTrackingInfo)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiver2.streamId()));
                            Enumeration.Value x$1 = ReceiverState$.MODULE$.INACTIVE();
                            None$ x$2 = None$.MODULE$;
                            int x$3 = oldReceiverInfo.copy$default$1();
                            Option<ExecutorCacheTaskLocation> x$4 = oldReceiverInfo.copy$default$4();
                            Option<String> x$5 = oldReceiverInfo.copy$default$5();
                            Option<RpcEndpointRef> x$6 = oldReceiverInfo.copy$default$6();
                            Option<ReceiverErrorInfo> x$72 = oldReceiverInfo.copy$default$7();
                            ReceiverTrackingInfo newReceiverInfo = oldReceiverInfo.copy(x$3, x$1, (Option<Seq<TaskLocation>>)x$2, x$4, x$5, x$6, x$72);
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)receiver2.streamId()), (Object)newReceiverInfo);
                            seq = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiver2.streamId(), receiver2.preferredLocation(), (Map<Object, ReceiverTrackingInfo>)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        }
                        Seq<TaskLocation> scheduledLocations = seq;
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver2, scheduledLocations);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CleanupOldBlocks) {
                        CleanupOldBlocks cleanupOldBlocks = (CleanupOldBlocks)A1;
                        ((IterableLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> Option$.MODULE$.option2Iterable(x$7.endpoint()), scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                            ReceiverTrackerEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$3(cleanupOldBlocks, x$8);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof UpdateReceiverRateLimit) {
                        UpdateReceiverRateLimit updateReceiverRateLimit = (UpdateReceiverRateLimit)A1;
                        int streamUID = updateReceiverRateLimit.streamUID();
                        long newRate = updateReceiverRateLimit.newRate();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamUID)).foreach((Function1 & Serializable & scala.Serializable)info -> {
                            ReceiverTrackerEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$4(newRate, info);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError = (ReportError)A1;
                        int streamId = reportError.streamId();
                        String message = reportError.message();
                        String error = reportError.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof StartAllReceivers ? true : (object instanceof RestartReceiver ? true : (object instanceof CleanupOldBlocks ? true : (object instanceof UpdateReceiverRateLimit ? true : object instanceof ReportError)));
                    return bl;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$1(ReceiverTrackerEndpoint$$anonfun$receive$1 $this, Map scheduledLocations$1, Receiver receiver) {
                    Seq executors = (Seq)scheduledLocations$1.apply((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()));
                    $this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiver.streamId(), (Seq<TaskLocation>)executors);
                    $this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().update((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()), receiver.preferredLocation());
                    $this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver, (Seq<TaskLocation>)executors);
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$3(CleanupOldBlocks x6$1, RpcEndpointRef x$8) {
                    x$8.send((Object)x6$1);
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$5(long newRate$1, RpcEndpointRef eP) {
                    eP.send((Object)new UpdateRateLimit(newRate$1));
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$4(long newRate$1, ReceiverTrackingInfo info) {
                    info.endpoint().foreach((Function1 & Serializable & scala.Serializable)eP -> {
                        ReceiverTrackerEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$5(newRate$1, eP);
                        return BoxedUnit.UNIT;
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receive$1 scala.collection.Map org.apache.spark.streaming.receiver.Receiver ), $anonfun$applyOrElse$2(org.apache.spark.streaming.scheduler.ReceiverTrackingInfo ), $anonfun$applyOrElse$3$adapted(org.apache.spark.streaming.receiver.CleanupOldBlocks org.apache.spark.rpc.RpcEndpointRef ), $anonfun$applyOrElse$4$adapted(long org.apache.spark.streaming.scheduler.ReceiverTrackingInfo ), $anonfun$applyOrElse$5$adapted(long org.apache.spark.rpc.RpcEndpointRef )}, serializedLambda);
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                private final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver = (RegisterReceiver)A1;
                        int streamId = registerReceiver.streamId();
                        String typ = registerReceiver.typ();
                        String host = registerReceiver.host();
                        String executorId = registerReceiver.executorId();
                        RpcEndpointRef receiverEndpoint = registerReceiver.receiverEndpoint();
                        boolean successful = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(streamId, typ, host, executorId, receiverEndpoint, this.context$1.senderAddress());
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)successful));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        BoxedUnit boxedUnit;
                        AddBlock addBlock = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock.receivedBlockInfo();
                        if (WriteAheadLogUtils$.MODULE$.isBatchingEnabled(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf(), true)) {
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool().execute(() -> Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                if ($this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active()) {
                                    $this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)$this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)));
                                } else {
                                    $this.context$1.sendFailure((Throwable)new IllegalStateException("ReceiverTracker RpcEndpoint already shut down."));
                                }
                            }));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver.streamId();
                        String message = deregisterReceiver.msg();
                        String error = deregisterReceiver.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(streamId, message, error);
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else if (AllReceiverIds$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)((MapLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1.$anonfun$applyOrElse$8(x$9)))).keys().toSeq());
                        object = BoxedUnit.UNIT;
                    } else if (GetAllReceiverInfo$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().toMap(Predef$.MODULE$.$conforms()));
                        object = BoxedUnit.UNIT;
                    } else if (StopAllReceivers$.MODULE$.equals(A1)) {
                        Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped());
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers();
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlock ? true : (object instanceof DeregisterReceiver ? true : (AllReceiverIds$.MODULE$.equals(object) ? true : (GetAllReceiverInfo$.MODULE$.equals(object) ? true : StopAllReceivers$.MODULE$.equals(object)))));
                    return bl;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$8(Tuple2 x$9) {
                    Enumeration.Value value = ((ReceiverTrackingInfo)x$9._2()).state();
                    Enumeration.Value value2 = ReceiverState$.MODULE$.INACTIVE();
                    return value == null ? value2 != null : !value.equals(value2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8$adapted(scala.Tuple2 ), $anonfun$applyOrElse$7(org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1 org.apache.spark.streaming.scheduler.ReceivedBlockInfo )}, serializedLambda);
                }
            };
        }

        public Seq<TaskLocation> org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(int receiverId) {
            Nil$ nil$;
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().contains((Object)BoxesRunTime.boxToInteger((int)receiverId))) {
                Option<Seq<TaskLocation>> scheduledLocations = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiverId))).scheduledLocations();
                if (scheduledLocations.nonEmpty()) {
                    Set executors = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().toSet();
                    nil$ = (Seq)((TraversableLike)scheduledLocations.get()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReceiverTrackerEndpoint.$anonfun$getStoredScheduledExecutors$1(executors, x0$1)));
                } else {
                    nil$ = Nil$.MODULE$;
                }
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(Receiver<?> receiver, Seq<TaskLocation> scheduledLocations) {
            RDD rDD;
            int receiverId = receiver.streamId();
            if (!this.shouldStartReceiver$1()) {
                this.onReceiverJobFinish(receiverId);
                return;
            }
            Option checkpointDirOption = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.checkpointDir());
            SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().hadoopConfiguration());
            Function1 & Serializable & scala.Serializable startReceiverFunc = (Function1 & Serializable & scala.Serializable)iterator -> {
                ReceiverTrackerEndpoint.$anonfun$startReceiver$1(serializableHadoopConf, checkpointDirOption, iterator);
                return BoxedUnit.UNIT;
            };
            if (scheduledLocations.isEmpty()) {
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Receiver[]{receiver})), 1, ClassTag$.MODULE$.apply(Receiver.class));
            } else {
                Seq preferredLocations = (Seq)((SeqLike)scheduledLocations.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString(), Seq$.MODULE$.canBuildFrom())).distinct();
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(receiver), (Object)preferredLocations)})), ClassTag$.MODULE$.apply(Receiver.class));
            }
            RDD receiverRDD = rDD;
            receiverRDD.setName(new StringBuilder(9).append("Receiver ").append(receiverId).toString());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setJobDescription(new StringBuilder(31).append("Streaming job running receiver ").append(receiverId).toString());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setCallSite((CallSite)Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.getStartSite()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.getCallSite(Utils$.MODULE$.getCallSite$default$1())));
            SimpleFutureAction future = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().submitJob(receiverRDD, (Function1)startReceiverFunc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> {
                ReceiverTrackerEndpoint.$anonfun$startReceiver$4(BoxesRunTime.unboxToInt((Object)x$11), x$12);
                return BoxedUnit.UNIT;
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
            future.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ReceiverTrackerEndpoint.$anonfun$startReceiver$6(this, receiverId, receiver, x0$1);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Receiver ").append(receiver.streamId()).append(" started").toString());
        }

        public void onStop() {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active_$eq(false);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool().shutdown();
        }

        private void onReceiverJobFinish(int receiverId) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().countDown();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().remove((Object)BoxesRunTime.boxToInteger((int)receiverId)).foreach((Function1 & Serializable & scala.Serializable)receiverTrackingInfo -> {
                ReceiverTrackerEndpoint.$anonfun$onReceiverJobFinish$1(this, receiverId, receiverTrackingInfo);
                return BoxedUnit.UNIT;
            });
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers() {
            ((IterableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1 & Serializable & scala.Serializable)x$13 -> Option$.MODULE$.option2Iterable(x$13.endpoint()), scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                x$14.send((Object)StopReceiver$.MODULE$);
                return BoxedUnit.UNIT;
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sent stop signal to all ").append(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().size()).append(" receivers").toString());
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$getStoredScheduledExecutors$1(Set executors$1, TaskLocation x0$1) {
            boolean bl;
            TaskLocation taskLocation = x0$1;
            if (taskLocation instanceof ExecutorCacheTaskLocation) {
                ExecutorCacheTaskLocation executorCacheTaskLocation = (ExecutorCacheTaskLocation)taskLocation;
                bl = executors$1.apply((Object)executorCacheTaskLocation);
            } else if (taskLocation != null) {
                bl = true;
            } else {
                throw new MatchError((Object)taskLocation);
            }
            return bl;
        }

        private final boolean shouldStartReceiver$1() {
            return !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() && !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped();
        }

        public static final /* synthetic */ void $anonfun$startReceiver$1(SerializableConfiguration serializableHadoopConf$1, Option checkpointDirOption$1, Iterator iterator) {
            block1: {
                if (!iterator.hasNext()) {
                    throw new SparkException("Could not start receiver as object not found.");
                }
                if (TaskContext$.MODULE$.get().attemptNumber() != 0) break block1;
                Receiver receiver = (Receiver)iterator.next();
                Predef$.MODULE$.assert(!iterator.hasNext());
                ReceiverSupervisorImpl supervisor = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get(), serializableHadoopConf$1.value(), (Option<String>)checkpointDirOption$1);
                supervisor.start();
                supervisor.awaitTermination();
            }
        }

        public static final /* synthetic */ void $anonfun$startReceiver$4(int x$11, BoxedUnit x$12) {
        }

        public static final /* synthetic */ void $anonfun$startReceiver$6(ReceiverTrackerEndpoint $this, int receiverId$1, Receiver receiver$1, Try x0$1) {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                if (!$this.shouldStartReceiver$1()) {
                    $this.onReceiverJobFinish(receiverId$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Restarting Receiver ").append(receiverId$1).toString());
                    $this.self().send((Object)new RestartReceiver(receiver$1));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (!$this.shouldStartReceiver$1()) {
                    $this.onReceiverJobFinish(receiverId$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Receiver has been stopped. Try to restart it.", e);
                    $this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Restarting Receiver ").append(receiverId$1).toString());
                    $this.self().send((Object)new RestartReceiver(receiver$1));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError((Object)try_);
            }
        }

        public static final /* synthetic */ void $anonfun$onReceiverJobFinish$1(ReceiverTrackerEndpoint $this, int receiverId$2, ReceiverTrackingInfo receiverTrackingInfo) {
            block0: {
                Enumeration.Value value = receiverTrackingInfo.state();
                Enumeration.Value value2 = ReceiverState$.MODULE$.ACTIVE();
                if (value != null ? !value.equals(value2) : value2 != null) break block0;
                $this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Receiver ").append(receiverId$2).append(" exited but didn't deregister").toString());
            }
        }

        public ReceiverTrackerEndpoint(ReceiverTracker $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.$init$((RpcEndpoint)this);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("wal-batching-thread-pool"));
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active = true;
        }
    }
}

