/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mapping.MappingValueRename;
import org.w3c.dom.Node;

public class MappingIODefinition
implements Cloneable {
    public static final String XML_TAG = "mapping";
    private TransformMeta inputTransform;
    private String inputTransformName = null;
    private String outputTransformName = null;
    private String description;
    private List<MappingValueRename> valueRenames = new ArrayList<MappingValueRename>();
    private boolean mainDataPath = false;
    private boolean renamingOnOutput = false;

    public MappingIODefinition() {
    }

    public MappingIODefinition(String inputTransformName, String outputTransformName) {
        this();
        this.inputTransformName = inputTransformName;
        this.outputTransformName = outputTransformName;
    }

    public Object clone() {
        try {
            MappingIODefinition definition = (MappingIODefinition)super.clone();
            return definition;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public MappingIODefinition(Node mappingNode) {
        this();
        this.inputTransformName = XmlHandler.getTagValue((Node)mappingNode, (String)"input_transform");
        this.outputTransformName = XmlHandler.getTagValue((Node)mappingNode, (String)"output_transform");
        this.mainDataPath = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)mappingNode, (String)"main_path"));
        this.renamingOnOutput = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)mappingNode, (String)"rename_on_output"));
        this.description = XmlHandler.getTagValue((Node)mappingNode, (String)"description");
        int nrConnectors = XmlHandler.countNodes((Node)mappingNode, (String)"connector");
        for (int i = 0; i < nrConnectors; ++i) {
            Node inputConnector = XmlHandler.getSubNodeByNr((Node)mappingNode, (String)"connector", (int)i);
            String parentField = XmlHandler.getTagValue((Node)inputConnector, (String)"parent");
            String childField = XmlHandler.getTagValue((Node)inputConnector, (String)"child");
            this.valueRenames.add(new MappingValueRename(parentField, childField));
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(200);
        xml.append("    ").append(XmlHandler.openTag((String)XML_TAG));
        xml.append("    ").append(XmlHandler.addTagValue((String)"input_transform", (String)this.inputTransformName));
        xml.append("    ").append(XmlHandler.addTagValue((String)"output_transform", (String)this.outputTransformName));
        xml.append("    ").append(XmlHandler.addTagValue((String)"main_path", (boolean)this.mainDataPath));
        xml.append("    ").append(XmlHandler.addTagValue((String)"rename_on_output", (boolean)this.renamingOnOutput));
        xml.append("    ").append(XmlHandler.addTagValue((String)"description", (String)this.description));
        for (MappingValueRename valueRename : this.valueRenames) {
            xml.append("       ").append(XmlHandler.openTag((String)"connector"));
            xml.append(XmlHandler.addTagValue((String)"parent", (String)valueRename.getSourceValueName(), (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)"child", (String)valueRename.getTargetValueName(), (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.closeTag((String)"connector")).append(Const.CR);
        }
        xml.append("    ").append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public String getInputTransformName() {
        return this.inputTransformName;
    }

    public void setInputTransformName(String inputTransformName) {
        this.inputTransformName = inputTransformName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOutputTransformName() {
        return this.outputTransformName;
    }

    public void setOutputTransformName(String outputTransformName) {
        this.outputTransformName = outputTransformName;
    }

    public boolean isMainDataPath() {
        return this.mainDataPath;
    }

    public void setMainDataPath(boolean mainDataPath) {
        this.mainDataPath = mainDataPath;
    }

    public boolean isRenamingOnOutput() {
        return this.renamingOnOutput;
    }

    public void setRenamingOnOutput(boolean renamingOnOutput) {
        this.renamingOnOutput = renamingOnOutput;
    }

    public List<MappingValueRename> getValueRenames() {
        return this.valueRenames;
    }

    public void setValueRenames(List<MappingValueRename> valueRenames) {
        this.valueRenames = valueRenames;
    }

    public TransformMeta getInputTransform() {
        return this.inputTransform;
    }

    public void setInputTransform(TransformMeta inputTransform) {
        this.inputTransform = inputTransform;
    }
}

