/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Hex;

public class LanHeader {
    private Field llc;
    private String protocol;
    private String frameformat;
    private Field lanroutel;
    private Field eth2sourcemac;
    private Field eth2destmac;
    private Field eth2frametypeh;
    private Field eth2frametype;
    private Field ethsourcemac;
    private Field ethdestmac;
    private Field ethsaps;
    private Field ethframetypeh;
    private Field ethframetype;
    private Field trnsourcemac;
    private Field trndestmac;
    private Field trnrouteinfo;
    private Field trnsaps;
    private Field trnframetypeh;
    private Field trnframetype;
    private Field frametype;
    private Field sourcemac;
    private Field destmac;

    LanHeader(BitBuf bitBuf, Field field, String string) {
        this.llc = field;
        this.protocol = string;
        this.lanroutel = new Dec(bitBuf.slice(160, 8));
        this.eth2destmac = new Hex(bitBuf.slice(176, 48));
        this.eth2sourcemac = new Hex(bitBuf.slice(224, 48));
        this.eth2frametypeh = new Hex(bitBuf.slice(272, 16));
        this.eth2frametype = new Dec(bitBuf.slice(272, 16));
        this.ethdestmac = new Hex(bitBuf.slice(176, 48));
        this.ethsourcemac = new Hex(bitBuf.slice(224, 48));
        this.ethsaps = new Hex(bitBuf.slice(288, 16));
        this.ethframetypeh = new Hex(bitBuf.slice(336, 16));
        this.ethframetype = new Dec(bitBuf.slice(336, 16));
        this.trndestmac = new Hex(bitBuf.slice(192, 48));
        this.trnsourcemac = new Hex(bitBuf.slice(240, 48));
        this.trnrouteinfo = new Hex(bitBuf.slice(288, Integer.parseInt(this.lanroutel.toString()) * 8));
        this.trnsaps = new Hex(bitBuf.slice(288 + Integer.parseInt(this.lanroutel.toString()) * 8, 16));
        this.trnframetypeh = new Hex(bitBuf.slice(288 + Integer.parseInt(this.lanroutel.toString()) * 8 + 48, 16));
        this.trnframetype = new Dec(bitBuf.slice(288 + Integer.parseInt(this.lanroutel.toString()) * 8 + 48, 16));
    }

    public int getDataStart() {
        if (this.llc.toString().equals("0xFF")) {
            if (this.protocol.equals("E")) {
                return Integer.parseInt(this.lanroutel.toString()) * 8 + 176;
            }
            return 176;
        }
        return 112;
    }

    public int getFrameType() {
        this.frametype = this.llc.toString().equals("0xFF") ? (this.protocol.equals("E") ? this.trnframetype : this.ethframetype) : this.eth2frametype;
        return Integer.parseInt(this.frametype.toString());
    }

    public String getMacAddress() {
        this.destmac = this.llc.toString().equals("0xFF") ? (this.protocol.equals("E") ? this.trndestmac : this.ethdestmac) : this.eth2destmac;
        return this.destmac.toString();
    }

    public String printRoutingData() {
        Object[] objectArray = new Object[]{this.trnrouteinfo.toString()};
        return Formatter.jsprintf("     Routing Info: {0,14,L} \n", objectArray);
    }

    public String toString() {
        if (this.llc.toString().equals("0xFF")) {
            if (this.protocol.equals("E")) {
                this.sourcemac = this.trnsourcemac;
                this.destmac = this.trndestmac;
                this.frametype = this.trnframetypeh;
                this.frameformat = "LLC";
            } else {
                this.sourcemac = this.ethsourcemac;
                this.destmac = this.ethdestmac;
                this.frametype = this.ethframetypeh;
                this.frameformat = "802.3";
            }
        } else {
            this.sourcemac = this.eth2sourcemac;
            this.destmac = this.eth2destmac;
            this.frametype = this.eth2frametypeh;
            this.frameformat = "ETHV2";
        }
        Object[] objectArray = new Object[]{this.destmac.toString(), this.sourcemac.toString(), this.frameformat, this.frametype.toString()};
        return Formatter.jsprintf("\t\t  {0,14,L}  {1,14,L}   {2,5,L}   Type: {3,2,l}\n", objectArray);
    }

    public String getLanRouteLength() {
        return this.lanroutel.toString();
    }

    public String getEth2DestMacAddress() {
        return this.eth2destmac.toString();
    }

    public String getEth2SrcMacAddress() {
        return this.eth2sourcemac.toString();
    }

    public String getEthDestMacAddress() {
        return this.ethdestmac.toString();
    }

    public String getEthSrcMacAddress() {
        return this.ethsourcemac.toString();
    }

    public String getEthSaps() {
        return new Dec(this.ethsaps.getData()).toString();
    }

    public String getEthFrameType() {
        return this.ethframetype.toString();
    }

    public String getTrnDestMacAddress() {
        return this.trndestmac.toString();
    }

    public String getTrnSrcMacAddress() {
        return this.trnsourcemac.toString();
    }

    public String getTrnRouteInfo() {
        return new Dec(this.trnrouteinfo.getData()).toString();
    }

    public String getTrnSaps() {
        return new Dec(this.trnsaps.getData()).toString();
    }

    public String getTrnFrameType() {
        return this.trnframetype.toString();
    }
}

