/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DBCellRenderer;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.RecordListTableModel;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RecordListTablePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int KEY_EQ = 0;
    public static final int KEY_GT = 1;
    public static final int KEY_GE = 2;
    public static final int KEY_LT = 3;
    public static final int KEY_LE = 4;
    transient JTable table_;
    transient JScrollPane tablePane_;
    RecordListTableModel model_;
    private Color tableColor_ = null;
    private boolean tableShowHorizontalLines_ = true;
    private boolean tableShowVerticalLines_ = true;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient ListSelectionEventSupport selectionListeners_ = new ListSelectionEventSupport(this);
    private transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    DBCellRenderer rightCell_ = new DBCellRenderer(4);
    DBCellRenderer leftCell_ = new DBCellRenderer(2);
    private static final int TYPE_CHAR = 1;
    private static final int TYPE_HEX = 2;
    private static final int TYPE_NUMBER = 3;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Double;

    public RecordListTablePane() {
        this.model_ = new RecordListTableModel();
        this.initializeTransient();
    }

    public RecordListTablePane(AS400 aS400, String string) {
        this.model_ = new RecordListTableModel(aS400, string);
        this.initializeTransient();
    }

    public RecordListTablePane(AS400 aS400, String string, Object[] objectArray, int n) {
        this.model_ = new RecordListTableModel(aS400, string, objectArray, n);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionListeners_.addListSelectionListener(listSelectionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.addPropertyChangeListener(propertyChangeListener);
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.addVetoableChangeListener(vetoableChangeListener);
        super.addVetoableChangeListener(vetoableChangeListener);
    }

    public void close() {
        this.model_.close();
    }

    public TableColumnModel getColumnModel() {
        return this.table_.getColumnModel();
    }

    public String getColumnTitle(int n) {
        try {
            return (String)this.table_.getColumnModel().getColumn(n).getHeaderValue();
        }
        catch (Exception exception) {
            Trace.log(4, "getColumnTitle() error:" + exception);
            return null;
        }
    }

    public int getColumnWidth(int n) {
        try {
            return this.table_.getColumnModel().getColumn(n).getPreferredWidth();
        }
        catch (Exception exception) {
            Trace.log(4, "getColumnWidth() error:" + exception);
            return 0;
        }
    }

    public RecordListTableModel getDataModel() {
        return this.model_;
    }

    public String getFileName() {
        return this.model_.getFileName();
    }

    public Color getGridColor() {
        return this.tableColor_;
    }

    public Object[] getKey() {
        return this.model_.getKey();
    }

    public boolean getKeyed() {
        return this.model_.getKeyed();
    }

    public int getSearchType() {
        return this.model_.getSearchType();
    }

    public ListSelectionModel getSelectionModel() {
        return this.table_.getSelectionModel();
    }

    public boolean getShowHorizontalLines() {
        return this.tableShowHorizontalLines_;
    }

    public boolean getShowVerticalLines() {
        return this.tableShowVerticalLines_;
    }

    public AS400 getSystem() {
        return this.model_.getSystem();
    }

    public String getStringValueAt(int n, int n2) {
        if (n >= this.model_.getRowCount()) {
            Trace.log(4, "getStringValueAt() column out of range");
            return null;
        }
        try {
            TableColumnModel tableColumnModel = this.getColumnModel();
            Component component = tableColumnModel.getColumn(n2).getCellRenderer().getTableCellRendererComponent(this.table_, this.getValueAt(n, n2), false, false, n, n2);
            if (component instanceof JLabel) {
                return ((JLabel)component).getText();
            }
            return null;
        }
        catch (Exception exception) {
            Trace.log(4, "getStringValueAt() error:" + exception);
            return null;
        }
    }

    public Object getValueAt(int n, int n2) {
        try {
            return this.model_.getValueAt(n, this.getColumnModel().getColumn(n2).getModelIndex());
        }
        catch (Exception exception) {
            Trace.log(4, "getStringValueAt() error:" + exception);
            return null;
        }
    }

    private void initializeTransient() {
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setModel(this.model_);
        this.table_.setAutoResizeMode(0);
        if (this.tableColor_ == null) {
            this.tableColor_ = this.table_.getGridColor();
        }
        this.model_.addPropertyChangeListener(this.changeListeners_);
        this.model_.addVetoableChangeListener(this.vetoListeners_);
        this.model_.addErrorListener(this.errorListeners_);
        this.model_.addWorkingListener(this.worker_);
        this.table_.getSelectionModel().addListSelectionListener(this.selectionListeners_);
        this.setLayout(new BorderLayout());
        this.tablePane_ = new JScrollPane(this.table_);
        this.add("Center", this.tablePane_);
        this.addFocusListener(new SerializationListener(this));
        this.addFocusListener(new SerializationListener(this.model_, this.table_));
    }

    public void load() {
        this.model_.load();
        this.refreshHeadings();
    }

    public void moveColumn(int n, int n2) {
        try {
            this.table_.getColumnModel().moveColumn(n, n2);
        }
        catch (Exception exception) {
            Trace.log(4, "moveColumn() error:" + exception);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.model_.addPropertyChangeListener(this.changeListeners_);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.model_.addVetoableChangeListener(this.vetoListeners_);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.model_.addErrorListener(this.errorListeners_);
        this.worker_ = new WorkingCursorAdapter(this);
        this.model_.addWorkingListener(this.worker_);
        this.selectionListeners_ = new ListSelectionEventSupport(this);
        this.initializeTransient();
        this.table_.setGridColor(this.tableColor_);
        this.table_.setShowHorizontalLines(this.tableShowHorizontalLines_);
        this.table_.setShowVerticalLines(this.tableShowVerticalLines_);
    }

    public void refreshHeadings() {
        Runnable runnable = new Runnable(){

            public void run() {
                TableColumnModel tableColumnModel = RecordListTablePane.this.table_.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                TableColumn[] tableColumnArray = new TableColumn[n];
                Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    tableColumnArray[n2] = enumeration.nextElement();
                    ++n2;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    tableColumnModel.removeColumn(tableColumnArray[n2]);
                }
                n2 = RecordListTablePane.this.model_.getColumnCount();
                Class<?> clazz = new byte[0].getClass();
                int n3 = 0;
                if (RecordListTablePane.this.table_.getFont() != null) {
                    n3 = ((Component)RecordListTablePane.this.table_).getFontMetrics(RecordListTablePane.this.table_.getFont()).charWidth('M');
                }
                for (int i = 0; i < n2; ++i) {
                    TableColumn tableColumn = new TableColumn(i);
                    tableColumn.setIdentifier(RecordListTablePane.this.model_.getColumnID(i));
                    Class clazz2 = RecordListTablePane.this.model_.getColumnClass(i);
                    int n4 = clazz2 == (class$java$lang$Integer == null ? RecordListTablePane.class$("java.lang.Integer") : class$java$lang$Integer) || clazz2 == (class$java$lang$Short == null ? RecordListTablePane.class$("java.lang.Short") : class$java$lang$Short) || clazz2 == (class$java$lang$Float == null ? RecordListTablePane.class$("java.lang.Float") : class$java$lang$Float) || clazz2 == (class$java$math$BigDecimal == null ? RecordListTablePane.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || clazz2 == (class$java$lang$Double == null ? RecordListTablePane.class$("java.lang.Double") : class$java$lang$Double) ? 3 : (clazz2 == clazz ? 2 : 1);
                    String string = RecordListTablePane.this.model_.getColumnName(i);
                    if (n4 == 3) {
                        tableColumn.setCellRenderer(RecordListTablePane.this.rightCell_);
                        tableColumn.setHeaderRenderer(new VObjectHeaderRenderer(string, 4));
                    } else {
                        tableColumn.setCellRenderer(RecordListTablePane.this.leftCell_);
                        tableColumn.setHeaderRenderer(new VObjectHeaderRenderer(string, 2));
                    }
                    if (n3 != 0) {
                        int n5;
                        int n6 = RecordListTablePane.this.model_.getColumnWidth(i);
                        if (n4 == 2) {
                            n6 *= 2;
                        }
                        int n7 = n6 > (n5 = string.length()) ? n6 : n5;
                        tableColumn.setPreferredWidth(n7 * n3 + 10);
                    }
                    RecordListTablePane.this.table_.addColumn(tableColumn);
                }
                if (n == 0 && n2 > 0) {
                    if (RecordListTablePane.this.tablePane_ != null) {
                        RecordListTablePane.this.remove(RecordListTablePane.this.tablePane_);
                    }
                    RecordListTablePane.this.tablePane_ = new JScrollPane(RecordListTablePane.this.table_);
                    RecordListTablePane.this.add("Center", RecordListTablePane.this.tablePane_);
                }
                RecordListTablePane.this.validate();
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Error error) {
            Trace.log(1, "invokeAndWait error:" + error);
            runnable.run();
        }
        catch (Exception exception) {
            Trace.log(2, "invokeAndWait exception:" + exception);
        }
    }

    public void removeColumn(int n) {
        try {
            this.table_.getColumnModel().removeColumn(this.table_.getColumnModel().getColumn(n));
        }
        catch (Exception exception) {
            Trace.log(4, "removeColumn() error:" + exception);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionListeners_.removeListSelectionListener(listSelectionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.removePropertyChangeListener(propertyChangeListener);
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.removeVetoableChangeListener(vetoableChangeListener);
        super.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setColumnTitle(int n, String string) {
        try {
            this.table_.getColumnModel().getColumn(n).setHeaderValue(string);
        }
        catch (Exception exception) {
            Trace.log(4, "setColumnTitle() error:" + exception);
        }
        this.validate();
    }

    public void setColumnWidth(int n, int n2) {
        try {
            this.table_.getColumnModel().getColumn(n).setPreferredWidth(n2);
        }
        catch (Exception exception) {
            Trace.log(4, "setColumnWidth() error:" + exception);
        }
    }

    public void setFileName(String string) throws PropertyVetoException {
        this.model_.setFileName(string);
    }

    public void setGridColor(Color color) {
        this.table_.setGridColor(color);
        this.tableColor_ = color;
    }

    public void setKey(Object[] objectArray) throws PropertyVetoException {
        this.model_.setKey(objectArray);
    }

    public void setKeyed(boolean bl) throws PropertyVetoException {
        this.model_.setKeyed(bl);
    }

    public void setSearchType(int n) throws PropertyVetoException {
        this.model_.setSearchType(n);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this.table_.getSelectionModel().removeListSelectionListener(this.selectionListeners_);
        this.table_.setSelectionModel(listSelectionModel);
        this.table_.getSelectionModel().addListSelectionListener(this.selectionListeners_);
    }

    public void setShowHorizontalLines(boolean bl) {
        this.table_.setShowHorizontalLines(bl);
        this.tableShowHorizontalLines_ = bl;
    }

    public void setShowVerticalLines(boolean bl) {
        this.table_.setShowVerticalLines(bl);
        this.tableShowVerticalLines_ = bl;
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        this.model_.setSystem(aS400);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

