/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.api.client.util.Joiner;
import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.BigtableSession;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;

@InternalApi(value="For internal usage only")
public class BigtableVersionInfo {
    private static final Logger LOG = new Logger(BigtableVersionInfo.class);
    private static final AtomicBoolean wasInitialized = new AtomicBoolean(false);
    public static final String CLIENT_VERSION = "1.25.1";
    public static final String JDK_VERSION = BigtableVersionInfo.getJavaVersion();
    public static final String CORE_USER_AGENT = "bigtable-1.25.1,jdk-" + JDK_VERSION;

    private static String getJavaVersion() {
        return System.getProperty("java.specification.version");
    }

    public static String getVersion() {
        if (wasInitialized.compareAndSet(false, true)) {
            BigtableVersionInfo.warnOnVersionConflict();
        }
        return CLIENT_VERSION;
    }

    private static void warnOnVersionConflict() {
        ArrayList<URL> classResources;
        String knownClassResourcePath = BigtableSession.class.getName().replaceAll("\\.", "/") + ".class";
        try {
            classResources = Collections.list(ClassLoader.getSystemResources(knownClassResourcePath));
        }
        catch (IOException e) {
            LOG.warn("Failed to probe for client version conflicts", e, new Object[0]);
            return;
        }
        if (classResources.size() != 1) {
            LOG.warn("Found multiple copies of the bigtable-client-core on the classpath: " + Joiner.on((char)',').join(classResources), new Object[0]);
        }
    }
}

