/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.grpc.io.Watchdog;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.Set;

@InternalApi(value="For internal usage only")
public class WatchdogInterceptor
implements ClientInterceptor {
    private final Set<MethodDescriptor<?, ?>> watchedMethods;
    private final Watchdog watchdog;

    public WatchdogInterceptor(Set<MethodDescriptor<?, ?>> watchedMethods, Watchdog watchdog) {
        this.watchedMethods = watchedMethods;
        this.watchdog = watchdog;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        ClientCall call = channel.newCall(methodDescriptor, callOptions);
        if (this.watchedMethods.contains(methodDescriptor)) {
            call = this.watchdog.watch(call);
        }
        return call;
    }
}

