/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engines.local;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.map.DatabaseConnectionMap;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineCapabilities;
import org.apache.hop.pipeline.engine.PipelineEnginePlugin;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngineCapabilities;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;

@PipelineEnginePlugin(id="Local", name="Hop local pipeline engine", description="Executes your pipeline locally in a multi-threaded fashion")
public class LocalPipelineEngine
extends Pipeline
implements IPipelineEngine<PipelineMeta> {
    private PipelineEngineCapabilities engineCapabilities = new LocalPipelineEngineCapabilities();

    public LocalPipelineEngine() {
        this.setDefaultRunConfiguration();
    }

    public LocalPipelineEngine(PipelineMeta pipelineMeta) {
        super(pipelineMeta);
        this.setDefaultRunConfiguration();
    }

    public LocalPipelineEngine(PipelineMeta pipelineMeta, IVariables variables, ILoggingObject parent) {
        super(pipelineMeta, variables, parent);
        this.setDefaultRunConfiguration();
    }

    public <Parent extends IVariables & INamedParameters> LocalPipelineEngine(Parent parent, String name, String filename, IHopMetadataProvider metadataProvider) throws HopException {
        super(parent, name, filename, metadataProvider);
        this.setDefaultRunConfiguration();
    }

    @Override
    public IPipelineEngineRunConfiguration createDefaultPipelineEngineRunConfiguration() {
        return new LocalPipelineRunConfiguration();
    }

    private void setDefaultRunConfiguration() {
        this.setPipelineRunConfiguration(new PipelineRunConfiguration("local", "", new ArrayList<DescribedVariable>(), this.createDefaultPipelineEngineRunConfiguration()));
    }

    @Override
    public void prepareExecution() throws HopException {
        if (!(this.pipelineRunConfiguration.getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration)) {
            throw new HopException("A local pipeline execution expects a local pipeline configuration, not an instance of class " + this.pipelineRunConfiguration.getEngineRunConfiguration().getClass().getName());
        }
        LocalPipelineRunConfiguration config = (LocalPipelineRunConfiguration)this.pipelineRunConfiguration.getEngineRunConfiguration();
        int sizeRowsSet = Const.toInt((String)this.resolve(config.getRowSetSize()), (int)10000);
        this.setRowSetSize(sizeRowsSet);
        this.setSafeModeEnabled(config.isSafeModeEnabled());
        this.setSortingTransformsTopologically(config.isSortingTransformsTopologically());
        this.setGatheringMetrics(config.isGatheringMetrics());
        this.setFeedbackShown(config.isFeedbackShown());
        this.setFeedbackSize(Const.toInt((String)this.resolve(config.getFeedbackSize()), (int)50000));
        Object parentExtensionData = this.getParentPipeline();
        if (parentExtensionData == null) {
            parentExtensionData = this.getParentWorkflow();
        }
        Object connectionGroup = null;
        if (parentExtensionData != null) {
            connectionGroup = (String)parentExtensionData.getExtensionDataMap().get("CONNECTION_GROUP");
        }
        if (config.isTransactional() && connectionGroup == null) {
            connectionGroup = this.getPipelineMeta().getName() + " - " + UUID.randomUUID();
            this.addExecutionFinishedListener((T pipeline) -> {
                String group = (String)pipeline.getExtensionDataMap().get("CONNECTION_GROUP");
                List databases = DatabaseConnectionMap.getInstance().getDatabases(group);
                Result result = pipeline.getResult();
                for (Database database : databases) {
                    block13: {
                        try {
                            if (result.getResult() && !result.isStopped() && result.getNrErrors() == 0L) {
                                try {
                                    database.commit(true);
                                    pipeline.getLogChannel().logBasic("All transactions of database connection '" + database.getDatabaseMeta().getName() + "' were committed at the end of the pipeline!");
                                    break block13;
                                }
                                catch (HopDatabaseException e) {
                                    throw new HopException("Error committing database connection " + database.getDatabaseMeta().getName(), (Throwable)e);
                                }
                            }
                            try {
                                database.rollback(true);
                                pipeline.getLogChannel().logBasic("All transactions of database connection '" + database.getDatabaseMeta().getName() + "' were rolled back at the end of the pipeline!");
                            }
                            catch (HopDatabaseException e) {
                                throw new HopException("Error rolling back database connection " + database.getDatabaseMeta().getName(), (Throwable)e);
                            }
                        }
                        finally {
                            try {
                                database.closeConnectionOnly();
                                pipeline.getLogChannel().logDebug("Database connection '" + database.getDatabaseMeta().getName() + "' closed successfully!");
                            }
                            catch (HopDatabaseException hde) {
                                pipeline.getLogChannel().logError("Error disconnecting from database - closeConnectionOnly failed:" + Const.CR + hde.getMessage());
                                pipeline.getLogChannel().logError(Const.getStackTracker((Throwable)hde));
                            }
                        }
                    }
                    DatabaseConnectionMap.getInstance().removeConnection(group, null, database);
                }
            });
        }
        if (connectionGroup != null && this.getExtensionDataMap() != null) {
            this.getExtensionDataMap().put("CONNECTION_GROUP", connectionGroup);
        }
        super.prepareExecution();
    }

    @Override
    public PipelineEngineCapabilities getEngineCapabilities() {
        return this.engineCapabilities;
    }

    public void setEngineCapabilities(PipelineEngineCapabilities engineCapabilities) {
        this.engineCapabilities = engineCapabilities;
    }

    @Override
    public String getStatusDescription() {
        return super.getStatus();
    }
}

