/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.server.HttpUtil;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.HopServerWorkflowStatus;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.WebResult;
import org.apache.hop.www.WorkflowMap;
import org.owasp.encoder.Encode;

@HopServerServlet(id="workflowStatus", name="Get the status of a workflow")
public class GetWorkflowStatusServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = GetWorkflowStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/workflowStatus";
    private static final byte[] XML_HEADER = XmlHandler.getXmlHeader((String)"UTF-8").getBytes(Charset.forName("UTF-8"));

    public GetWorkflowStatusServlet() {
    }

    public GetWorkflowStatusServlet(WorkflowMap workflowMap) {
        super(workflowMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IWorkflowEngine<WorkflowMeta> workflow;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetWorkflowStatusServlet.Log.WorkflowStatusRequested", (String[])new String[0]));
        }
        String workflowName = request.getParameter("name");
        String id = request.getParameter("id");
        String root = request.getRequestURI() == null ? "/hop" : request.getRequestURI().substring(0, request.getRequestURI().indexOf(CONTEXT_PATH));
        Object prefix = this.isJettyMode() ? "/static" : root + "/content/common-ui/resources/themes";
        boolean useXml = "Y".equalsIgnoreCase(request.getParameter("xml"));
        boolean useJson = "Y".equalsIgnoreCase(request.getParameter("json"));
        int startLineNr = Const.toInt((String)request.getParameter("from"), (int)0);
        response.setStatus(200);
        if (useXml) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        }
        if (useJson) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        if (Utils.isEmpty((CharSequence)id)) {
            HopServerObjectEntry entry = this.getWorkflowMap().getFirstHopServerObjectEntry(workflowName);
            if (entry == null) {
                workflow = null;
            } else {
                id = entry.getId();
                workflow = this.getWorkflowMap().getWorkflow(entry);
            }
        } else if (Utils.isEmpty((CharSequence)workflowName)) {
            workflow = this.getWorkflowMap().findWorkflow(id);
        } else {
            HopServerObjectEntry entry = new HopServerObjectEntry(workflowName, id);
            workflow = this.getWorkflowMap().getWorkflow(entry);
            if (workflow != null) {
                workflowName = workflow.getWorkflowName();
            }
        }
        if (workflow != null) {
            if (useXml || useJson) {
                try {
                    int lastLineNr = HopLogStore.getLastBufferLineNr();
                    String logText = this.getLogText(workflow, startLineNr, lastLineNr);
                    HopServerWorkflowStatus workflowStatus = new HopServerWorkflowStatus(workflowName, id, workflow.getStatusDescription());
                    workflowStatus.setFirstLoggingLineNr(startLineNr);
                    workflowStatus.setLastLoggingLineNr(lastLineNr);
                    workflowStatus.setLogDate(workflow.getExecutionStartDate());
                    String loggingString = HttpUtil.encodeBase64ZippedString((String)logText);
                    workflowStatus.setLoggingString(loggingString);
                    workflowStatus.setResult(workflow.getResult());
                    ServletOutputStream out = response.getOutputStream();
                    if (useXml) {
                        String xml = workflowStatus.getXml();
                        byte[] data = xml.getBytes(Charset.forName("UTF-8"));
                        response.setContentLength(XML_HEADER.length + data.length);
                        out.write(XML_HEADER);
                        out.write(data);
                    } else {
                        ObjectMapper mapper = new ObjectMapper();
                        String jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)workflowStatus);
                        byte[] data = jsonString.getBytes(Charset.forName("UTF-8"));
                        response.setContentLength(data.length);
                        out.write(data);
                    }
                    out.flush();
                    response.flushBuffer();
                }
                catch (HopException e) {
                    throw new ServletException("Unable to get the workflow status in XML or JSON format", (Throwable)e);
                }
            }
            PrintWriter out = response.getWriter();
            int lastLineNr = HopLogStore.getLastBufferLineNr();
            int tableBorder = 0;
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"GetWorkflowStatusServlet.HopWorkflowStatus", (String[])new String[0]) + "</TITLE>");
            if (EnvUtil.getSystemProperty((String)"HOP_SERVER_REFRESH_STATUS", (String)"N").equalsIgnoreCase("Y")) {
                out.println("<META http-equiv=\"Refresh\" content=\"10;url=" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(Const.NVL((String)workflowName, (String)""), "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">");
            }
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            if (this.isJettyMode()) {
                out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/css/hop-server.css\" />");
            }
            out.println("</HEAD>");
            out.println("<BODY style=\"overflow: auto;\">");
            out.println("<div class=\"row\" id=\"pucHeader\">");
            out.println("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 10px;\">" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"GetWorkflowStatusServlet.WorkflowStatus", (String[])new String[]{workflowName})) + "</div>");
            out.println("</div>");
            try {
                out.println("<div class=\"row\" style=\"padding: 0px 0px 0px 30px\">");
                out.println("<div class=\"row\" style=\"padding-top: 30px;\">");
                out.print("<a href=\"" + this.convertContextPath("/hop/status") + "\">");
                out.print("<img src=\"" + (String)prefix + "/images/back.svg\" style=\"margin-right: 5px; width: 16px; height: 16px; vertical-align: middle;\">");
                out.print(BaseMessages.getString(PKG, (String)"HopServerStatusServlet.BackToHopServerStatus", (String[])new String[0]) + "</a>");
                out.println("</div>");
                out.println("<div class=\"row\" style=\"padding: 30px 0px 75px 0px; display: table;\">");
                out.println("<div style=\"display: table-row;\">");
                out.println("<div style=\"padding: 0px 30px 0px 0px; width: 60px; display: table-cell; vertical-align: top;\">");
                out.println("<img src=\"" + (String)prefix + "/images/workflow.svg\" style=\"width: 60px; height: 60px;\"></img>");
                out.println("</div>");
                out.println("<div style=\"vertical-align: top; display: table-cell;\">");
                out.println("<table style=\"border-collapse: collapse;\" border=\"" + tableBorder + "\">");
                out.print("<tr class=\"cellTableRow\" style=\"border: solid; border-width: 1px 0; border-top: none; border-color: #E3E3E3; font-size: 12; text-align: left;\"> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.ServerObjectId", (String[])new String[0]) + "</th> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.PipelineStatus", (String[])new String[0]) + "</th> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.StartDate", (String[])new String[0]) + "</th> </tr>");
                out.print("<tr class=\"cellTableRow\" style=\"border: solid; border-width: 1px 0; border-bottom: none; font-size: 12; text-align:left\">");
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell cellTableFirstColumn\">" + Const.NVL((String)Encode.forHtml((String)id), (String)"") + "</td>");
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell\" id=\"statusColor\" style=\"font-weight: bold;\">" + workflow.getStatusDescription() + "</td>");
                String dateStr = XmlHandler.date2string((Date)workflow.getExecutionStartDate());
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell cellTableLastColumn\">" + (dateStr != null ? dateStr.substring(0, dateStr.indexOf(32)) : "") + "</td>");
                out.print("</tr>");
                out.print("</table>");
                out.print("</div>");
                out.println("<div style=\"padding: 0px 0px 0px 20px; width: 90px; display: table-cell; vertical-align: top;\">");
                out.print("<div style=\"display: block; margin-left: auto; margin-right: auto; padding: 5px 0px;\">");
                out.print("<a target=\"_blank\" href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&xml=y\"><img src=\"" + (String)prefix + "/images/download.svg\" style=\"display: block; margin: auto; width: 22px; height: 22px;\"></a>");
                out.print("</div>");
                out.println("<div style=\"text-align: center; padding-top: 12px; font-size: 12px;\">");
                out.print("<a target=\"_blank\" href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&xml=y\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.ShowAsXml", (String[])new String[0]) + "</a>");
                out.print("</div>");
                out.print("</div>");
                out.println("<div style=\"padding: 0px 0px 0px 20px; width: 90px; display: table-cell; vertical-align: top;\">");
                out.print("<div style=\"display: block; margin-left: auto; margin-right: auto; padding: 5px 0px;\">");
                out.print("<a target=\"_blank\" href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&json=y\"><img src=\"" + (String)prefix + "/images/download.svg\" style=\"display: block; margin: auto; width: 22px; height: 22px;\"></a>");
                out.print("</div>");
                out.println("<div style=\"text-align: center; padding-top: 12px; font-size: 12px;\">");
                out.print("<a target=\"_blank\" href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&json=y\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.ShowAsJson", (String[])new String[0]) + "</a>");
                out.print("</div>");
                out.print("</div>");
                out.print("</div>");
                out.print("</div>");
                out.print("<div class=\"row\" style=\"padding: 0px 0px 75px 0px;\">");
                out.print("<div class=\"workspaceHeading\">Canvas preview</div>");
                Point max = workflow.getWorkflowMeta().getMaximum();
                max.x += (int)((float)max.x * 1.5f) + 100;
                max.y += (int)((float)max.y + 1.5f) + 50;
                out.print("<iframe height=\"" + (max.y + 100) + "px\" width=\"" + (max.x + 100) + "px\" src=\"" + this.convertContextPath("/hop/workflowImage") + "?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\"></iframe>");
                out.print("</div>");
                out.print("<div class=\"row\" style=\"padding: 0px 0px 30px 0px;\">");
                out.print("<div class=\"workspaceHeading\">Workflow log</div>");
                out.println("<textarea id=\"workflowlog\" cols=\"120\" rows=\"20\" wrap=\"off\" name=\"Workflow log\" readonly=\"readonly\" style=\"height: auto; width: 100%;\">" + Encode.forHtml((String)this.getLogText(workflow, startLineNr, lastLineNr)) + "</textarea>");
                out.print("</div>");
                out.println("<script type=\"text/javascript\">");
                out.println("element = document.getElementById( 'statusColor' );");
                out.println("if( element.innerHTML == 'Running' || element.innerHTML == 'Finished' ){");
                out.println("element.style.color = '#009900';");
                out.println("} else if( element.innerHTML == 'Stopped' ) {");
                out.println("element.style.color = '#7C0B2B';");
                out.println("} else {");
                out.println("element.style.color = '#F1C40F';");
                out.println("}");
                out.println("</script>");
                out.println("<script type=\"text/javascript\"> ");
                out.println("  joblog.scrollTop=joblog.scrollHeight; ");
                out.println("</script> ");
            }
            catch (Exception ex) {
                out.println("<pre>");
                out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
            }
            out.println("</div>");
            out.println("</BODY>");
            out.println("</HTML>");
        } else {
            PrintWriter out = response.getWriter();
            if (useXml) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"StartWorkflowServlet.Log.SpecifiedWorkflowNotFound", (String[])new String[]{workflowName, id})));
            } else {
                out.println("<H1>Workflow " + Encode.forHtml((String)("'" + workflowName + "'")) + " could not be found.</H1>");
                out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"WorkflowStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            }
        }
    }

    public String toString() {
        return "Workflow Status IHandler";
    }

    @Override
    public String getService() {
        return "/hop/workflowStatus (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    private String getLogText(IWorkflowEngine<WorkflowMeta> workflow, int startLineNr, int lastLineNr) throws HopException {
        try {
            return HopLogStore.getAppender().getBuffer(workflow.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
        }
        catch (OutOfMemoryError error) {
            throw new HopException("Log string is too long");
        }
    }
}

