/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.HopServerSequence;

public class PipelineMap {
    private final Map<HopServerObjectEntry, PipelineData> pipelineMap = new ConcurrentHashMap<HopServerObjectEntry, PipelineData>();
    private HopServerConfig hopServerConfig;

    public void addPipeline(String pipelineName, String containerObjectId, IPipelineEngine<PipelineMeta> pipeline, PipelineConfiguration pipelineConfiguration) {
        HopServerObjectEntry entry = new HopServerObjectEntry(pipelineName, containerObjectId);
        this.pipelineMap.put(entry, new PipelineData(pipeline, pipelineConfiguration));
    }

    public void registerPipeline(Pipeline pipeline, PipelineConfiguration pipelineConfiguration) {
        pipeline.setContainerId(UUID.randomUUID().toString());
        HopServerObjectEntry entry = new HopServerObjectEntry(pipeline.getPipelineMeta().getName(), pipeline.getContainerId());
        this.pipelineMap.put(entry, new PipelineData(pipeline, pipelineConfiguration));
    }

    public IPipelineEngine<PipelineMeta> getPipeline(String pipelineName) {
        for (HopServerObjectEntry entry : this.pipelineMap.keySet()) {
            if (!entry.getName().equals(pipelineName)) continue;
            return this.pipelineMap.get(entry).getPipeline();
        }
        return null;
    }

    public IPipelineEngine<PipelineMeta> getPipeline(HopServerObjectEntry entry) {
        PipelineData pipelineData = this.pipelineMap.get(entry);
        if (pipelineData != null) {
            return pipelineData.getPipeline();
        }
        return null;
    }

    public PipelineConfiguration getConfiguration(String pipelineName) {
        for (HopServerObjectEntry entry : this.pipelineMap.keySet()) {
            if (!entry.getName().equals(pipelineName)) continue;
            return this.pipelineMap.get(entry).getConfiguration();
        }
        return null;
    }

    public PipelineConfiguration getConfiguration(HopServerObjectEntry entry) {
        return this.pipelineMap.get(entry).getConfiguration();
    }

    public void removePipeline(HopServerObjectEntry entry) {
        this.pipelineMap.remove(entry);
    }

    public List<HopServerObjectEntry> getPipelineObjects() {
        return new ArrayList<HopServerObjectEntry>(this.pipelineMap.keySet());
    }

    public HopServerObjectEntry getFirstServerObjectEntry(String pipelineName) {
        for (HopServerObjectEntry key : this.pipelineMap.keySet()) {
            if (!key.getName().equals(pipelineName)) continue;
            return key;
        }
        return null;
    }

    public HopServerConfig getHopServerConfig() {
        return this.hopServerConfig;
    }

    public void setHopServerConfig(HopServerConfig hopServerConfig) {
        this.hopServerConfig = hopServerConfig;
    }

    public HopServerSequence getServerSequence(String name) {
        return HopServerSequence.findServerSequence(name, this.hopServerConfig.getHopServerSequences());
    }

    public boolean isAutomaticServerSequenceCreationAllowed() {
        return this.hopServerConfig.isAutomaticCreationAllowed();
    }

    public HopServerSequence createServerSequence(String name) throws HopException {
        HopServerSequence auto = this.hopServerConfig.getAutoSequence();
        if (auto == null) {
            throw new HopException("No auto-sequence information found in the hop server config.  Server sequence could not be created automatically.");
        }
        HopServerSequence hopServerSequence = new HopServerSequence(name, auto.getStartValue(), auto.getDatabaseMeta(), auto.getSchemaName(), auto.getTableName(), auto.getSequenceNameField(), auto.getValueField());
        this.hopServerConfig.getHopServerSequences().add(hopServerSequence);
        return hopServerSequence;
    }

    private static class PipelineData {
        private IPipelineEngine<PipelineMeta> pipeline;
        private PipelineConfiguration configuration;

        PipelineData(IPipelineEngine<PipelineMeta> pipeline, PipelineConfiguration configuration) {
            this.pipeline = pipeline;
            this.configuration = configuration;
        }

        public IPipelineEngine<PipelineMeta> getPipeline() {
            return this.pipeline;
        }

        public void setPipeline(IPipelineEngine<PipelineMeta> pipeline) {
            this.pipeline = pipeline;
        }

        public PipelineConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(PipelineConfiguration configuration) {
            this.configuration = configuration;
        }
    }
}

