/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.reservoirsampling;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.reservoirsampling.ReservoirSamplingData;
import org.apache.hop.pipeline.transforms.reservoirsampling.ReservoirSamplingMeta;

public class ReservoirSampling
extends BaseTransform<ReservoirSamplingMeta, ReservoirSamplingData> {
    public ReservoirSampling(TransformMeta transformMeta, ReservoirSamplingMeta meta, ReservoirSamplingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (((ReservoirSamplingData)this.data).getProcessingMode() == ReservoirSamplingData.PROC_MODE.DISABLED) {
            this.setOutputDone();
            ((ReservoirSamplingData)this.data).cleanUp();
            return false;
        }
        Object[] r = this.getRow();
        if (this.first) {
            this.first = false;
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            ((ReservoirSamplingData)this.data).setOutputRowMeta(this.getInputRowMeta().clone());
            String sampleSize = this.resolve(((ReservoirSamplingMeta)this.meta).getSampleSize());
            String seed = this.resolve(((ReservoirSamplingMeta)this.meta).getSeed());
            ((ReservoirSamplingData)this.data).initialize(Integer.valueOf(sampleSize), Integer.valueOf(seed));
        }
        if (((ReservoirSamplingData)this.data).getProcessingMode() == ReservoirSamplingData.PROC_MODE.PASSTHROUGH) {
            if (r == null) {
                this.setOutputDone();
                ((ReservoirSamplingData)this.data).cleanUp();
                return false;
            }
            this.putRow(((ReservoirSamplingData)this.data).getOutputRowMeta(), r);
        } else if (((ReservoirSamplingData)this.data).getProcessingMode() == ReservoirSamplingData.PROC_MODE.SAMPLING) {
            if (r == null) {
                List<Object[]> samples = ((ReservoirSamplingData)this.data).getSample();
                int numRows = samples != null ? samples.size() : 0;
                this.logBasic(this.getTransformName() + " Actual/Sample: " + numRows + "/" + ((ReservoirSamplingData)this.data).m_k + " Seed:" + this.resolve(((ReservoirSamplingMeta)this.meta).m_randomSeed));
                if (samples != null) {
                    Object[] sample;
                    for (int i = 0; i < samples.size() && (sample = samples.get(i)) != null; ++i) {
                        this.putRow(((ReservoirSamplingData)this.data).getOutputRowMeta(), sample);
                    }
                }
                this.setOutputDone();
                ((ReservoirSamplingData)this.data).cleanUp();
                return false;
            }
            ((ReservoirSamplingData)this.data).processRow(r);
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + Arrays.toString(r));
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Line number " + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            List previous = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
            return true;
        }
        return false;
    }

    public void run() {
        this.logBasic("Starting to run...");
        try {
            while (this.processRow() && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose();
            this.logBasic("Finished, processing " + this.getLinesRead() + " rows");
            this.markStop();
        }
    }
}

