/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execsqlrow;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execsqlrow.ExecSqlRow;
import org.apache.hop.pipeline.transforms.execsqlrow.ExecSqlRowData;
import org.w3c.dom.Node;

@Transform(id="ExecSqlRow", image="execsqlrow.svg", name="i18n::ExecSqlRow.Name", description="i18n::ExecSqlRow.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", keywords={"i18n::ExecSqlRowMeta.keyword"}, documentationUrl="/pipeline/transforms/execsqlrow.html")
@InjectionSupported(localizationPrefix="ExecSqlRowMeta.Injection.", groups={"OUTPUT_FIELDS"})
public class ExecSqlRowMeta
extends BaseTransformMeta<ExecSqlRow, ExecSqlRowData> {
    private static final Class<?> PKG = ExecSqlRowMeta.class;
    private IHopMetadataProvider metadataProvider;
    private DatabaseMeta databaseMeta;
    @Injection(name="SQL_FIELD_NAME")
    private String sqlField;
    @Injection(name="UPDATE_STATS", group="OUTPUT_FIELDS")
    private String updateField;
    @Injection(name="INSERT_STATS", group="OUTPUT_FIELDS")
    private String insertField;
    @Injection(name="DELETE_STATS", group="OUTPUT_FIELDS")
    private String deleteField;
    @Injection(name="READ_STATS", group="OUTPUT_FIELDS")
    private String readField;
    @Injection(name="COMMIT_SIZE")
    private int commitSize;
    @Injection(name="READ_SQL_FROM_FILE")
    private boolean sqlFromfile;
    @Injection(name="SEND_SINGLE_STATEMENT")
    private boolean sendOneStatement;

    @Injection(name="CONNECTION_NAME")
    public void setConnection(String connectionName) {
        try {
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.metadataProvider, (String)connectionName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load connection '" + connectionName + "'", e);
        }
    }

    public boolean IsSendOneStatement() {
        return this.sendOneStatement;
    }

    public void SetSendOneStatement(boolean sendOneStatement) {
        this.sendOneStatement = sendOneStatement;
    }

    public boolean isSqlFromfile() {
        return this.sqlFromfile;
    }

    public void setSqlFromfile(boolean sqlFromfile) {
        this.sqlFromfile = sqlFromfile;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getSqlFieldName() {
        return this.sqlField;
    }

    public void setSqlFieldName(String sqlField) {
        this.sqlField = sqlField;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public String getDeleteField() {
        return this.deleteField;
    }

    public void setDeleteField(String deleteField) {
        this.deleteField = deleteField;
    }

    public String getInsertField() {
        return this.insertField;
    }

    public void setInsertField(String insertField) {
        this.insertField = insertField;
    }

    public String getReadField() {
        return this.readField;
    }

    public void setReadField(String readField) {
        this.readField = readField;
    }

    public String getUpdateField() {
        return this.updateField;
    }

    public void setUpdateField(String updateField) {
        this.updateField = updateField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        ExecSqlRowMeta retval = (ExecSqlRowMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.metadataProvider = metadataProvider;
        try {
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            String csize = XmlHandler.getTagValue((Node)transformNode, (String)"commit");
            this.commitSize = Const.toInt((String)csize, (int)0);
            this.sqlField = XmlHandler.getTagValue((Node)transformNode, (String)"sql_field");
            this.insertField = XmlHandler.getTagValue((Node)transformNode, (String)"insert_field");
            this.updateField = XmlHandler.getTagValue((Node)transformNode, (String)"update_field");
            this.deleteField = XmlHandler.getTagValue((Node)transformNode, (String)"delete_field");
            this.readField = XmlHandler.getTagValue((Node)transformNode, (String)"read_field");
            this.sqlFromfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"sqlFromfile"));
            this.sendOneStatement = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"sendOneStatement"), (String)"Y"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.sqlFromfile = false;
        this.commitSize = 1;
        this.databaseMeta = null;
        this.sqlField = null;
        this.sendOneStatement = true;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        RowMetaAndData add = ExecSqlRow.getResultRow(new Result(), this.getUpdateField(), this.getInsertField(), this.getDeleteField(), this.getReadField());
        r.mergeRowMeta(add.getRowMeta());
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("    ").append(XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sql_field", (String)this.sqlField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"insert_field", (String)this.insertField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"update_field", (String)this.updateField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"delete_field", (String)this.deleteField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"read_field", (String)this.readField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sqlFromfile", (boolean)this.sqlFromfile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sendOneStatement", (boolean)this.sendOneStatement));
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.DBConnectionOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                cr = this.sqlField != null && this.sqlField.length() != 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.SQLFieldNameEntered", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.SQLFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage(), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.ConnectionNeeded", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.TransformReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

