/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.accesslog;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.accesslog.AccessLogAppender;

public class QueueingAppender
implements AccessLogAppender {
    private static final Logger LOGGER = Grizzly.logger(HttpServer.class);
    private final LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();
    private final AccessLogAppender appender;
    private final Thread thread;

    public QueueingAppender(AccessLogAppender appender) {
        if (appender == null) {
            throw new NullPointerException("Null appender");
        }
        this.appender = appender;
        this.thread = new Thread(new Dequeuer());
        this.thread.setName(this.toString());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void append(String accessLogEntry) throws IOException {
        if (this.thread.isAlive()) {
            try {
                this.queue.put(accessLogEntry);
            }
            catch (InterruptedException exception) {
                LOGGER.log(Level.FINE, "Interrupted adding log entry to the queue", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException exception) {
            LOGGER.log(Level.FINE, "Interrupted stopping de-queuer", exception);
        }
        finally {
            this.appender.close();
        }
    }

    private final class Dequeuer
    implements Runnable {
        private Dequeuer() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String accessLogEntry;
                        if ((accessLogEntry = (String)QueueingAppender.this.queue.take()) == null) {
                            continue;
                        }
                        QueueingAppender.this.appender.append(accessLogEntry);
                    }
                }
                catch (InterruptedException exception) {
                    LOGGER.log(Level.FINE, "Interrupted waiting for log entry to be queued, exiting!", exception);
                    return;
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, "Exception caught appending ququed log entry", throwable);
                    continue;
                }
                break;
            }
        }
    }
}

