/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sort;

import java.io.File;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sort.SortRows;
import org.apache.hop.pipeline.transforms.sort.SortRowsData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SortRows.Injection.", groups={"FIELDS"})
@Transform(id="SortRows", image="sortrows.svg", name="i18n::SortRows.Name", description="i18n::SortRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::SortRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/sort.html")
public class SortRowsMeta
extends BaseTransformMeta<SortRows, SortRowsData>
implements Serializable {
    private static final long serialVersionUID = -9075883720765645655L;
    private static final Class<?> PKG = SortRowsMeta.class;
    @Injection(name="NAME", group="FIELDS")
    private String[] fieldName;
    @Injection(name="SORT_ASCENDING", group="FIELDS")
    private boolean[] ascending;
    @Injection(name="IGNORE_CASE", group="FIELDS")
    private boolean[] caseSensitive;
    @Injection(name="COLLATOR_ENABLED", group="FIELDS")
    private boolean[] collatorEnabled;
    @Injection(name="COLLATOR_STRENGTH", group="FIELDS")
    private int[] collatorStrength;
    @Injection(name="PRESORTED", group="FIELDS")
    private boolean[] preSortedField;
    private List<String> groupFields;
    @Injection(name="SORT_DIRECTORY")
    private String directory;
    @Injection(name="SORT_FILE_PREFIX")
    private String prefix;
    @Injection(name="SORT_SIZE_ROWS")
    private String sortSize;
    @Injection(name="FREE_MEMORY_TRESHOLD")
    private String freeMemoryLimit;
    @Injection(name="ONLY_PASS_UNIQUE_ROWS")
    private boolean onlyPassingUniqueRows;
    @Injection(name="COMPRESS_TEMP_FILES")
    private boolean compressFiles;
    private String compressFilesVariable;

    public boolean[] getAscending() {
        return this.ascending;
    }

    public void setAscending(boolean[] ascending) {
        this.ascending = ascending;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrFields) {
        this.fieldName = new String[nrFields];
        this.ascending = new boolean[nrFields];
        this.caseSensitive = new boolean[nrFields];
        this.collatorEnabled = new boolean[nrFields];
        this.collatorStrength = new int[nrFields];
        this.preSortedField = new boolean[nrFields];
        this.groupFields = null;
    }

    public Object clone() {
        SortRowsMeta retval = (SortRowsMeta)super.clone();
        int nrFields = this.fieldName.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrFields);
        System.arraycopy(this.ascending, 0, retval.ascending, 0, nrFields);
        System.arraycopy(this.caseSensitive, 0, retval.caseSensitive, 0, nrFields);
        System.arraycopy(this.collatorEnabled, 0, retval.collatorEnabled, 0, nrFields);
        System.arraycopy(this.collatorStrength, 0, retval.collatorStrength, 0, nrFields);
        System.arraycopy(this.preSortedField, 0, retval.preSortedField, 0, nrFields);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.directory = XmlHandler.getTagValue((Node)transformNode, (String)"directory");
            this.prefix = XmlHandler.getTagValue((Node)transformNode, (String)"prefix");
            this.sortSize = XmlHandler.getTagValue((Node)transformNode, (String)"sort_size");
            this.freeMemoryLimit = XmlHandler.getTagValue((Node)transformNode, (String)"free_memory");
            this.compressFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"compress"));
            this.compressFilesVariable = XmlHandler.getTagValue((Node)transformNode, (String)"compress_variable");
            this.onlyPassingUniqueRows = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"unique_rows"));
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            String defaultStrength = Integer.toString(this.getDefaultCollationStrength());
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                String asc = XmlHandler.getTagValue((Node)fnode, (String)"ascending");
                this.ascending[i] = "Y".equalsIgnoreCase(asc);
                String sens = XmlHandler.getTagValue((Node)fnode, (String)"case_sensitive");
                String coll = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"collator_enabled"), (String)"N");
                this.caseSensitive[i] = Utils.isEmpty((CharSequence)sens) || "Y".equalsIgnoreCase(sens);
                this.collatorEnabled[i] = "Y".equalsIgnoreCase(coll);
                this.collatorStrength[i] = Integer.parseInt(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"collator_strength"), (String)defaultStrength));
                String presorted = XmlHandler.getTagValue((Node)fnode, (String)"presorted");
                this.preSortedField[i] = "Y".equalsIgnoreCase(presorted);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.directory = "${java.io.tmpdir}";
        this.prefix = "out";
        this.sortSize = "1000000";
        this.freeMemoryLimit = null;
        this.compressFiles = false;
        this.compressFilesVariable = null;
        this.onlyPassingUniqueRows = false;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.fieldName[i] = "field" + i;
            this.caseSensitive[i] = true;
            this.collatorEnabled[i] = false;
            this.collatorStrength[i] = 0;
            this.preSortedField[i] = false;
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(256);
        retval.append("      ").append(XmlHandler.addTagValue((String)"directory", (String)this.directory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"prefix", (String)this.prefix));
        retval.append("      ").append(XmlHandler.addTagValue((String)"sort_size", (String)this.sortSize));
        retval.append("      ").append(XmlHandler.addTagValue((String)"free_memory", (String)this.freeMemoryLimit));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compress", (boolean)this.compressFiles));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compress_variable", (String)this.compressFilesVariable));
        retval.append("      ").append(XmlHandler.addTagValue((String)"unique_rows", (boolean)this.onlyPassingUniqueRows));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"ascending", (boolean)this.ascending[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"case_sensitive", (boolean)this.caseSensitive[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"collator_enabled", (boolean)this.collatorEnabled[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"collator_strength", (int)this.collatorStrength[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"presorted", (boolean)this.preSortedField[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    int getDefaultCollationStrength() {
        return this.getDefaultCollationStrength(Locale.getDefault());
    }

    int getDefaultCollationStrength(Locale aLocale) {
        Collator curDefCollator;
        int defaultStrength = 3;
        if (aLocale != null && (curDefCollator = Collator.getInstance(aLocale)) != null) {
            defaultStrength = curDefCollator.getStrength();
        }
        return defaultStrength;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        this.assignSortingCriteria(inputRowMeta);
    }

    public void assignSortingCriteria(IRowMeta inputRowMeta) {
        for (int i = 0; i < this.fieldName.length; ++i) {
            int idx = inputRowMeta.indexOfValue(this.fieldName[i]);
            if (idx < 0) continue;
            IValueMeta valueMeta = inputRowMeta.getValueMeta(idx);
            if (this.ascending.length > i) {
                valueMeta.setSortedDescending(!this.ascending[i]);
            }
            if (this.caseSensitive.length > i) {
                valueMeta.setCaseInsensitive(!this.caseSensitive[i]);
            }
            if (this.collatorEnabled.length > i) {
                valueMeta.setCollatorDisabled(!this.collatorEnabled[i]);
            }
            if (this.collatorStrength.length > i) {
                valueMeta.setCollatorStrength(this.collatorStrength[i]);
            }
            valueMeta.setStorageType(0);
            valueMeta.setStorageMetadata(null);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.fieldName[i] + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.SortKeysNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.AllSortKeysFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.NoSortKeysEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            String realDirectory = variables.resolve(this.directory);
            File f = new File(realDirectory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.DirectoryExists", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExistsButNoDirectory", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.DirectoryNotExists", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getSortSize() {
        return this.sortSize;
    }

    public void setSortSize(String sortSize) {
        this.sortSize = sortSize;
    }

    public boolean getCompressFiles() {
        return this.compressFiles;
    }

    public void setCompressFiles(boolean compressFiles) {
        this.compressFiles = compressFiles;
    }

    public boolean isOnlyPassingUniqueRows() {
        return this.onlyPassingUniqueRows;
    }

    public void setOnlyPassingUniqueRows(boolean onlyPassingUniqueRows) {
        this.onlyPassingUniqueRows = onlyPassingUniqueRows;
    }

    public String getCompressFilesVariable() {
        return this.compressFilesVariable;
    }

    public void setCompressFilesVariable(String compressFilesVariable) {
        this.compressFilesVariable = compressFilesVariable;
    }

    public boolean[] getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean[] caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean[] getCollatorEnabled() {
        return this.collatorEnabled;
    }

    public void setCollatorEnabled(boolean[] collatorEnabled) {
        this.collatorEnabled = collatorEnabled;
    }

    public int[] getCollatorStrength() {
        return this.collatorStrength;
    }

    public void setCollatorStrength(int[] collatorStrength) {
        this.collatorStrength = collatorStrength;
    }

    public String getFreeMemoryLimit() {
        return this.freeMemoryLimit;
    }

    public void setFreeMemoryLimit(String freeMemoryLimit) {
        this.freeMemoryLimit = freeMemoryLimit;
    }

    public boolean[] getPreSortedField() {
        return this.preSortedField;
    }

    public void setPreSortedField(boolean[] preSorted) {
        this.preSortedField = preSorted;
    }

    public List<String> getGroupFields() {
        if (this.groupFields == null) {
            for (int i = 0; i < this.preSortedField.length; ++i) {
                if (!this.preSortedField[i]) continue;
                if (this.groupFields == null) {
                    this.groupFields = new ArrayList<String>();
                }
                this.groupFields.add(this.fieldName[i]);
            }
        }
        return this.groupFields;
    }

    public boolean isGroupSortEnabled() {
        return this.getGroupFields() != null;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.fieldName == null ? -1 : this.fieldName.length;
        if (nrFields <= 0) {
            return;
        }
        boolean[][] rtnBooleanArrays = Utils.normalizeArrays((int)nrFields, (boolean[][])new boolean[][]{this.ascending, this.caseSensitive, this.collatorEnabled, this.preSortedField});
        this.ascending = rtnBooleanArrays[0];
        this.caseSensitive = rtnBooleanArrays[1];
        this.collatorEnabled = rtnBooleanArrays[2];
        this.preSortedField = rtnBooleanArrays[3];
        int[][] rtnIntArrays = Utils.normalizeArrays((int)nrFields, (int[][])new int[][]{this.collatorStrength});
        this.collatorStrength = rtnIntArrays[0];
    }
}

