/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.AvroRows;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReader;

class BigQueryStorageAvroReader
implements BigQueryStorageReader {
    private final Schema avroSchema;
    private final DatumReader<GenericRecord> datumReader;
    private BinaryDecoder decoder;
    private GenericRecord record;
    private long rowCount;

    BigQueryStorageAvroReader(ReadSession readSession) {
        this.avroSchema = new Schema.Parser().parse(readSession.getAvroSchema().getSchema());
        this.datumReader = new GenericDatumReader(this.avroSchema);
        this.rowCount = 0L;
        this.decoder = null;
        this.record = null;
    }

    @Override
    public void processReadRowsResponse(ReadRowsResponse readRowsResponse) {
        AvroRows avroRows = readRowsResponse.getAvroRows();
        this.rowCount = avroRows.getRowCount();
        this.decoder = DecoderFactory.get().binaryDecoder(avroRows.getSerializedBinaryRows().toByteArray(), this.decoder);
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public GenericRecord readSingleRecord() throws IOException {
        this.record = (GenericRecord)this.datumReader.read((Object)this.record, (Decoder)this.decoder);
        return this.record;
    }

    @Override
    public boolean readyForNextReadResponse() throws IOException {
        return this.decoder == null || this.decoder.isEnd();
    }

    @Override
    public void resetBuffer() {
        this.decoder = null;
    }

    @Override
    public void close() {
    }
}

