/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class WriteResult
implements POutput {
    private final Pipeline pipeline;
    private final TupleTag<TableRow> failedInsertsTag;
    private final PCollection<TableRow> failedInserts;
    private final TupleTag<BigQueryInsertError> failedInsertsWithErrTag;
    private final PCollection<BigQueryInsertError> failedInsertsWithErr;
    private final PCollection<TableRow> successfulInserts;
    private final TupleTag<TableDestination> successfulBatchInsertsTag;
    private final PCollection<TableDestination> successfulBatchInserts;

    static WriteResult in(Pipeline pipeline, TupleTag<TableRow> failedInsertsTag, PCollection<TableRow> failedInserts, @Nullable PCollection<TableRow> successfulInserts, @Nullable TupleTag<TableDestination> successfulBatchInsertsTag, @Nullable PCollection<TableDestination> successfulBatchInserts) {
        return new WriteResult(pipeline, failedInsertsTag, failedInserts, null, null, successfulInserts, successfulBatchInsertsTag, successfulBatchInserts);
    }

    static WriteResult withExtendedErrors(Pipeline pipeline, TupleTag<BigQueryInsertError> failedInsertsTag, PCollection<BigQueryInsertError> failedInserts, PCollection<TableRow> successfulInserts) {
        return new WriteResult(pipeline, null, null, failedInsertsTag, failedInserts, successfulInserts, null, null);
    }

    public Map<TupleTag<?>, PValue> expand() {
        ImmutableMap.Builder output = ImmutableMap.builder();
        if (this.failedInsertsTag != null) {
            output.put(this.failedInsertsTag, this.failedInserts);
        } else {
            output.put(this.failedInsertsWithErrTag, this.failedInsertsWithErr);
        }
        if (this.successfulBatchInserts != null) {
            output.put(this.successfulBatchInsertsTag, this.successfulBatchInserts);
        }
        return output.build();
    }

    private WriteResult(Pipeline pipeline, TupleTag<TableRow> failedInsertsTag, PCollection<TableRow> failedInserts, TupleTag<BigQueryInsertError> failedInsertsWithErrTag, PCollection<BigQueryInsertError> failedInsertsWithErr, PCollection<TableRow> successfulInserts, TupleTag<TableDestination> successfulInsertsTag, PCollection<TableDestination> successfulBatchInserts) {
        this.pipeline = pipeline;
        this.failedInsertsTag = failedInsertsTag;
        this.failedInserts = failedInserts;
        this.failedInsertsWithErrTag = failedInsertsWithErrTag;
        this.failedInsertsWithErr = failedInsertsWithErr;
        this.successfulInserts = successfulInserts;
        this.successfulBatchInsertsTag = successfulInsertsTag;
        this.successfulBatchInserts = successfulBatchInserts;
    }

    public PCollection<TableDestination> getSuccessfulTableLoads() {
        Preconditions.checkArgument((this.successfulBatchInsertsTag != null ? 1 : 0) != 0, (Object)"Cannot use getSuccessfulTableLoads because this WriteResult was not configured to produce them.  Note: only batch loads produce successfulTableLoads.");
        return this.successfulBatchInserts;
    }

    public PCollection<TableRow> getSuccessfulInserts() {
        Preconditions.checkArgument((this.successfulInserts != null ? 1 : 0) != 0, (Object)"Retrieving successful inserts is only supported for streaming inserts.");
        return this.successfulInserts;
    }

    public PCollection<TableRow> getFailedInserts() {
        Preconditions.checkArgument((this.failedInsertsTag != null ? 1 : 0) != 0, (Object)"Cannot use getFailedInserts as this WriteResult uses extended errors information. Use getFailedInsertsWithErr instead");
        return this.failedInserts;
    }

    public PCollection<BigQueryInsertError> getFailedInsertsWithErr() {
        Preconditions.checkArgument((this.failedInsertsWithErrTag != null ? 1 : 0) != 0, (Object)"Cannot use getFailedInsertsWithErr as this WriteResult does not use extended errors. Use getFailedInserts instead");
        return this.failedInsertsWithErr;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
    }
}

