/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.pubsub.v1.PushConfig;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.io.gcp.pubsub.TestPubsub;
import org.apache.beam.sdk.io.gcp.pubsub.TestPubsubOptions;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPubsubSignal
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(TestPubsubSignal.class);
    private static final String RESULT_TOPIC_NAME = "result";
    private static final String RESULT_SUCCESS_MESSAGE = "SUCCESS";
    private static final String START_TOPIC_NAME = "start";
    private static final String START_SIGNAL_MESSAGE = "START SIGNAL";
    private final TestPubsubOptions pipelineOptions;
    private final String pubsubEndpoint;
    private @Nullable TopicAdminClient topicAdmin = null;
    private @Nullable SubscriptionAdminClient subscriptionAdmin = null;
    private @Nullable PubsubClient.TopicPath resultTopicPath = null;
    private @Nullable PubsubClient.TopicPath startTopicPath = null;

    public static TestPubsubSignal create() {
        TestPubsubOptions options = (TestPubsubOptions)TestPipeline.testingPipelineOptions().as(TestPubsubOptions.class);
        return new TestPubsubSignal(options);
    }

    private TestPubsubSignal(TestPubsubOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
        this.pubsubEndpoint = PubsubOptions.targetForRootUrl(this.pipelineOptions.getPubsubRootUrl());
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (TestPubsubSignal.this.topicAdmin != null || TestPubsubSignal.this.subscriptionAdmin != null) {
                    throw new AssertionError((Object)("Pubsub client was not shutdown in previous test. Topic path is'" + TestPubsubSignal.this.resultTopicPath + "'. Current test: " + description.getDisplayName()));
                }
                try {
                    TestPubsubSignal.this.initializePubsub(description);
                    base.evaluate();
                }
                finally {
                    TestPubsubSignal.this.tearDown();
                }
            }
        };
    }

    private void initializePubsub(Description description) throws IOException {
        this.topicAdmin = TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(() -> ((TestPubsubOptions)this.pipelineOptions).getGcpCredential())).setEndpoint(this.pubsubEndpoint)).build());
        this.subscriptionAdmin = SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(() -> ((TestPubsubOptions)this.pipelineOptions).getGcpCredential())).setEndpoint(this.pubsubEndpoint)).build());
        PubsubClient.TopicPath resultTopicPathTmp = PubsubClient.topicPathFromName(this.pipelineOptions.getProject(), TestPubsub.createTopicName(description, RESULT_TOPIC_NAME));
        PubsubClient.TopicPath startTopicPathTmp = PubsubClient.topicPathFromName(this.pipelineOptions.getProject(), TestPubsub.createTopicName(description, START_TOPIC_NAME));
        this.topicAdmin.createTopic(resultTopicPathTmp.getPath());
        this.topicAdmin.createTopic(startTopicPathTmp.getPath());
        this.resultTopicPath = resultTopicPathTmp;
        this.startTopicPath = startTopicPathTmp;
    }

    private void tearDown() throws IOException {
        if (this.subscriptionAdmin == null || this.topicAdmin == null) {
            return;
        }
        try {
            if (this.resultTopicPath != null) {
                for (String subscriptionPath : this.topicAdmin.listTopicSubscriptions(this.resultTopicPath.getPath()).iterateAll()) {
                    this.subscriptionAdmin.deleteSubscription(subscriptionPath);
                }
                this.topicAdmin.deleteTopic(this.resultTopicPath.getPath());
            }
            if (this.startTopicPath != null) {
                for (String subscriptionPath : this.topicAdmin.listTopicSubscriptions(this.startTopicPath.getPath()).iterateAll()) {
                    this.subscriptionAdmin.deleteSubscription(subscriptionPath);
                }
                this.topicAdmin.deleteTopic(this.startTopicPath.getPath());
            }
        }
        finally {
            this.subscriptionAdmin.close();
            this.topicAdmin.close();
            this.subscriptionAdmin = null;
            this.topicAdmin = null;
            this.resultTopicPath = null;
            this.startTopicPath = null;
        }
    }

    public PTransform<PBegin, PDone> signalStart() {
        return new PublishStart(this.startTopicPath);
    }

    public <T> PTransform<PCollection<? extends T>, POutput> signalSuccessWhen(Coder<T> coder, SerializableFunction<T, String> formatter, SerializableFunction<Set<T>, Boolean> successPredicate) {
        return new PublishSuccessWhen<T>(coder, formatter, successPredicate, this.resultTopicPath);
    }

    public <T> PTransform<PCollection<? extends T>, POutput> signalSuccessWhen(Coder<T> coder, SerializableFunction<Set<T>, Boolean> successPredicate) {
        return this.signalSuccessWhen(coder, Object::toString, successPredicate);
    }

    public Supplier<Void> waitForStart(Duration duration) throws IOException {
        PubsubClient.SubscriptionPath startSubscriptionPath = PubsubClient.subscriptionPathFromName(this.pipelineOptions.getProject(), "start-subscription-" + String.valueOf(ThreadLocalRandom.current().nextLong()));
        this.subscriptionAdmin.createSubscription(startSubscriptionPath.getPath(), this.startTopicPath.getPath(), PushConfig.getDefaultInstance(), (int)duration.getStandardSeconds());
        return Suppliers.memoize(() -> {
            Void void_;
            try {
                String result = this.pollForResultForDuration(startSubscriptionPath, duration);
                Preconditions.checkState((boolean)START_SIGNAL_MESSAGE.equals(result));
                void_ = null;
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    try {
                        this.subscriptionAdmin.deleteSubscription(startSubscriptionPath.getPath());
                        throw throwable;
                    }
                    catch (ApiException e2) {
                        LOG.error(String.format("Leaked PubSub subscription '%s'", startSubscriptionPath));
                    }
                    throw throwable;
                }
            }
            try {
                this.subscriptionAdmin.deleteSubscription(startSubscriptionPath.getPath());
                return void_;
            }
            catch (ApiException e) {
                LOG.error(String.format("Leaked PubSub subscription '%s'", startSubscriptionPath));
            }
            return void_;
        });
    }

    public void waitForSuccess(Duration duration) throws IOException {
        PubsubClient.SubscriptionPath resultSubscriptionPath = PubsubClient.subscriptionPathFromName(this.pipelineOptions.getProject(), "result-subscription-" + String.valueOf(ThreadLocalRandom.current().nextLong()));
        this.subscriptionAdmin.createSubscription(resultSubscriptionPath.getPath(), this.resultTopicPath.getPath(), PushConfig.getDefaultInstance(), (int)duration.getStandardSeconds());
        String result = this.pollForResultForDuration(resultSubscriptionPath, duration);
        try {
            this.subscriptionAdmin.deleteSubscription(resultSubscriptionPath.getPath());
        }
        catch (ApiException e) {
            LOG.error(String.format("Leaked PubSub subscription '%s'", resultSubscriptionPath));
        }
        if (!RESULT_SUCCESS_MESSAGE.equals(result)) {
            throw new AssertionError((Object)result);
        }
    }

    private String pollForResultForDuration(PubsubClient.SubscriptionPath signalSubscriptionPath, Duration timeoutDuration) throws IOException {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        MessageReceiver receiver = (message, replyConsumer) -> {
            LOG.info("Received message: {}", (Object)message.getData().toStringUtf8());
            if (message.getData().isEmpty()) {
                replyConsumer.ack();
            }
            if (result.compareAndSet(null, message.getData().toStringUtf8())) {
                replyConsumer.ack();
            } else {
                replyConsumer.nack();
            }
        };
        Subscriber subscriber = Subscriber.newBuilder((String)signalSubscriptionPath.getPath(), (MessageReceiver)receiver).setCredentialsProvider(() -> ((TestPubsubOptions)this.pipelineOptions).getGcpCredential()).setEndpoint(this.pubsubEndpoint).build();
        subscriber.startAsync();
        DateTime startTime = new DateTime();
        int timeoutSeconds = timeoutDuration.toStandardSeconds().getSeconds();
        while (result.get() == null && Seconds.secondsBetween((ReadableInstant)startTime, (ReadableInstant)new DateTime()).getSeconds() < timeoutSeconds) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        subscriber.stopAsync();
        subscriber.awaitTerminated();
        if (result.get() == null) {
            throw new AssertionError((Object)String.format("Did not receive signal on %s in %ss", signalSubscriptionPath, timeoutDuration.getStandardSeconds()));
        }
        return result.get();
    }

    static class StatefulPredicateCheck<T>
    extends DoFn<KV<String, ? extends T>, String> {
        private SerializableFunction<Set<T>, Boolean> successPredicate;
        private static final String SEEN_EVENTS = "seenEvents";
        @DoFn.StateId(value="seenEvents")
        private final StateSpec<BagState<T>> seenEvents;

        StatefulPredicateCheck(Coder<T> coder, SerializableFunction<T, String> formatter, SerializableFunction<Set<T>, Boolean> successPredicate) {
            this.seenEvents = StateSpecs.bag(coder);
            this.successPredicate = successPredicate;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context, @DoFn.StateId(value="seenEvents") BagState<T> seenEvents) {
            seenEvents.add(((KV)context.element()).getValue());
            ImmutableSet eventsSoFar = ImmutableSet.copyOf((Iterable)seenEvents.read());
            try {
                if (((Boolean)this.successPredicate.apply((Object)eventsSoFar)).booleanValue()) {
                    LOG.info("Predicate has been satisfied. Sending SUCCESS message.");
                    context.output((Object)TestPubsubSignal.RESULT_SUCCESS_MESSAGE);
                }
            }
            catch (Throwable e) {
                LOG.error("Error while applying predicate.", e);
                context.output((Object)("FAILURE: " + e.getMessage()));
            }
        }
    }

    static class PublishSuccessWhen<T>
    extends PTransform<PCollection<? extends T>, POutput> {
        private final Coder<T> coder;
        private final SerializableFunction<T, String> formatter;
        private final SerializableFunction<Set<T>, Boolean> successPredicate;
        private final PubsubClient.TopicPath resultTopicPath;

        PublishSuccessWhen(Coder<T> coder, SerializableFunction<T, String> formatter, SerializableFunction<Set<T>, Boolean> successPredicate, PubsubClient.TopicPath resultTopicPath) {
            this.coder = coder;
            this.formatter = formatter;
            this.successPredicate = successPredicate;
            this.resultTopicPath = resultTopicPath;
        }

        public POutput expand(PCollection<? extends T> input) {
            return ((PCollection)((PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)new GlobalWindows()))).apply((PTransform)WithKeys.of((Object)"dummyKey"))).apply("checkAllEventsForSuccess", (PTransform)ParDo.of(new StatefulPredicateCheck<T>(this.coder, this.formatter, this.successPredicate)))).apply("publishSuccess", PubsubIO.writeStrings().to(this.resultTopicPath.getPath()));
        }
    }

    static class PublishStart
    extends PTransform<PBegin, PDone> {
        private final PubsubClient.TopicPath startTopicPath;

        PublishStart(PubsubClient.TopicPath startTopicPath) {
            this.startTopicPath = startTopicPath;
        }

        public PDone expand(PBegin input) {
            return (PDone)((PCollection)input.apply("Start signal", (PTransform)Create.of((Object)TestPubsubSignal.START_SIGNAL_MESSAGE, (Object[])new String[0]))).apply(PubsubIO.writeStrings().to(this.startTopicPath.getPath()));
        }
    }
}

