/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TimestampRangeTracker
extends RestrictionTracker<TimestampRange, Timestamp>
implements RestrictionTracker.HasProgress {
    protected TimestampRange range;
    protected @Nullable Timestamp lastAttemptedPosition;
    protected @Nullable Timestamp lastClaimedPosition;

    public TimestampRangeTracker(TimestampRange range) {
        this.range = (TimestampRange)Preconditions.checkNotNull((Object)range);
    }

    public boolean tryClaim(Timestamp position) {
        Preconditions.checkArgument((this.lastAttemptedPosition == null || position.compareTo(this.lastAttemptedPosition) > 0 ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s", (Object)position, (Object)this.lastAttemptedPosition);
        Preconditions.checkArgument((position.compareTo(this.range.getFrom()) >= 0 ? 1 : 0) != 0, (String)"Trying to claim offset %s before start of the range %s", (Object)position, (Object)this.range);
        this.lastAttemptedPosition = position;
        if (position.compareTo(this.range.getTo()) >= 0) {
            return false;
        }
        this.lastClaimedPosition = position;
        return true;
    }

    public @Nullable SplitResult<TimestampRange> trySplit(double fractionOfRemainder) {
        BigDecimal toInNanos;
        BigDecimal nanosOffset;
        BigDecimal fromInNanos = TimestampUtils.toNanos(this.range.getFrom());
        BigDecimal currentInNanos = this.lastAttemptedPosition == null ? fromInNanos.subtract(BigDecimal.ONE, MathContext.DECIMAL128) : TimestampUtils.toNanos(this.lastAttemptedPosition);
        BigDecimal splitPositionInNanos = currentInNanos.add(nanosOffset = (toInNanos = TimestampUtils.toNanos(this.range.getTo())).subtract(currentInNanos, MathContext.DECIMAL128).multiply(BigDecimal.valueOf(fractionOfRemainder), MathContext.DECIMAL128).max(BigDecimal.ONE), MathContext.DECIMAL128);
        Timestamp splitPosition = TimestampUtils.toTimestamp(splitPositionInNanos);
        if (splitPosition.compareTo(this.range.getTo()) >= 0) {
            return null;
        }
        TimestampRange primary = new TimestampRange(this.range.getFrom(), splitPosition);
        TimestampRange residual = new TimestampRange(splitPosition, this.range.getTo());
        this.range = primary;
        return SplitResult.of((Object)primary, (Object)residual);
    }

    public void checkDone() throws IllegalStateException {
        if (this.range.getFrom().compareTo(this.range.getTo()) == 0) {
            return;
        }
        Preconditions.checkState((this.lastAttemptedPosition != null ? 1 : 0) != 0, (String)"Key range is non-empty %s and no keys have been attempted.", (Object)this.range);
        Timestamp nextPosition = TimestampUtils.next(this.lastAttemptedPosition);
        if (nextPosition.compareTo(this.range.getTo()) < 0) {
            throw new IllegalStateException(String.format("Last attempted key was %s in range %s, claiming work in [%s, %s) was not attempted", this.lastAttemptedPosition, this.range, nextPosition, this.range.getTo()));
        }
    }

    public RestrictionTracker.Progress getProgress() {
        BigDecimal fromInNanos = TimestampUtils.toNanos(this.range.getFrom());
        BigDecimal toInNanos = TimestampUtils.toNanos(this.range.getTo());
        BigDecimal totalWork = toInNanos.subtract(fromInNanos, MathContext.DECIMAL128);
        if (this.lastAttemptedPosition == null) {
            double workCompleted = 0.0;
            double workRemaining = 1.0;
            return RestrictionTracker.Progress.from((double)0.0, (double)1.0);
        }
        BigDecimal currentInNanos = TimestampUtils.toNanos(this.lastAttemptedPosition);
        BigDecimal workRemainingInNanos = toInNanos.subtract(currentInNanos, MathContext.DECIMAL128).max(BigDecimal.ZERO);
        double workCompleted = totalWork.subtract(workRemainingInNanos, MathContext.DECIMAL128).divide(totalWork, MathContext.DECIMAL128).doubleValue();
        double workRemaining = workRemainingInNanos.divide(totalWork, MathContext.DECIMAL128).doubleValue();
        return RestrictionTracker.Progress.from((double)workCompleted, (double)workRemaining);
    }

    public TimestampRange currentRestriction() {
        return this.range;
    }

    public RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.BOUNDED;
    }
}

