/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.flattener;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.flattener.FlattenerMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FlattenerDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = FlattenerMeta.class;
    private TableView wFields;
    private CCombo wField;
    private boolean gotPreviousFields = false;
    private FlattenerMeta input;

    public FlattenerDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (FlattenerMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FlattenerDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FlattenerDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlField = new Label((Composite)this.shell, 131072);
        wlField.setText(BaseMessages.getString(PKG, (String)"FlattenerDialog.FlattenField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlField);
        FormData fdlField = new FormData();
        fdlField.left = new FormAttachment(0, 0);
        fdlField.right = new FormAttachment(middle, -margin);
        fdlField.top = new FormAttachment((Control)this.wTransformName, margin);
        wlField.setLayoutData((Object)fdlField);
        this.wField = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wField);
        this.wField.addModifyListener(lsMod);
        FormData fdField = new FormData();
        fdField.left = new FormAttachment(middle, 0);
        fdField.top = new FormAttachment((Control)this.wTransformName, margin);
        fdField.right = new FormAttachment(100, 0);
        this.wField.setLayoutData((Object)fdField);
        this.wField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)FlattenerDialog.this.shell.getDisplay(), 1);
                FlattenerDialog.this.shell.setCursor(busy);
                FlattenerDialog.this.getFields();
                FlattenerDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"FlattenerDialog.TargetField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wField, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int nrKeyCols = 1;
        int nrKeyRows = this.input.getTargetField() != null ? this.input.getTargetField().length : 1;
        ColumnInfo[] ciKey = new ColumnInfo[nrKeyCols];
        ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FlattenerDialog.ColumnInfo.TargetField", (String[])new String[0]), 1, false);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 68354, ciKey, nrKeyRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, -margin);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wField.getText();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wField.setText(field);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FlattenerDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FlattenerDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"FlattenerDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getFieldName() != null) {
            this.wField.setText(this.input.getFieldName());
        }
        if (this.input.getTargetField() != null) {
            for (int i = 0; i < this.input.getTargetField().length; ++i) {
                TableItem item = this.wFields.table.getItem(i);
                if (this.input.getTargetField()[i] == null) continue;
                item.setText(1, this.input.getTargetField()[i]);
            }
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int nrTargets = this.wFields.nrNonEmpty();
        this.input.setFieldName(this.wField.getText());
        this.input.allocate(nrTargets);
        for (int i = 0; i < nrTargets; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getTargetField()[i] = item.getText(1);
        }
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }
}

