/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Validations;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class ConditionalRowMutation
implements Serializable {
    private static final long serialVersionUID = -3699904745621909502L;
    private final String tableId;
    private transient CheckAndMutateRowRequest.Builder builder = CheckAndMutateRowRequest.newBuilder();

    private ConditionalRowMutation(String tableId, ByteString rowKey) {
        this.tableId = tableId;
        this.builder.setRowKey(rowKey);
    }

    public static ConditionalRowMutation create(String tableId, String rowKey) {
        return ConditionalRowMutation.create(tableId, ByteString.copyFromUtf8(rowKey));
    }

    public static ConditionalRowMutation create(String tableId, ByteString rowKey) {
        Validations.validateTableId(tableId);
        return new ConditionalRowMutation(tableId, rowKey);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (CheckAndMutateRowRequest.Builder)CheckAndMutateRowRequest.newBuilder().mergeFrom(input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo(output);
    }

    public ConditionalRowMutation condition(@Nonnull Filters.Filter condition) {
        Preconditions.checkNotNull(condition);
        Preconditions.checkState(!this.builder.hasPredicateFilter(), "Can only have a single condition, please use a Filters#chain or Filters#interleave filter instead");
        this.builder.setPredicateFilter(condition.toProto());
        return this;
    }

    public ConditionalRowMutation then(@Nonnull Mutation mutation) {
        Preconditions.checkNotNull(mutation);
        this.builder.addAllTrueMutations(mutation.getMutations());
        return this;
    }

    public ConditionalRowMutation otherwise(@Nonnull Mutation mutation) {
        Preconditions.checkNotNull(mutation);
        this.builder.addAllFalseMutations(mutation.getMutations());
        return this;
    }

    @InternalApi
    public CheckAndMutateRowRequest toProto(RequestContext requestContext) {
        Preconditions.checkState(!this.builder.getTrueMutationsList().isEmpty() || !this.builder.getFalseMutationsList().isEmpty(), "ConditionalRowMutations must have `then` or `otherwise` mutations.");
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return this.builder.setTableName(tableName.toString()).setAppProfileId(requestContext.getAppProfileId()).build();
    }

    @BetaApi
    public static ConditionalRowMutation fromProto(@Nonnull CheckAndMutateRowRequest request) {
        String tableId = NameUtil.extractTableIdFromTableName(request.getTableName());
        ConditionalRowMutation rowMutation = ConditionalRowMutation.create(tableId, request.getRowKey());
        rowMutation.builder = request.toBuilder();
        return rowMutation;
    }
}

