/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.alts.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import com.google.bigtable.repackaged.com.google.common.primitives.Ints;
import com.google.bigtable.repackaged.io.grpc.alts.internal.ChannelCrypterNetty;
import com.google.bigtable.repackaged.io.grpc.alts.internal.TsiFrameProtector;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;

public final class AltsTsiFrameProtector
implements TsiFrameProtector {
    private static final int HEADER_LEN_FIELD_BYTES = 4;
    private static final int HEADER_TYPE_FIELD_BYTES = 4;
    private static final int HEADER_BYTES = 8;
    private static final int HEADER_TYPE_DEFAULT = 6;
    private static final int LIMIT_MAX_ALLOWED_FRAME_SIZE = 0x100000;
    private static final int MIN_FRAME_SIZE = 16384;
    private static final int MAX_FRAME_SIZE = 131072;
    private final Protector protector;
    private final Unprotector unprotector;

    public AltsTsiFrameProtector(int maxProtectedFrameBytes, ChannelCrypterNetty crypter, ByteBufAllocator alloc) {
        Preconditions.checkArgument(maxProtectedFrameBytes > 8 + crypter.getSuffixLength());
        maxProtectedFrameBytes = Math.min(0x100000, maxProtectedFrameBytes);
        this.protector = new Protector(maxProtectedFrameBytes, crypter);
        this.unprotector = new Unprotector(crypter, alloc);
    }

    static int getHeaderLenFieldBytes() {
        return 4;
    }

    static int getHeaderTypeFieldBytes() {
        return 4;
    }

    public static int getHeaderBytes() {
        return 8;
    }

    static int getHeaderTypeDefault() {
        return 6;
    }

    static int getLimitMaxAllowedFrameSize() {
        return 0x100000;
    }

    public static int getMinFrameSize() {
        return 16384;
    }

    public static int getMaxFrameSize() {
        return 131072;
    }

    @Override
    public void protectFlush(List<ByteBuf> unprotectedBufs, TsiFrameProtector.Consumer<ByteBuf> ctxWrite, ByteBufAllocator alloc) throws GeneralSecurityException {
        this.protector.protectFlush(unprotectedBufs, ctxWrite, alloc);
    }

    @Override
    public void unprotect(ByteBuf in, List<Object> out, ByteBufAllocator alloc) throws GeneralSecurityException {
        this.unprotector.unprotect(in, out, alloc);
    }

    @Override
    public void destroy() {
        try {
            this.unprotector.destroy();
        }
        finally {
            this.protector.destroy();
        }
    }

    private static ByteBuf writeSlice(ByteBuf in, int len) {
        Preconditions.checkArgument(len <= in.writableBytes());
        ByteBuf out = in.slice(in.writerIndex(), len);
        in.writerIndex(in.writerIndex() + len);
        return out.writerIndex(0);
    }

    private static enum DeframerState {
        READ_HEADER,
        READ_PROTECTED_PAYLOAD;

    }

    static final class Unprotector {
        private final int suffixBytes;
        private final ChannelCrypterNetty crypter;
        private DeframerState state = DeframerState.READ_HEADER;
        private int requiredProtectedBytes;
        private ByteBuf header;
        private ByteBuf firstFrameTag;
        private int unhandledIdx = 0;
        private long unhandledBytes = 0L;
        private List<ByteBuf> unhandledBufs = new ArrayList<ByteBuf>(16);

        Unprotector(ChannelCrypterNetty crypter, ByteBufAllocator alloc) {
            this.crypter = crypter;
            this.suffixBytes = crypter.getSuffixLength();
            this.header = alloc.directBuffer(8);
            this.firstFrameTag = alloc.directBuffer(this.suffixBytes);
        }

        private void addUnhandled(ByteBuf in) {
            if (in.isReadable()) {
                ByteBuf buf = in.readRetainedSlice(in.readableBytes());
                this.unhandledBufs.add(buf);
                this.unhandledBytes += (long)buf.readableBytes();
            }
        }

        void unprotect(ByteBuf in, List<Object> out, ByteBufAllocator alloc) throws GeneralSecurityException {
            Preconditions.checkState(this.header != null, "Cannot unprotect after destroy.");
            this.addUnhandled(in);
            this.decodeFrame(alloc, out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decodeFrame(ByteBufAllocator alloc, List<Object> out) throws GeneralSecurityException {
            switch (this.state) {
                case READ_HEADER: {
                    if (this.unhandledBytes < 8L) {
                        return;
                    }
                    this.handleHeader();
                }
                case READ_PROTECTED_PAYLOAD: {
                    ByteBuf unprotectedBuf;
                    if (this.unhandledBytes < (long)this.requiredProtectedBytes) {
                        return;
                    }
                    try {
                        unprotectedBuf = this.handlePayload(alloc);
                    }
                    finally {
                        this.clearState();
                    }
                    if (unprotectedBuf == null) break;
                    out.add(unprotectedBuf);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"impossible enum value");
                }
            }
        }

        private void handleHeader() {
            while (this.header.isWritable()) {
                ByteBuf in = this.unhandledBufs.get(this.unhandledIdx);
                int headerBytesToRead = Math.min(in.readableBytes(), this.header.writableBytes());
                this.header.writeBytes(in, headerBytesToRead);
                this.unhandledBytes -= (long)headerBytesToRead;
                if (in.isReadable()) continue;
                ++this.unhandledIdx;
            }
            this.requiredProtectedBytes = this.header.readIntLE() - 4;
            Preconditions.checkArgument(this.requiredProtectedBytes >= this.suffixBytes, "Invalid header field: frame size too small");
            Preconditions.checkArgument(this.requiredProtectedBytes <= 1048568, "Invalid header field: frame size too large");
            int frameType = this.header.readIntLE();
            Preconditions.checkArgument(frameType == 6, "Invalid header field: frame type");
            this.state = DeframerState.READ_PROTECTED_PAYLOAD;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuf handlePayload(ByteBufAllocator alloc) throws GeneralSecurityException {
            ArrayList<ByteBuf> firstFrameCiphertext;
            int firstFrameUnprotectedLen;
            block10: {
                ByteBuf buf;
                int requiredCiphertextBytes;
                firstFrameUnprotectedLen = requiredCiphertextBytes = this.requiredProtectedBytes - this.suffixBytes;
                firstFrameCiphertext = new ArrayList<ByteBuf>();
                while (requiredCiphertextBytes > 0) {
                    ByteBuf buf2 = this.unhandledBufs.get(this.unhandledIdx);
                    if (buf2.readableBytes() <= requiredCiphertextBytes) {
                        firstFrameCiphertext.add(buf2);
                        requiredCiphertextBytes -= buf2.readableBytes();
                        ++this.unhandledIdx;
                        continue;
                    }
                    firstFrameCiphertext.add(buf2.readSlice(requiredCiphertextBytes));
                    requiredCiphertextBytes = 0;
                }
                int requiredSuffixBytes = this.suffixBytes;
                while ((buf = this.unhandledBufs.get(this.unhandledIdx)).readableBytes() <= requiredSuffixBytes) {
                    this.firstFrameTag.writeBytes(buf);
                    if ((requiredSuffixBytes -= buf.readableBytes()) != 0) {
                        ++this.unhandledIdx;
                        continue;
                    }
                    break block10;
                }
                this.firstFrameTag.writeBytes(buf, requiredSuffixBytes);
            }
            Verify.verify(this.unhandledIdx == this.unhandledBufs.size() - 1);
            ByteBuf lastBuf = this.unhandledBufs.get(this.unhandledIdx);
            ArrayList<ByteBuf> ciphertextsAndTags = new ArrayList<ByteBuf>();
            ArrayList<Integer> unprotectedLens = new ArrayList<Integer>();
            long requiredUnprotectedBytesCompleteFrames = firstFrameUnprotectedLen;
            while (lastBuf.readableBytes() >= 8 + this.suffixBytes) {
                int frameSize = lastBuf.readIntLE();
                int payloadSize = frameSize - 4 - this.suffixBytes;
                if (lastBuf.readableBytes() < frameSize) {
                    lastBuf.readerIndex(lastBuf.readerIndex() - 4);
                    break;
                }
                Preconditions.checkArgument(lastBuf.readIntLE() == 6);
                ciphertextsAndTags.add(lastBuf.readSlice(payloadSize + this.suffixBytes));
                requiredUnprotectedBytesCompleteFrames += (long)payloadSize;
                unprotectedLens.add(payloadSize);
            }
            ByteBuf unprotectedBuf = alloc.directBuffer(Ints.checkedCast(requiredUnprotectedBytesCompleteFrames + (long)this.suffixBytes));
            try {
                ByteBuf out = AltsTsiFrameProtector.writeSlice(unprotectedBuf, firstFrameUnprotectedLen + this.suffixBytes);
                this.crypter.decrypt(out, this.firstFrameTag, firstFrameCiphertext);
                Verify.verify(out.writableBytes() == this.suffixBytes);
                unprotectedBuf.writerIndex(unprotectedBuf.writerIndex() - this.suffixBytes);
                for (int frameIdx = 0; frameIdx < ciphertextsAndTags.size(); ++frameIdx) {
                    out = AltsTsiFrameProtector.writeSlice(unprotectedBuf, (Integer)unprotectedLens.get(frameIdx) + this.suffixBytes);
                    this.crypter.decrypt(out, (ByteBuf)ciphertextsAndTags.get(frameIdx));
                    Verify.verify(out.writableBytes() == this.suffixBytes);
                    unprotectedBuf.writerIndex(unprotectedBuf.writerIndex() - this.suffixBytes);
                }
                ByteBuf byteBuf = unprotectedBuf.retain();
                return byteBuf;
            }
            finally {
                unprotectedBuf.release();
            }
        }

        private void clearState() {
            int bufsSize = this.unhandledBufs.size();
            ByteBuf lastBuf = this.unhandledBufs.get(bufsSize - 1);
            boolean keepLast = lastBuf.isReadable();
            for (int bufIdx = 0; bufIdx < (keepLast ? bufsSize - 1 : bufsSize); ++bufIdx) {
                this.unhandledBufs.get(bufIdx).release();
            }
            this.unhandledBufs.clear();
            this.unhandledBytes = 0L;
            this.unhandledIdx = 0;
            if (keepLast) {
                this.unhandledBufs.add(lastBuf);
                this.unhandledBytes = lastBuf.readableBytes();
            }
            this.state = DeframerState.READ_HEADER;
            this.requiredProtectedBytes = 0;
            this.header.clear();
            this.firstFrameTag.clear();
        }

        void destroy() {
            for (ByteBuf unhandledBuf : this.unhandledBufs) {
                unhandledBuf.release();
            }
            this.unhandledBufs.clear();
            if (this.header != null) {
                this.header.release();
                this.header = null;
            }
            if (this.firstFrameTag != null) {
                this.firstFrameTag.release();
                this.firstFrameTag = null;
            }
            this.crypter.destroy();
        }
    }

    static final class Protector {
        private final int maxUnprotectedBytesPerFrame;
        private final int suffixBytes;
        private ChannelCrypterNetty crypter;

        Protector(int maxProtectedFrameBytes, ChannelCrypterNetty crypter) {
            this.suffixBytes = crypter.getSuffixLength();
            this.maxUnprotectedBytesPerFrame = maxProtectedFrameBytes - 8 - this.suffixBytes;
            this.crypter = crypter;
        }

        void destroy() {
            this.crypter = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void protectFlush(List<ByteBuf> unprotectedBufs, TsiFrameProtector.Consumer<ByteBuf> ctxWrite, ByteBufAllocator alloc) throws GeneralSecurityException {
            ByteBuf protectedBuf;
            Preconditions.checkState(this.crypter != null, "Cannot protectFlush after destroy.");
            try {
                protectedBuf = this.handleUnprotected(unprotectedBufs, alloc);
            }
            finally {
                for (ByteBuf buf : unprotectedBufs) {
                    buf.release();
                }
            }
            if (protectedBuf != null) {
                ctxWrite.accept(protectedBuf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuf handleUnprotected(List<ByteBuf> unprotectedBufs, ByteBufAllocator alloc) throws GeneralSecurityException {
            long unprotectedBytes = 0L;
            for (ByteBuf buf : unprotectedBufs) {
                unprotectedBytes += (long)buf.readableBytes();
            }
            Preconditions.checkArgument(unprotectedBytes > 0L);
            long frameNum = unprotectedBytes / (long)this.maxUnprotectedBytesPerFrame + 1L;
            int lastFrameUnprotectedBytes = (int)(unprotectedBytes % (long)this.maxUnprotectedBytesPerFrame);
            if (lastFrameUnprotectedBytes == 0) {
                --frameNum;
                lastFrameUnprotectedBytes = this.maxUnprotectedBytesPerFrame;
            }
            long protectedBytes = frameNum * (long)(8 + this.suffixBytes) + unprotectedBytes;
            ByteBuf protectedBuf = alloc.directBuffer(Ints.checkedCast(protectedBytes));
            try {
                int bufferIdx = 0;
                int frameIdx = 0;
                while ((long)frameIdx < frameNum) {
                    int unprotectedBytesLeft = (long)frameIdx == frameNum - 1L ? lastFrameUnprotectedBytes : this.maxUnprotectedBytesPerFrame;
                    protectedBuf.writeIntLE(unprotectedBytesLeft + 4 + this.suffixBytes);
                    protectedBuf.writeIntLE(6);
                    ByteBuf frameOut = AltsTsiFrameProtector.writeSlice(protectedBuf, unprotectedBytesLeft + this.suffixBytes);
                    ArrayList<ByteBuf> framePlain = new ArrayList<ByteBuf>();
                    while (unprotectedBytesLeft > 0) {
                        ByteBuf in = unprotectedBufs.get(bufferIdx);
                        if (in.readableBytes() <= unprotectedBytesLeft) {
                            framePlain.add(in);
                            unprotectedBytesLeft -= in.readableBytes();
                            ++bufferIdx;
                            continue;
                        }
                        framePlain.add(in.readSlice(unprotectedBytesLeft));
                        unprotectedBytesLeft = 0;
                    }
                    this.crypter.encrypt(frameOut, framePlain);
                    Verify.verify(!frameOut.isWritable());
                    ++frameIdx;
                }
                protectedBuf.readerIndex(0);
                protectedBuf.writerIndex(protectedBuf.capacity());
                ByteBuf byteBuf = protectedBuf.retain();
                return byteBuf;
            }
            finally {
                protectedBuf.release();
            }
        }
    }
}

