/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.io.grpc.Internal;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.JsonUtil;
import com.google.bigtable.repackaged.io.grpc.xds.RingHashLoadBalancer;
import java.util.Map;

@Internal
public final class RingHashLoadBalancerProvider
extends LoadBalancerProvider {
    @VisibleForTesting
    static final long DEFAULT_MIN_RING_SIZE = 1024L;
    @VisibleForTesting
    static final long DEFAULT_MAX_RING_SIZE = 0x800000L;
    static final long MAX_RING_SIZE = 0x800000L;
    private static final boolean enableRingHash = Strings.isNullOrEmpty(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH"));

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RingHashLoadBalancer(helper);
    }

    @Override
    public boolean isAvailable() {
        return enableRingHash;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "ring_hash_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        Long minRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, "minRingSize");
        Long maxRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, "maxRingSize");
        if (minRingSize == null) {
            minRingSize = 1024L;
        }
        if (maxRingSize == null) {
            maxRingSize = 0x800000L;
        }
        if (minRingSize <= 0L || maxRingSize <= 0L || minRingSize > maxRingSize || maxRingSize > 0x800000L) {
            return NameResolver.ConfigOrError.fromError(Status.INVALID_ARGUMENT.withDescription("Invalid 'mingRingSize'/'maxRingSize'"));
        }
        return NameResolver.ConfigOrError.fromConfig(new RingHashLoadBalancer.RingHashConfig(minRingSize, maxRingSize));
    }
}

