/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.contrib.resource.util;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.io.opencensus.contrib.resource.util.CloudResource;
import com.google.bigtable.repackaged.io.opencensus.contrib.resource.util.ContainerResource;
import com.google.bigtable.repackaged.io.opencensus.contrib.resource.util.HostResource;
import com.google.bigtable.repackaged.io.opencensus.contrib.resource.util.K8sResource;
import com.google.bigtable.repackaged.io.opencensus.resource.Resource;
import java.util.ArrayList;
import java.util.Collections;

public final class ResourceUtils {
    static final Resource EMPTY_RESOURCE = Resource.create(null, Collections.<String, String>emptyMap());

    public static Resource detectResource() {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        resourceList.add(Resource.createFromEnvironmentVariables());
        if (System.getenv("KUBERNETES_SERVICE_HOST") != null) {
            resourceList.add(ContainerResource.detect());
            resourceList.add(K8sResource.detect());
        }
        resourceList.add(HostResource.detect());
        resourceList.add(CloudResource.detect());
        return MoreObjects.firstNonNull(Resource.mergeResources(resourceList), EMPTY_RESOURCE);
    }

    private ResourceUtils() {
    }
}

