/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.trace;

import com.google.bigtable.repackaged.io.opencensus.common.Clock;
import com.google.bigtable.repackaged.io.opencensus.internal.ZeroTimeClock;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracer;
import com.google.bigtable.repackaged.io.opencensus.trace.config.TraceConfig;
import com.google.bigtable.repackaged.io.opencensus.trace.export.ExportComponent;
import com.google.bigtable.repackaged.io.opencensus.trace.propagation.PropagationComponent;

public abstract class TraceComponent {
    public abstract Tracer getTracer();

    public abstract PropagationComponent getPropagationComponent();

    public abstract Clock getClock();

    public abstract ExportComponent getExportComponent();

    public abstract TraceConfig getTraceConfig();

    static TraceComponent newNoopTraceComponent() {
        return new NoopTraceComponent();
    }

    private static final class NoopTraceComponent
    extends TraceComponent {
        private final ExportComponent noopExportComponent = ExportComponent.newNoopExportComponent();

        @Override
        public Tracer getTracer() {
            return Tracer.getNoopTracer();
        }

        @Override
        public PropagationComponent getPropagationComponent() {
            return PropagationComponent.getNoopPropagationComponent();
        }

        @Override
        public Clock getClock() {
            return ZeroTimeClock.getInstance();
        }

        @Override
        public ExportComponent getExportComponent() {
            return this.noopExportComponent;
        }

        @Override
        public TraceConfig getTraceConfig() {
            return TraceConfig.getNoopTraceConfig();
        }

        private NoopTraceComponent() {
        }
    }
}

