/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.apache.http.client.protocol;

import com.google.bigtable.repackaged.org.apache.http.HttpEntity;
import com.google.bigtable.repackaged.org.apache.http.HttpEntityEnclosingRequest;
import com.google.bigtable.repackaged.org.apache.http.HttpException;
import com.google.bigtable.repackaged.org.apache.http.HttpRequest;
import com.google.bigtable.repackaged.org.apache.http.HttpRequestInterceptor;
import com.google.bigtable.repackaged.org.apache.http.HttpVersion;
import com.google.bigtable.repackaged.org.apache.http.ProtocolVersion;
import com.google.bigtable.repackaged.org.apache.http.annotation.Contract;
import com.google.bigtable.repackaged.org.apache.http.annotation.ThreadingBehavior;
import com.google.bigtable.repackaged.org.apache.http.client.config.RequestConfig;
import com.google.bigtable.repackaged.org.apache.http.client.protocol.HttpClientContext;
import com.google.bigtable.repackaged.org.apache.http.protocol.HttpContext;
import com.google.bigtable.repackaged.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

