/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedInt32
extends OrderedBytesBase<Integer> {
    public static final OrderedInt32 ASCENDING = new OrderedInt32(Order.ASCENDING);
    public static final OrderedInt32 DESCENDING = new OrderedInt32(Order.DESCENDING);

    protected OrderedInt32(Order order) {
        super(order);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int encodedLength(Integer val) {
        return 5;
    }

    @Override
    public Class<Integer> encodedClass() {
        return Integer.class;
    }

    @Override
    public Integer decode(PositionedByteRange src) {
        return OrderedBytes.decodeInt32(src);
    }

    @Override
    public int encode(PositionedByteRange dst, Integer val) {
        if (null == val) {
            throw new IllegalArgumentException("Null values not supported.");
        }
        return OrderedBytes.encodeInt32(dst, val, this.order);
    }

    public int decodeInt(PositionedByteRange src) {
        return OrderedBytes.decodeInt32(src);
    }

    public int encodeInt(PositionedByteRange dst, int val) {
        return OrderedBytes.encodeInt32(dst, val, this.order);
    }
}

