/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrasstableoutput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.plugins.ParentFirst;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.SSTableOutput;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.SSTableOutputData;
import org.w3c.dom.Node;

@Transform(id="SSTableOutput", image="Cassandra.svg", name="SSTable output", documentationUrl="/pipeline/transforms/sstable-output.html", description="Writes to a filesystem directory as a Cassandra SSTable", keywords={"i18n::SSTableOutputMeta.keyword"}, categoryDescription="Cassandra")
@InjectionSupported(localizationPrefix="SSTableOutput.Injection.")
@ParentFirst(patterns={".*"})
public class SSTableOutputMeta
extends BaseTransformMeta<SSTableOutput, SSTableOutputData> {
    protected static final Class<?> PKG = SSTableOutputMeta.class;
    @Injection(name="YAML_FILE_PATH")
    protected String yamlPath;
    @Injection(name="DIRECTORY")
    protected String directory;
    @Injection(name="CASSANDRA_KEYSPACE")
    protected String cassandraKeyspace;
    @Injection(name="TABLE")
    protected String table = "";
    @Injection(name="KEY_FIELD")
    protected String keyField = "";
    @Injection(name="BUFFER_SIZE")
    protected String bufferSize = "16";
    protected boolean useCql3 = true;

    public String getYamlPath() {
        return this.yamlPath;
    }

    public void setYamlPath(String path) {
        this.yamlPath = path;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setCassandraKeyspace(String keyspace) {
        this.cassandraKeyspace = keyspace;
    }

    public String getCassandraKeyspace() {
        return this.cassandraKeyspace;
    }

    public void setTableName(String table) {
        this.table = table;
    }

    public String getTableName() {
        return this.table;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setUseCql3(boolean cql3) {
        this.useCql3 = cql3;
    }

    public boolean getUseCql3() {
        return this.useCql3;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getXml() {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)"yaml_path", (String)this.yamlPath));
        xml.append(XmlHandler.addTagValue((String)"output_directory", (String)this.directory));
        xml.append(XmlHandler.addTagValue((String)"cassandra_keyspace", (String)this.cassandraKeyspace));
        xml.append(XmlHandler.addTagValue((String)"table", (String)this.table));
        xml.append(XmlHandler.addTagValue((String)"key_field", (String)this.keyField));
        xml.append(XmlHandler.addTagValue((String)"buffer_size_mb", (String)this.bufferSize));
        xml.append(XmlHandler.addTagValue((String)"use_cql3", (boolean)this.useCql3));
        return xml.toString();
    }

    public void loadXml(Node node, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.yamlPath = XmlHandler.getTagValue((Node)node, (String)"yaml_path");
        this.directory = XmlHandler.getTagValue((Node)node, (String)"output_directory");
        this.cassandraKeyspace = XmlHandler.getTagValue((Node)node, (String)"cassandra_keyspace");
        this.table = XmlHandler.getTagValue((Node)node, (String)"table");
        this.keyField = XmlHandler.getTagValue((Node)node, (String)"key_field");
        this.bufferSize = XmlHandler.getTagValue((Node)node, (String)"buffer_size_mb");
        this.useCql3 = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)node, (String)"use_cql3"));
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "Transform is connected to previous one, receiving " + prev.size() + " fields", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Transform is receiving info from other transforms.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, "No input received from other transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void setDefault() {
        this.directory = System.getProperty("java.io.tmpdir");
        this.bufferSize = "16";
        this.table = "";
    }
}

