/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.dropbox.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.vfs.dropbox.config.DropboxConfig;

public class DropboxConfigSingleton {
    public static final String HOP_CONFIG_DROPBOX_KEY = "dropbox";
    private static DropboxConfigSingleton configSingleton;
    private DropboxConfig config;

    private DropboxConfigSingleton() {
        Object configObject = HopConfig.getInstance().getConfigMap().get(HOP_CONFIG_DROPBOX_KEY);
        if (configObject == null) {
            this.config = new DropboxConfig();
        } else {
            try {
                ObjectMapper mapper = new ObjectMapper();
                this.config = (DropboxConfig)mapper.readValue(new Gson().toJson(configObject), DropboxConfig.class);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error reading Dropbox configuration, check property 'dropbox' in the Hop config json file", (Throwable)e);
                this.config = new DropboxConfig();
            }
        }
        HopConfig.getInstance().getConfigMap().put(HOP_CONFIG_DROPBOX_KEY, this.config);
    }

    public static DropboxConfig getConfig() {
        if (configSingleton == null) {
            configSingleton = new DropboxConfigSingleton();
        }
        return DropboxConfigSingleton.configSingleton.config;
    }

    public static void saveConfig() throws HopException {
        HopConfig.getInstance().saveOption(HOP_CONFIG_DROPBOX_KEY, (Object)DropboxConfigSingleton.configSingleton.config);
        HopConfig.getInstance().saveToFile();
    }
}

