/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamKafkaInputTransform;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.kafka.BeamConsume;
import org.apache.hop.beam.transforms.kafka.BeamConsumeDialog;
import org.apache.hop.beam.transforms.kafka.ConfigOption;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyData;

@Transform(id="BeamKafkaConsume", name="Beam Kafka Consume", description="Get messages from Kafka topics (Kafka Consumer)", image="beam-kafka-input.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamConsumeMeta.keyword"}, documentationUrl="/pipeline/transforms/beamkafkaconsume.html")
public class BeamConsumeMeta
extends BaseTransformMeta<BeamConsume, DummyData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty
    private String topics = "Topic1,Topic2";
    @HopMetadataProperty(key="bootstrap_servers")
    private String bootstrapServers = "bootstrapServer1:9001,bootstrapServer2:9001";
    @HopMetadataProperty(key="key_field")
    private String keyField = "key";
    @HopMetadataProperty(key="message_field")
    private String messageField = "message";
    @HopMetadataProperty(key="message_type")
    private String messageType = "String";
    @HopMetadataProperty(key="schema_registry_url")
    private String schemaRegistryUrl;
    @HopMetadataProperty(key="schema_registry_subject")
    private String schemaRegistrySubject;
    @HopMetadataProperty(key="group_id")
    private String groupId = "GroupID";
    @HopMetadataProperty(key="use_processing_time")
    private boolean usingProcessingTime = true;
    @HopMetadataProperty(key="use_log_append_time")
    private boolean usingLogAppendTime = false;
    @HopMetadataProperty(key="use_create_time")
    private boolean usingCreateTime = false;
    @HopMetadataProperty(key="restrict_to_committed")
    private boolean restrictedToCommitted = false;
    @HopMetadataProperty(key="allow_commit_on_consumed")
    private boolean allowingCommitOnConsumedOffset = true;
    @HopMetadataProperty(groupKey="config_options", key="config_option")
    private List<ConfigOption> configOptions = new ArrayList<ConfigOption>();

    public String getDialogClassName() {
        return BeamConsumeDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            ValueMetaString keyValueMeta = new ValueMetaString(variables.resolve(this.keyField));
            keyValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)keyValueMeta);
            String typeString = Const.NVL((String)variables.resolve(this.messageType), (String)"String");
            int type = ValueMetaFactory.getIdForValueMeta((String)typeString);
            IValueMeta messageValueMeta = ValueMetaFactory.createValueMeta((String)variables.resolve(this.messageField), (int)type);
            messageValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta(messageValueMeta);
        }
        catch (Exception e) {
            throw new HopTransformException("Error calculating transform output field layout", (Throwable)e);
        }
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        RowMeta outputRowMeta = new RowMeta();
        this.getFields((IRowMeta)outputRowMeta, transformMeta.getName(), null, null, variables, null);
        String[] parameters = new String[this.getConfigOptions().size()];
        String[] values = new String[this.getConfigOptions().size()];
        String[] types = new String[this.getConfigOptions().size()];
        for (int i = 0; i < parameters.length; ++i) {
            ConfigOption option = this.getConfigOptions().get(i);
            parameters[i] = variables.resolve(option.getParameter());
            values[i] = variables.resolve(option.getValue());
            types[i] = option.getType() == null ? ConfigOption.Type.String.name() : option.getType().name();
        }
        BeamKafkaInputTransform beamInputTransform = new BeamKafkaInputTransform(transformMeta.getName(), transformMeta.getName(), variables.resolve(this.getBootstrapServers()), variables.resolve(this.getTopics()), variables.resolve(this.getGroupId()), this.isUsingProcessingTime(), this.isUsingLogAppendTime(), this.isUsingCreateTime(), this.isRestrictedToCommitted(), this.isAllowingCommitOnConsumedOffset(), parameters, values, types, variables.resolve(this.getMessageType()), variables.resolve(this.getSchemaRegistryUrl()), variables.resolve(this.getSchemaRegistrySubject()), JsonRowMeta.toJson((IRowMeta)outputRowMeta), transformPluginClasses, xpPluginClasses);
        PCollection afterInput = (PCollection)pipeline.apply((PTransform)beamInputTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)afterInput);
        log.logBasic("Handled transform (KAFKA INPUT) : " + transformMeta.getName());
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public String getTopics() {
        return this.topics;
    }

    public void setTopics(String topics) {
        this.topics = topics;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getSchemaRegistryUrl() {
        return this.schemaRegistryUrl;
    }

    public void setSchemaRegistryUrl(String schemaRegistryUrl) {
        this.schemaRegistryUrl = schemaRegistryUrl;
    }

    public String getSchemaRegistrySubject() {
        return this.schemaRegistrySubject;
    }

    public void setSchemaRegistrySubject(String schemaRegistrySubject) {
        this.schemaRegistrySubject = schemaRegistrySubject;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isUsingProcessingTime() {
        return this.usingProcessingTime;
    }

    public void setUsingProcessingTime(boolean usingProcessingTime) {
        this.usingProcessingTime = usingProcessingTime;
    }

    public boolean isUsingLogAppendTime() {
        return this.usingLogAppendTime;
    }

    public void setUsingLogAppendTime(boolean usingLogAppendTime) {
        this.usingLogAppendTime = usingLogAppendTime;
    }

    public boolean isUsingCreateTime() {
        return this.usingCreateTime;
    }

    public void setUsingCreateTime(boolean usingCreateTime) {
        this.usingCreateTime = usingCreateTime;
    }

    public boolean isRestrictedToCommitted() {
        return this.restrictedToCommitted;
    }

    public void setRestrictedToCommitted(boolean restrictedToCommitted) {
        this.restrictedToCommitted = restrictedToCommitted;
    }

    public boolean isAllowingCommitOnConsumedOffset() {
        return this.allowingCommitOnConsumedOffset;
    }

    public void setAllowingCommitOnConsumedOffset(boolean allowingCommitOnConsumedOffset) {
        this.allowingCommitOnConsumedOffset = allowingCommitOnConsumedOffset;
    }

    public List<ConfigOption> getConfigOptions() {
        return this.configOptions;
    }

    public void setConfigOptions(List<ConfigOption> configOptions) {
        this.configOptions = configOptions;
    }
}

