/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kinesis;

import com.amazonaws.regions.Regions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.kinesis.BeamKinesisProduce;
import org.apache.hop.beam.transforms.kinesis.BeamKinesisProduceDialog;
import org.apache.hop.beam.transforms.kinesis.BeamKinesisProduceTransform;
import org.apache.hop.beam.transforms.kinesis.KinesisConfigOption;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyData;

@Transform(id="BeamKinesisProduce", name="i18n::BeamKinesisProduceMeta.name", description="i18n::BeamKinesisProduceMeta.description", image="beam-kinesis-produce.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamKinesisProduceMeta.keyword"}, documentationUrl="/pipeline/transforms/beamkinesisproduce.html")
public class BeamKinesisProduceMeta
extends BaseTransformMeta<BeamKinesisProduce, DummyData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="access_key")
    private String accessKey;
    @HopMetadataProperty(key="secret_key", password=true)
    private String secretKey;
    @HopMetadataProperty(key="stream_name", password=true)
    private String streamName = "stream-name";
    @HopMetadataProperty(key="data_field")
    private String dataField;
    @HopMetadataProperty(key="message_type")
    private String dataType;
    @HopMetadataProperty(key="partition_key_field")
    private String partitionKey;
    @HopMetadataProperty(groupKey="config_options", key="config_option")
    private List<KinesisConfigOption> configOptions = new ArrayList<KinesisConfigOption>();

    public String getDialogClassName() {
        return BeamKinesisProduceDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        inputRowMeta.clear();
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        String[] parameters = new String[this.getConfigOptions().size()];
        String[] values = new String[this.getConfigOptions().size()];
        for (int i = 0; i < parameters.length; ++i) {
            KinesisConfigOption option = this.getConfigOptions().get(i);
            parameters[i] = variables.resolve(option.getParameter());
            values[i] = variables.resolve(option.getValue());
        }
        String dataFieldName = variables.resolve(this.getDataField());
        IValueMeta messageValueMeta = rowMeta.searchValueMeta(dataFieldName);
        if (messageValueMeta == null) {
            throw new HopException("Error finding message/data field " + dataFieldName + " in the input rows");
        }
        BeamKinesisProduceTransform beamProduceTransform = new BeamKinesisProduceTransform(transformMeta.getName(), JsonRowMeta.toJson((IRowMeta)rowMeta), transformPluginClasses, xpPluginClasses, variables.resolve(this.accessKey), variables.resolve(this.secretKey), Regions.DEFAULT_REGION, variables.resolve(this.streamName), dataFieldName, variables.resolve(this.dataType), variables.resolve(this.partitionKey), parameters, values);
        if (previousTransforms.size() > 1) {
            throw new HopException("Combining data from multiple transforms is not supported yet!");
        }
        TransformMeta previousTransform = previousTransforms.get(0);
        input.apply((PTransform)beamProduceTransform);
        log.logBasic("Handled transform (KINESIS OUTPUT) : " + transformMeta.getName() + ", gets data from " + previousTransform.getName());
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getDataField() {
        return this.dataField;
    }

    public void setDataField(String dataField) {
        this.dataField = dataField;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public List<KinesisConfigOption> getConfigOptions() {
        return this.configOptions;
    }

    public void setConfigOptions(List<KinesisConfigOption> configOptions) {
        this.configOptions = configOptions;
    }
}

