/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.com.google.common.collect.BoundType;
import com.google.bigtable.repackaged.com.google.common.collect.Range;
import com.google.bigtable.repackaged.com.google.common.collect.RangeSet;
import com.google.bigtable.repackaged.com.google.common.collect.TreeRangeSet;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadOperationAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.read.RowRangeAdapter;
import com.google.cloud.bigtable.hbase.util.RowKeyWrapper;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;

@InternalApi(value="For internal usage only")
public class ScanAdapter
implements ReadOperationAdapter<Scan> {
    private static final int UNSET_MAX_RESULTS_PER_COLUMN_FAMILY = -1;
    private static final boolean OPEN_CLOSED_AVAILABLE = ScanAdapter.isOpenClosedAvailable();
    private static final boolean LIMIT_AVAILABLE = ScanAdapter.isLimitAvailable();
    private final FilterAdapter filterAdapter;
    private final RowRangeAdapter rowRangeAdapter;

    private static boolean isOpenClosedAvailable() {
        try {
            new Scan().includeStopRow();
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private static boolean isLimitAvailable() {
        try {
            new Scan().setLimit(1);
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    public ScanAdapter(FilterAdapter filterAdapter, RowRangeAdapter rowRangeAdapter) {
        this.filterAdapter = filterAdapter;
        this.rowRangeAdapter = rowRangeAdapter;
    }

    public void throwIfUnsupportedScan(Scan scan) {
        if (scan.getFilter() != null) {
            this.filterAdapter.throwIfUnsupportedFilter(scan, scan.getFilter());
        }
        if (scan.getMaxResultsPerColumnFamily() != -1) {
            throw new UnsupportedOperationException("Limiting of max results per column family is not supported.");
        }
    }

    public Filters.Filter buildFilter(Scan scan, ReadHooks hooks) {
        Optional<Filters.Filter> colFamilyTimeFilter;
        Filters.ChainFilter chain = Filters.FILTERS.chain();
        this.buildStartFilter(scan).forEach(chain::filter);
        Optional<Filters.Filter> userFilter = this.createUserFilter(scan, hooks);
        if (userFilter.isPresent()) {
            chain.filter(userFilter.get());
        }
        if ((colFamilyTimeFilter = this.createColFamilyTimeRange(scan)).isPresent()) {
            chain.filter(colFamilyTimeFilter.get());
        }
        return chain;
    }

    private List<Filters.Filter> buildStartFilter(Scan scan) {
        ArrayList<Filters.Filter> filterList = new ArrayList<Filters.Filter>();
        Optional<Filters.Filter> familyFilter = this.createColumnFamilyFilter(scan);
        if (familyFilter.isPresent()) {
            filterList.add(familyFilter.get());
        }
        boolean hasTimeRange = false;
        if (scan.getTimeRange() != null && !scan.getTimeRange().isAllTime()) {
            filterList.add(this.createTimeRangeFilter(scan.getTimeRange()));
            hasTimeRange = true;
        }
        if (scan.getMaxVersions() != Integer.MAX_VALUE) {
            int i = hasTimeRange ? filterList.size() : 0;
            filterList.add(i, this.createColumnLimitFilter(scan.getMaxVersions()));
        }
        return filterList;
    }

    @Override
    public void adapt(Scan scan, ReadHooks readHooks, Query query) {
        this.throwIfUnsupportedScan(scan);
        this.toByteStringRange(scan, query);
        query.filter(this.buildFilter(scan, readHooks));
        if (LIMIT_AVAILABLE && scan.getLimit() > 0) {
            query.limit(scan.getLimit());
        }
    }

    private void toByteStringRange(Scan scan, Query query) {
        RangeSet<RowKeyWrapper> rangeSet = this.narrowRange(this.getRangeSet(scan), scan.getFilter());
        this.rowRangeAdapter.rangeSetToByteStringRange(rangeSet, query);
    }

    private RangeSet<RowKeyWrapper> getRangeSet(Scan scan) {
        if (scan instanceof BigtableExtendedScan) {
            RowSet rowSet = ((BigtableExtendedScan)scan).getRowSet();
            return this.rowRangeAdapter.rowSetToRangeSet(rowSet);
        }
        TreeRangeSet<RowKeyWrapper> rangeSet = TreeRangeSet.create();
        ByteString startRow = ByteString.copyFrom(scan.getStartRow());
        ByteString stopRow = ByteString.copyFrom(scan.getStopRow());
        if (scan.isGetScan()) {
            rangeSet.add(Range.singleton(new RowKeyWrapper(startRow)));
        } else {
            BoundType startBound = !OPEN_CLOSED_AVAILABLE || scan.includeStartRow() ? BoundType.CLOSED : BoundType.OPEN;
            BoundType endBound = !OPEN_CLOSED_AVAILABLE || !scan.includeStopRow() ? BoundType.OPEN : BoundType.CLOSED;
            rangeSet.add(this.rowRangeAdapter.boundedRange(startBound, startRow, endBound, stopRow));
        }
        return rangeSet;
    }

    private static ByteString quoteRegex(byte[] unquoted) {
        try {
            return ReaderExpressionHelper.quoteRegularExpression(unquoted);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when writing to ByteArrayOutputStream", e);
        }
    }

    private Optional<Filters.Filter> createUserFilter(Scan scan, ReadHooks hooks) {
        if (scan.getFilter() == null) {
            return Optional.absent();
        }
        try {
            return this.filterAdapter.adaptFilter(new FilterAdapterContext(scan, hooks), scan.getFilter());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to adapt filter", ioe);
        }
    }

    private RangeSet<RowKeyWrapper> narrowRange(RangeSet<RowKeyWrapper> rangeSet, Filter filter) {
        if (filter == null) {
            return rangeSet;
        }
        RangeSet<RowKeyWrapper> filterRangeSet = this.filterAdapter.getIndexScanHint(filter);
        if (filterRangeSet.encloses(Range.all())) {
            return rangeSet;
        }
        rangeSet.removeAll(filterRangeSet.complement());
        return rangeSet;
    }

    private Filters.Filter createColumnQualifierFilter(byte[] unquotedQualifier) {
        return Filters.FILTERS.qualifier().regex(ScanAdapter.quoteRegex(unquotedQualifier));
    }

    private Filters.Filter createFamilyFilter(byte[] familyName) {
        return Filters.FILTERS.family().exactMatch(new String(familyName));
    }

    private Filters.Filter createColumnLimitFilter(int maxVersionsPerColumn) {
        return Filters.FILTERS.limit().cellsPerColumn(maxVersionsPerColumn);
    }

    private Filters.Filter createTimeRangeFilter(TimeRange timeRange) {
        Filters.TimestampRangeFilter rangeBuilder = Filters.FILTERS.timestamp().range();
        rangeBuilder.startClosed(this.convertUnits(timeRange.getMin()));
        if (timeRange.getMax() != Long.MAX_VALUE) {
            rangeBuilder.endOpen(this.convertUnits(timeRange.getMax()));
        }
        return rangeBuilder;
    }

    private long convertUnits(long hbaseUnits) {
        return TimestampConverter.hbase2bigtable(hbaseUnits);
    }

    private Optional<Filters.Filter> createColumnFamilyFilter(Scan scan) {
        if (!scan.hasFamilies()) {
            return Optional.absent();
        }
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        Map familyMap = scan.getFamilyMap();
        for (Map.Entry entry : familyMap.entrySet()) {
            Filters.Filter familyFilter = this.createFamilyFilter((byte[])entry.getKey());
            NavigableSet qualifiers = (NavigableSet)entry.getValue();
            if (qualifiers != null) {
                Filters.InterleaveFilter columnFilters = Filters.FILTERS.interleave();
                for (byte[] qualifier : qualifiers) {
                    columnFilters.filter(this.createColumnQualifierFilter(qualifier));
                }
                interleave.filter(Filters.FILTERS.chain().filter(familyFilter).filter(columnFilters));
                continue;
            }
            interleave.filter(familyFilter);
        }
        return Optional.of(interleave);
    }

    private Optional<Filters.Filter> createColFamilyTimeRange(Scan scan) {
        if (scan.getColumnFamilyTimeRange().isEmpty()) {
            return Optional.absent();
        }
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        Map range = scan.getColumnFamilyTimeRange();
        for (Map.Entry entry : range.entrySet()) {
            interleave.filter(Filters.FILTERS.chain().filter(this.createFamilyFilter((byte[])entry.getKey())).filter(this.createTimeRangeFilter((TimeRange)entry.getValue())));
        }
        return Optional.of(interleave);
    }
}

