/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.filter;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

@InternalExtensionOnly
public class TimestampRangeFilter
extends FilterBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long startTimestampInclusive;
    private final long endTimestampExclusive;

    public TimestampRangeFilter(long startTimestamp, long endTimestamp) {
        this.startTimestampInclusive = startTimestamp;
        this.endTimestampExclusive = endTimestamp;
    }

    public long getStartTimestampInclusive() {
        return this.startTimestampInclusive;
    }

    public long getEndTimestampExclusive() {
        return this.endTimestampExclusive;
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        long timestamp = cell.getTimestamp();
        if (this.startTimestampInclusive <= timestamp && timestamp < this.endTimestampExclusive) {
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.SKIP;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TimestampRangeFilter)) {
            return false;
        }
        TimestampRangeFilter other = (TimestampRangeFilter)obj;
        return this.startTimestampInclusive == other.startTimestampInclusive && this.endTimestampExclusive == other.endTimestampExclusive;
    }

    /*
     * Exception decompiling
     */
    public byte[] toByteArray() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TimestampRangeFilter parseFrom(byte[] bytes) throws DeserializationException {
        try (ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            TimestampRangeFilter timestampRangeFilter = (TimestampRangeFilter)is.readObject();
            return timestampRangeFilter;
        }
        catch (Exception e) {
            throw new DeserializationException((Throwable)e);
        }
    }
}

