/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.FlushRowsRequest;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.CustomHttpErrors;
import org.apache.beam.sdk.extensions.gcp.util.LatencyRecordingHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIOMetadata;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Futures;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListenableFuture;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryServicesImpl
implements BigQueryServices {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryServicesImpl.class);
    private static final int MAX_RPC_RETRIES = 9;
    private static final Duration INITIAL_RPC_BACKOFF = Duration.standardSeconds((long)1L);
    private static final Integer MAX_BQ_ROW_PAYLOAD = 0x900000;
    private static final Duration INITIAL_JOB_STATUS_POLL_BACKOFF = Duration.standardSeconds((long)1L);
    private static final FluentBackoff DEFAULT_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF);
    private static final String QUOTA_EXCEEDED = "quotaExceeded";
    private static final String NO_ROWS_PRESENT = "No rows present in the request.";
    protected static final Map<String, String> API_METRIC_LABEL = ImmutableMap.of((Object)"SERVICE", (Object)"BigQuery", (Object)"METHOD", (Object)"BigQueryBatchWrite");
    private static final Metadata.Key<RetryInfo> KEY_RETRY_INFO = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
    static final SerializableFunction<IOException, Boolean> DONT_RETRY_NOT_FOUND = (SerializableFunction & Serializable)input -> {
        ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
        return !errorExtractor.itemNotFound(input);
    };
    static final SerializableFunction<IOException, Boolean> ALWAYS_RETRY = (SerializableFunction & Serializable)input -> true;

    BigQueryServicesImpl() {
    }

    @Override
    public BigQueryServices.JobService getJobService(BigQueryOptions options) {
        return new JobServiceImpl(options);
    }

    @Override
    public BigQueryServices.DatasetService getDatasetService(BigQueryOptions options) {
        return new DatasetServiceImpl(options);
    }

    @Override
    public BigQueryServices.StorageClient getStorageClient(BigQueryOptions options) throws IOException {
        return new StorageClientImpl(options);
    }

    private static BackOff createDefaultBackoff() {
        return BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)DEFAULT_BACKOFF_FACTORY.backoff());
    }

    @VisibleForTesting
    static <T> T executeWithRetries(AbstractGoogleClientRequest<T> request, String errorMessage, Sleeper sleeper, BackOff backoff, SerializableFunction<IOException, Boolean> shouldRetry) throws IOException, InterruptedException {
        IOException lastException = null;
        while (true) {
            try {
                return (T)request.execute();
            }
            catch (IOException e) {
                lastException = e;
                if (((Boolean)shouldRetry.apply((Object)e)).booleanValue()) {
                    LOG.info("Ignore the error and retry the request.", (Throwable)e);
                    if (BigQueryServicesImpl.nextBackOff(sleeper, backoff)) continue;
                }
                throw new IOException(errorMessage, lastException);
            }
            break;
        }
    }

    private static boolean nextBackOff(Sleeper sleeper, BackOff backoff) throws InterruptedException {
        try {
            return BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Bigquery.Builder newBigQueryClient(BigQueryOptions options) {
        RetryHttpRequestInitializer httpRequestInitializer = new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)404));
        httpRequestInitializer.setCustomErrors(BigQueryServicesImpl.createBigQueryClientCustomErrors());
        httpRequestInitializer.setWriteTimeout(options.getHTTPWriteTimeout().intValue());
        ImmutableList.Builder initBuilder = ImmutableList.builder();
        Credentials credential = options.getGcpCredential();
        initBuilder.add(credential == null ? new NullCredentialInitializer() : new HttpCredentialsAdapter(credential));
        initBuilder.add((Object)new LatencyRecordingHttpRequestInitializer(API_METRIC_LABEL));
        initBuilder.add((Object)httpRequestInitializer);
        ChainingHttpRequestInitializer chainInitializer = new ChainingHttpRequestInitializer((HttpRequestInitializer[])Iterables.toArray((Iterable)initBuilder.build(), HttpRequestInitializer.class));
        return new Bigquery.Builder(Transport.getTransport(), Transport.getJsonFactory(), (HttpRequestInitializer)chainInitializer).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    private static BigQueryWriteClient newBigQueryWriteClient(BigQueryOptions options) {
        try {
            return BigQueryWriteClient.create((BigQueryWriteSettings)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider(() -> ((GcpOptions)options.as(GcpOptions.class)).getGcpCredential())).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CustomHttpErrors createBigQueryClientCustomErrors() {
        CustomHttpErrors.Builder builder = new CustomHttpErrors.Builder();
        builder.addErrorForCodeAndUrlContains(403, "/tables?", "The GCP project is most likely exceeding the rate limit on bigquery.tables.list, please find the instructions to increase this limit at: https://cloud.google.com/service-infrastructure/docs/rate-limiting#configure");
        return builder.build();
    }

    private static class BoundedExecutorService {
        private final ListeningExecutorService taskExecutor;
        private final ListeningExecutorService taskSubmitExecutor;
        private final Semaphore semaphore;

        BoundedExecutorService(ListeningExecutorService taskExecutor, int parallelism) {
            this.taskExecutor = taskExecutor;
            this.taskSubmitExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
            this.semaphore = new Semaphore(parallelism);
        }

        public <T> Future<T> submit(Callable<T> callable) {
            return Futures.submitAsync(() -> {
                this.semaphore.acquire();
                ListenableFuture listenableFuture = this.taskExecutor.submit(callable);
                listenableFuture.addListener(this.semaphore::release, MoreExecutors.directExecutor());
                return listenableFuture;
            }, (Executor)this.taskSubmitExecutor);
        }
    }

    static class StorageClientImpl
    implements BigQueryServices.StorageClient {
        private static final HeaderProvider USER_AGENT_HEADER_PROVIDER = FixedHeaderProvider.create((String[])new String[]{"user-agent", "Apache_Beam_Java/" + ReleaseInfo.getReleaseInfo().getVersion()});
        private final BigQueryReadClient client;

        private StorageClientImpl(BigQueryOptions options) throws IOException {
            BigQueryReadSettings.Builder settingsBuilder = ((BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)options.getGcpCredential()))).setTransportChannelProvider((TransportChannelProvider)BigQueryReadSettings.defaultGrpcTransportProviderBuilder().setHeaderProvider(USER_AGENT_HEADER_PROVIDER).build())).setReadRowsRetryAttemptListener((BigQueryReadSettings.RetryAttemptListener)new RetryAttemptCounter());
            UnaryCallSettings.Builder createReadSessionSettings = settingsBuilder.getStubSettingsBuilder().createReadSessionSettings();
            createReadSessionSettings.setRetrySettings(createReadSessionSettings.getRetrySettings().toBuilder().setInitialRpcTimeout(org.threeten.bp.Duration.ofHours((long)2L)).setMaxRpcTimeout(org.threeten.bp.Duration.ofHours((long)2L)).setTotalTimeout(org.threeten.bp.Duration.ofHours((long)2L)).build());
            UnaryCallSettings.Builder splitReadStreamSettings = settingsBuilder.getStubSettingsBuilder().splitReadStreamSettings();
            splitReadStreamSettings.setRetrySettings(splitReadStreamSettings.getRetrySettings().toBuilder().setInitialRpcTimeout(org.threeten.bp.Duration.ofSeconds((long)30L)).setMaxRpcTimeout(org.threeten.bp.Duration.ofSeconds((long)30L)).setTotalTimeout(org.threeten.bp.Duration.ofSeconds((long)30L)).build());
            this.client = BigQueryReadClient.create((BigQueryReadSettings)settingsBuilder.build());
        }

        ReadSession callCreateReadSession(CreateReadSessionRequest request) {
            return this.client.createReadSession(request);
        }

        @Override
        public ReadSession createReadSession(CreateReadSessionRequest request) {
            TableReference tableReference = BigQueryUtils.toTableReference(request.getReadSession().getTable());
            ServiceCallMetric serviceCallMetric = BigQueryUtils.readCallMetric(tableReference);
            try {
                ReadSession session = this.callCreateReadSession(request);
                if (serviceCallMetric != null) {
                    serviceCallMetric.call("ok");
                }
                return session;
            }
            catch (ApiException e) {
                if (serviceCallMetric != null) {
                    serviceCallMetric.call(e.getStatusCode().getCode().name());
                }
                throw e;
            }
        }

        @Override
        public BigQueryServices.BigQueryServerStream<ReadRowsResponse> readRows(ReadRowsRequest request) {
            return new BigQueryServerStreamImpl<ReadRowsResponse>(this.client.readRowsCallable().call((Object)request));
        }

        @Override
        public BigQueryServices.BigQueryServerStream<ReadRowsResponse> readRows(ReadRowsRequest request, String fullTableId) {
            TableReference tableReference = BigQueryUtils.toTableReference(fullTableId);
            ServiceCallMetric serviceCallMetric = BigQueryUtils.readCallMetric(tableReference);
            try {
                BigQueryServices.BigQueryServerStream<ReadRowsResponse> response = this.readRows(request);
                serviceCallMetric.call("ok");
                return response;
            }
            catch (ApiException e) {
                if (serviceCallMetric != null) {
                    serviceCallMetric.call(e.getStatusCode().getCode().name());
                }
                throw e;
            }
        }

        @Override
        public SplitReadStreamResponse splitReadStream(SplitReadStreamRequest request) {
            return this.client.splitReadStream(request);
        }

        @Override
        public SplitReadStreamResponse splitReadStream(SplitReadStreamRequest request, String fullTableId) {
            TableReference tableReference = BigQueryUtils.toTableReference(fullTableId);
            ServiceCallMetric serviceCallMetric = BigQueryUtils.readCallMetric(tableReference);
            try {
                SplitReadStreamResponse response = this.splitReadStream(request);
                if (serviceCallMetric != null) {
                    serviceCallMetric.call("ok");
                }
                return response;
            }
            catch (ApiException e) {
                if (serviceCallMetric != null) {
                    serviceCallMetric.call(e.getStatusCode().getCode().name());
                }
                throw e;
            }
        }

        @Override
        public void close() {
            this.client.close();
        }

        @VisibleForTesting
        public static class RetryAttemptCounter
        implements BigQueryReadSettings.RetryAttemptListener {
            public final Counter throttlingMsecs = Metrics.counter(StorageClientImpl.class, (String)"throttling-msecs");

            public void onRetryAttempt(Status status, Metadata metadata) {
                RetryInfo retryInfo;
                if (status != null && status.getCode() == Status.Code.RESOURCE_EXHAUSTED && metadata != null && metadata.containsKey(KEY_RETRY_INFO) && (retryInfo = (RetryInfo)metadata.get(KEY_RETRY_INFO)).hasRetryDelay()) {
                    long delay = retryInfo.getRetryDelay().getSeconds() * 1000L + (long)(retryInfo.getRetryDelay().getNanos() / 1000000);
                    this.throttlingMsecs.inc(delay);
                }
            }
        }
    }

    static class BigQueryServerStreamImpl<T>
    implements BigQueryServices.BigQueryServerStream<T> {
        private final ServerStream<T> serverStream;

        public BigQueryServerStreamImpl(ServerStream<T> serverStream) {
            this.serverStream = serverStream;
        }

        @Override
        public Iterator<T> iterator() {
            return this.serverStream.iterator();
        }

        @Override
        public void cancel() {
            this.serverStream.cancel();
        }
    }

    @VisibleForTesting
    static class DatasetServiceImpl
    implements BigQueryServices.DatasetService {
        private static final FluentBackoff INSERT_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)200L)).withMaxRetries(5);
        private static final FluentBackoff RATE_LIMIT_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(Duration.standardSeconds((long)1L)).withMaxRetries(13);
        private final ApiErrorExtractor errorExtractor;
        private final Bigquery client;
        private final @Nullable BigQueryWriteClient newWriteClient;
        private final PipelineOptions options;
        private final long maxRowsPerBatch;
        private final long maxRowBatchSize;
        private final Counter throttlingMsecs = Metrics.counter(DatasetServiceImpl.class, (String)"throttling-msecs");
        private @Nullable BoundedExecutorService executor;
        private final BigQueryIOMetadata bqIOMetadata;
        private static final int RETRY_CREATE_TABLE_DURATION_MILLIS = (int)TimeUnit.MINUTES.toMillis(5L);

        @VisibleForTesting
        DatasetServiceImpl(Bigquery client, @Nullable BigQueryWriteClient newWriteClient, PipelineOptions options) {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            this.errorExtractor = new ApiErrorExtractor();
            this.client = client;
            this.newWriteClient = newWriteClient;
            this.options = options;
            this.maxRowsPerBatch = bqOptions.getMaxStreamingRowsToBatch();
            this.maxRowBatchSize = bqOptions.getMaxStreamingBatchSize();
            this.bqIOMetadata = BigQueryIOMetadata.create();
            this.executor = null;
        }

        @VisibleForTesting
        DatasetServiceImpl(Bigquery client, BigQueryWriteClient newWriteClient, PipelineOptions options, long maxRowsPerBatch) {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            this.errorExtractor = new ApiErrorExtractor();
            this.client = client;
            this.newWriteClient = newWriteClient;
            this.options = options;
            this.maxRowsPerBatch = maxRowsPerBatch;
            this.maxRowBatchSize = bqOptions.getMaxStreamingBatchSize();
            this.bqIOMetadata = BigQueryIOMetadata.create();
            this.executor = null;
        }

        private DatasetServiceImpl(BigQueryOptions bqOptions) {
            this.errorExtractor = new ApiErrorExtractor();
            this.client = BigQueryServicesImpl.newBigQueryClient(bqOptions).build();
            this.newWriteClient = BigQueryServicesImpl.newBigQueryWriteClient(bqOptions);
            this.options = bqOptions;
            this.maxRowsPerBatch = bqOptions.getMaxStreamingRowsToBatch();
            this.maxRowBatchSize = bqOptions.getMaxStreamingBatchSize();
            this.bqIOMetadata = BigQueryIOMetadata.create();
            this.executor = null;
        }

        @Override
        public @Nullable Table getTable(TableReference tableRef) throws IOException, InterruptedException {
            return this.getTable(tableRef, Collections.emptyList());
        }

        @Override
        public @Nullable Table getTable(TableReference tableRef, List<String> selectedFields) throws IOException, InterruptedException {
            return this.getTable(tableRef, selectedFields, BigQueryServices.DatasetService.TableMetadataView.STORAGE_STATS);
        }

        @Override
        public @Nullable Table getTable(TableReference tableRef, List<String> selectedFields, BigQueryServices.DatasetService.TableMetadataView view) throws IOException, InterruptedException {
            return this.getTable(tableRef, selectedFields, view, BigQueryServicesImpl.createDefaultBackoff(), Sleeper.DEFAULT);
        }

        @VisibleForTesting
        @Nullable Table getTable(TableReference ref, List<String> selectedFields, BigQueryServices.DatasetService.TableMetadataView view, BackOff backoff, Sleeper sleeper) throws IOException, InterruptedException {
            Bigquery.Tables.Get get = this.client.tables().get(ref.getProjectId(), ref.getDatasetId(), ref.getTableId()).setPrettyPrint(Boolean.valueOf(false));
            if (!selectedFields.isEmpty()) {
                get.setSelectedFields(String.join((CharSequence)",", selectedFields));
            }
            if (view != null) {
                get.set("view", (Object)view.name());
            }
            try {
                return (Table)BigQueryServicesImpl.executeWithRetries(get, String.format("Unable to get table: %s, aborting after %d retries.", ref.getTableId(), 9), sleeper, backoff, DONT_RETRY_NOT_FOUND);
            }
            catch (IOException e) {
                if (this.errorExtractor.itemNotFound(e)) {
                    return null;
                }
                throw e;
            }
        }

        @Override
        public void createTable(Table table) throws InterruptedException, IOException {
            LOG.info("Trying to create BigQuery table: {}", (Object)BigQueryHelpers.toTableSpec(table.getTableReference()));
            ExponentialBackOff backoff = new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(RETRY_CREATE_TABLE_DURATION_MILLIS).build();
            this.tryCreateTable(table, (BackOff)backoff, Sleeper.DEFAULT);
        }

        @VisibleForTesting
        @Nullable Table tryCreateTable(Table table, BackOff backoff, Sleeper sleeper) throws IOException {
            boolean retry = false;
            while (true) {
                try {
                    return (Table)this.client.tables().insert(table.getTableReference().getProjectId(), table.getTableReference().getDatasetId(), table).setPrettyPrint(Boolean.valueOf(false)).execute();
                }
                catch (IOException e) {
                    block8: {
                        ApiErrorExtractor extractor = new ApiErrorExtractor();
                        if (extractor.itemAlreadyExists(e)) {
                            return null;
                        }
                        if (extractor.rateLimited(e)) {
                            try {
                                if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) {
                                    if (retry) continue;
                                    LOG.info("Quota limit reached when creating table {}:{}.{}, retrying up to {} minutes", new Object[]{table.getTableReference().getProjectId(), table.getTableReference().getDatasetId(), table.getTableReference().getTableId(), TimeUnit.MILLISECONDS.toMinutes(RETRY_CREATE_TABLE_DURATION_MILLIS)});
                                    retry = true;
                                    continue;
                                }
                                break block8;
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                                throw e;
                            }
                            continue;
                        }
                    }
                    throw e;
                }
                break;
            }
        }

        @Override
        public void deleteTable(TableReference tableRef) throws IOException, InterruptedException {
            BigQueryServicesImpl.executeWithRetries(this.client.tables().delete(tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId()), String.format("Unable to delete table: %s, aborting after %d retries.", tableRef.getTableId(), 9), Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff(), ALWAYS_RETRY);
        }

        @Override
        public boolean isTableEmpty(TableReference tableRef) throws IOException, InterruptedException {
            return this.isTableEmpty(tableRef, BigQueryServicesImpl.createDefaultBackoff(), Sleeper.DEFAULT);
        }

        @VisibleForTesting
        boolean isTableEmpty(TableReference tableRef, BackOff backoff, Sleeper sleeper) throws IOException, InterruptedException {
            QueryResponse response = (QueryResponse)BigQueryServicesImpl.executeWithRetries(this.client.jobs().query(tableRef.getProjectId(), new QueryRequest().setQuery("SELECT false FROM (SELECT AS STRUCT * FROM `" + tableRef.getDatasetId() + "`.`" + tableRef.getTableId() + "` LIMIT 1) AS i WHERE i IS NOT NULL").setUseLegacySql(Boolean.valueOf(false))).setPrettyPrint(Boolean.valueOf(false)), String.format("Unable to list table data: %s, aborting after %d retries.", tableRef.getTableId(), 9), sleeper, backoff, DONT_RETRY_NOT_FOUND);
            return response.getRows() == null || response.getRows().isEmpty();
        }

        @Override
        public Dataset getDataset(String projectId, String datasetId) throws IOException, InterruptedException {
            return (Dataset)BigQueryServicesImpl.executeWithRetries(this.client.datasets().get(projectId, datasetId).setPrettyPrint(Boolean.valueOf(false)), String.format("Unable to get dataset: %s, aborting after %d retries.", datasetId, 9), Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff(), DONT_RETRY_NOT_FOUND);
        }

        @Override
        public void createDataset(String projectId, String datasetId, @Nullable String location, @Nullable String description, @Nullable Long defaultTableExpirationMs) throws IOException, InterruptedException {
            this.createDataset(projectId, datasetId, location, description, defaultTableExpirationMs, Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff());
        }

        private void createDataset(String projectId, String datasetId, @Nullable String location, @Nullable String description, @Nullable Long defaultTableExpirationMs, Sleeper sleeper, BackOff backoff) throws IOException, InterruptedException {
            Throwable lastException;
            DatasetReference datasetRef = new DatasetReference().setProjectId(projectId).setDatasetId(datasetId);
            Dataset dataset = new Dataset().setDatasetReference(datasetRef);
            if (location != null) {
                dataset.setLocation(location);
            }
            if (description != null) {
                dataset.setFriendlyName(description);
                dataset.setDescription(description);
            }
            if (defaultTableExpirationMs != null) {
                dataset.setDefaultTableExpirationMs(defaultTableExpirationMs);
            }
            do {
                try {
                    this.client.datasets().insert(projectId, dataset).setPrettyPrint(Boolean.valueOf(false)).execute();
                    return;
                }
                catch (GoogleJsonResponseException e) {
                    if (this.errorExtractor.itemAlreadyExists((IOException)((Object)e))) {
                        return;
                    }
                    LOG.info("Ignore the error and retry creating the dataset.", (Throwable)e);
                    lastException = e;
                }
                catch (IOException e) {
                    LOG.info("Ignore the error and retry creating the dataset.", (Throwable)e);
                    lastException = e;
                }
            } while (BigQueryServicesImpl.nextBackOff(sleeper, backoff));
            throw new IOException(String.format("Unable to create dataset: %s, aborting after %d .", datasetId, 9), lastException);
        }

        @Override
        public void deleteDataset(String projectId, String datasetId) throws IOException, InterruptedException {
            BigQueryServicesImpl.executeWithRetries(this.client.datasets().delete(projectId, datasetId), String.format("Unable to delete table: %s, aborting after %d retries.", datasetId, 9), Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff(), ALWAYS_RETRY);
        }

        @VisibleForTesting
        <T> long insertAll(TableReference ref, List<FailsafeValueInSingleWindow<TableRow, TableRow>> rowList, @Nullable List<String> insertIdList, BackOff backoff, FluentBackoff rateLimitBackoffFactory, Sleeper sleeper, InsertRetryPolicy retryPolicy, List<ValueInSingleWindow<T>> failedInserts, ErrorContainer<T> errorContainer, boolean skipInvalidRows, boolean ignoreUnkownValues, boolean ignoreInsertIds, List<ValueInSingleWindow<TableRow>> successfulRows) throws IOException, InterruptedException {
            Preconditions.checkNotNull((Object)ref, (Object)"ref");
            if (this.executor == null) {
                this.executor = new BoundedExecutorService(MoreExecutors.listeningDecorator((ExecutorService)((GcsOptions)this.options.as(GcsOptions.class)).getExecutorService()), ((BigQueryOptions)this.options.as(BigQueryOptions.class)).getInsertBundleParallelism());
            }
            if (insertIdList != null && rowList.size() != insertIdList.size()) {
                throw new AssertionError((Object)"If insertIdList is not null it needs to have at least as many elements as rowList");
            }
            HashSet<Integer> failedIndices = new HashSet<Integer>();
            long retTotalDataSize = 0L;
            ArrayList<TableDataInsertAllResponse.InsertErrors> allErrors = new ArrayList<TableDataInsertAllResponse.InsertErrors>();
            List<FailsafeValueInSingleWindow<TableRow, TableRow>> rowsToPublish = rowList;
            List<String> idsToPublish = null;
            if (!ignoreInsertIds) {
                idsToPublish = insertIdList;
            }
            while (true) {
                long nextBackoffMillis;
                ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>> retryRows = new ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>>();
                ArrayList<String> retryIds = idsToPublish != null ? new ArrayList<String>() : null;
                int strideIndex = 0;
                ArrayList<Object> rows = new ArrayList<TableDataInsertAllRequest.Rows>();
                long dataSize = 0L;
                ArrayList<Future<List<TableDataInsertAllResponse.InsertErrors>>> futures = new ArrayList<Future<List<TableDataInsertAllResponse.InsertErrors>>>();
                ArrayList<Integer> strideIndices = new ArrayList<Integer>();
                AtomicLong maxThrottlingMsec = new AtomicLong();
                int rowIndex = 0;
                while (rowIndex < rowsToPublish.size()) {
                    TableRow row = (TableRow)rowsToPublish.get(rowIndex).getValue();
                    long nextRowSize = 0L;
                    try {
                        nextRowSize = TableRowJsonCoder.of().getEncodedElementByteSize(row);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Failed to convert the row to JSON", ex);
                    }
                    if (nextRowSize >= (long)MAX_BQ_ROW_PAYLOAD.intValue()) {
                        TableDataInsertAllResponse.InsertErrors error = new TableDataInsertAllResponse.InsertErrors().setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("row-too-large")));
                        Boolean isRetry = retryPolicy.shouldRetry(new InsertRetryPolicy.Context(error));
                        if (isRetry.booleanValue()) {
                            throw new RuntimeException(String.format("We have observed a row that is %s bytes in size. BigQuery supports request sizes up to 10MB, and this row is too large.  You may change your retry strategy to unblock this pipeline, and  the row will be output as a failed insert.", nextRowSize));
                        }
                        errorContainer.add(failedInserts, error, ref, rowsToPublish.get(rowIndex));
                        failedIndices.add(rowIndex);
                        ++rowIndex;
                        continue;
                    }
                    if (dataSize + nextRowSize >= (long)MAX_BQ_ROW_PAYLOAD.intValue() || dataSize >= this.maxRowBatchSize || (long)(rows.size() + 1) > this.maxRowsPerBatch) {
                        futures.add(this.executor.submit(new InsertBatchofRowsCallable(ref, skipInvalidRows, ignoreUnkownValues, this.client, rateLimitBackoffFactory, rows, maxThrottlingMsec, sleeper)));
                        strideIndices.add(strideIndex);
                        retTotalDataSize += dataSize;
                        strideIndex = rowIndex;
                        rows = new ArrayList();
                        dataSize = 0L;
                    }
                    TableDataInsertAllRequest.Rows out = new TableDataInsertAllRequest.Rows();
                    if (idsToPublish != null) {
                        out.setInsertId(idsToPublish.get(rowIndex));
                    }
                    out.setJson(row.getUnknownKeys());
                    rows.add(out);
                    ++rowIndex;
                    dataSize += nextRowSize;
                }
                if (rows.size() > 0) {
                    futures.add(this.executor.submit(new InsertBatchofRowsCallable(ref, skipInvalidRows, ignoreUnkownValues, this.client, rateLimitBackoffFactory, rows, maxThrottlingMsec, sleeper)));
                    strideIndices.add(strideIndex);
                    retTotalDataSize += dataSize;
                }
                try {
                    for (int i = 0; i < futures.size(); ++i) {
                        List errors = (List)((Future)futures.get(i)).get();
                        if (errors == null) continue;
                        for (TableDataInsertAllResponse.InsertErrors error : errors) {
                            if (error.getIndex() == null) {
                                throw new IOException("Insert failed: " + error + ", other errors: " + allErrors);
                            }
                            int errorIndex = error.getIndex().intValue() + (Integer)strideIndices.get(i);
                            failedIndices.add(errorIndex);
                            if (retryPolicy.shouldRetry(new InsertRetryPolicy.Context(error))) {
                                allErrors.add(error);
                                retryRows.add(rowsToPublish.get(errorIndex));
                                if (retryIds == null) continue;
                                retryIds.add(idsToPublish.get(errorIndex));
                                continue;
                            }
                            errorContainer.add(failedInserts, error, ref, rowsToPublish.get(errorIndex));
                        }
                    }
                    this.throttlingMsecs.inc(maxThrottlingMsec.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while inserting " + rowsToPublish);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
                if (allErrors.isEmpty() || (nextBackoffMillis = backoff.nextBackOffMillis()) == -1L) break;
                try {
                    sleeper.sleep(nextBackoffMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while waiting before retrying insert of " + retryRows);
                }
                rowsToPublish = retryRows;
                idsToPublish = retryIds;
                allErrors.clear();
                LOG.info("Retrying {} failed inserts to BigQuery", (Object)rowsToPublish.size());
            }
            if (successfulRows != null) {
                for (int i = 0; i < rowsToPublish.size(); ++i) {
                    if (failedIndices.contains(i)) continue;
                    successfulRows.add((ValueInSingleWindow<TableRow>)ValueInSingleWindow.of((Object)((TableRow)rowsToPublish.get(i).getValue()), (Instant)rowsToPublish.get(i).getTimestamp(), (BoundedWindow)rowsToPublish.get(i).getWindow(), (PaneInfo)rowsToPublish.get(i).getPane()));
                }
            }
            if (!allErrors.isEmpty()) {
                throw new IOException("Insert failed: " + allErrors);
            }
            return retTotalDataSize;
        }

        @Override
        public <T> long insertAll(TableReference ref, List<FailsafeValueInSingleWindow<TableRow, TableRow>> rowList, @Nullable List<String> insertIdList, InsertRetryPolicy retryPolicy, List<ValueInSingleWindow<T>> failedInserts, ErrorContainer<T> errorContainer, boolean skipInvalidRows, boolean ignoreUnknownValues, boolean ignoreInsertIds, List<ValueInSingleWindow<TableRow>> successfulRows) throws IOException, InterruptedException {
            return this.insertAll(ref, rowList, insertIdList, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)INSERT_BACKOFF_FACTORY.backoff()), RATE_LIMIT_BACKOFF_FACTORY, Sleeper.DEFAULT, retryPolicy, failedInserts, errorContainer, skipInvalidRows, ignoreUnknownValues, ignoreInsertIds, successfulRows);
        }

        protected static // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable GoogleJsonError.ErrorInfo getErrorInfo(IOException e) {
            if (!(e instanceof GoogleJsonResponseException)) {
                return null;
            }
            return Optional.ofNullable(((GoogleJsonResponseException)((Object)e)).getDetails()).flatMap(error -> Optional.ofNullable(error.getErrors())).flatMap(infos -> Optional.ofNullable((GoogleJsonError.ErrorInfo)Iterables.getFirst((Iterable)infos, null))).orElse(null);
        }

        @Override
        public Table patchTableDescription(TableReference tableReference, @Nullable String tableDescription) throws IOException, InterruptedException {
            Table table = new Table();
            table.setDescription(tableDescription);
            return (Table)BigQueryServicesImpl.executeWithRetries(this.client.tables().patch(tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId(), table).setPrettyPrint(Boolean.valueOf(false)), String.format("Unable to patch table description: %s, aborting after %d retries.", tableReference, 9), Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff(), ALWAYS_RETRY);
        }

        @Override
        public WriteStream createWriteStream(String tableUrn, WriteStream.Type type) throws IOException {
            return this.newWriteClient.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableUrn).setWriteStream(WriteStream.newBuilder().setType(type).build()).build());
        }

        @Override
        public BigQueryServices.StreamAppendClient getStreamAppendClient(String streamName, Descriptors.Descriptor descriptor) throws Exception {
            ProtoSchema protoSchema = ProtoSchema.newBuilder().setProtoDescriptor(descriptor.toProto()).build();
            InstantiatingGrpcChannelProvider transportChannelProvider = BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setKeepAliveTime(org.threeten.bp.Duration.ofMinutes((long)1L)).setKeepAliveTimeout(org.threeten.bp.Duration.ofMinutes((long)1L)).setKeepAliveWithoutCalls(Boolean.valueOf(true)).setChannelsPerCpu(2.0).build();
            final StreamWriter streamWriter = StreamWriter.newBuilder((String)streamName).setWriterSchema(protoSchema).setChannelProvider((TransportChannelProvider)transportChannelProvider).setTraceId("Dataflow:" + (this.bqIOMetadata.getBeamJobId() != null ? this.bqIOMetadata.getBeamJobId() : this.options.getJobName())).build();
            return new BigQueryServices.StreamAppendClient(){
                private int pins = 0;
                private boolean closed = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws Exception {
                    boolean closeWriter;
                    1 var2_1 = this;
                    synchronized (var2_1) {
                        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
                        this.closed = true;
                        closeWriter = this.pins == 0;
                    }
                    if (closeWriter) {
                        streamWriter.close();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void pin() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
                        ++this.pins;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void unpin() throws Exception {
                    boolean closeWriter;
                    1 var2_1 = this;
                    synchronized (var2_1) {
                        Preconditions.checkState((this.pins > 0 ? 1 : 0) != 0);
                        --this.pins;
                        closeWriter = this.pins == 0 && this.closed;
                    }
                    if (closeWriter) {
                        streamWriter.close();
                    }
                }

                @Override
                public ApiFuture<AppendRowsResponse> appendRows(long offset, ProtoRows rows) throws Exception {
                    return streamWriter.append(rows, offset);
                }

                @Override
                public long getInflightWaitSeconds() {
                    return streamWriter.getInflightWaitSeconds();
                }
            };
        }

        @Override
        public ApiFuture<FlushRowsResponse> flush(String streamName, long flushOffset) throws IOException, InterruptedException {
            Int64Value offset = Int64Value.newBuilder().setValue(flushOffset).build();
            FlushRowsRequest request = FlushRowsRequest.newBuilder().setWriteStream(streamName).setOffset(offset).build();
            return this.newWriteClient.flushRowsCallable().futureCall((Object)request);
        }

        @Override
        public ApiFuture<FinalizeWriteStreamResponse> finalizeWriteStream(String streamName) {
            return this.newWriteClient.finalizeWriteStreamCallable().futureCall((Object)FinalizeWriteStreamRequest.newBuilder().setName(streamName).build());
        }

        @Override
        public ApiFuture<BatchCommitWriteStreamsResponse> commitWriteStreams(String tableUrn, Iterable<String> writeStreamNames) {
            return this.newWriteClient.batchCommitWriteStreamsCallable().futureCall((Object)BatchCommitWriteStreamsRequest.newBuilder().setParent(tableUrn).addAllWriteStreams(writeStreamNames).build());
        }

        @Override
        public void close() throws Exception {
            this.newWriteClient.shutdownNow();
            this.newWriteClient.awaitTermination(60L, TimeUnit.SECONDS);
            this.newWriteClient.close();
        }

        static class InsertBatchofRowsCallable
        implements Callable<List<TableDataInsertAllResponse.InsertErrors>> {
            private final TableReference ref;
            private final Boolean skipInvalidRows;
            private final Boolean ignoreUnkownValues;
            private final Bigquery client;
            private final FluentBackoff rateLimitBackoffFactory;
            private final List<TableDataInsertAllRequest.Rows> rows;
            private final AtomicLong maxThrottlingMsec;
            private final Sleeper sleeper;

            InsertBatchofRowsCallable(TableReference ref, Boolean skipInvalidRows, Boolean ignoreUnknownValues, Bigquery client, FluentBackoff rateLimitBackoffFactory, List<TableDataInsertAllRequest.Rows> rows, AtomicLong maxThrottlingMsec, Sleeper sleeper) {
                this.ref = ref;
                this.skipInvalidRows = skipInvalidRows;
                this.ignoreUnkownValues = ignoreUnknownValues;
                this.client = client;
                this.rateLimitBackoffFactory = rateLimitBackoffFactory;
                this.rows = rows;
                this.maxThrottlingMsec = maxThrottlingMsec;
                this.sleeper = sleeper;
            }

            @Override
            public List<TableDataInsertAllResponse.InsertErrors> call() throws Exception {
                TableDataInsertAllRequest content = new TableDataInsertAllRequest();
                content.setRows(this.rows);
                content.setSkipInvalidRows(this.skipInvalidRows);
                content.setIgnoreUnknownValues(this.ignoreUnkownValues);
                Bigquery.Tabledata.InsertAll insert = this.client.tabledata().insertAll(this.ref.getProjectId(), this.ref.getDatasetId(), this.ref.getTableId(), content).setPrettyPrint(Boolean.valueOf(false));
                BackOff backoff1 = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)this.rateLimitBackoffFactory.backoff());
                long totalBackoffMillis = 0L;
                while (true) {
                    ServiceCallMetric serviceCallMetric = BigQueryUtils.writeCallMetric(this.ref);
                    try {
                        List response = ((TableDataInsertAllResponse)insert.execute()).getInsertErrors();
                        if (response == null || response.isEmpty()) {
                            serviceCallMetric.call("ok");
                        } else {
                            for (TableDataInsertAllResponse.InsertErrors insertErrors : response) {
                                for (ErrorProto insertError : insertErrors.getErrors()) {
                                    serviceCallMetric.call(insertError.getReason());
                                }
                            }
                        }
                        return response;
                    }
                    catch (IOException e) {
                        GoogleJsonError.ErrorInfo errorInfo = DatasetServiceImpl.getErrorInfo(e);
                        if (errorInfo == null) {
                            serviceCallMetric.call("unknown");
                            throw e;
                        }
                        serviceCallMetric.call(errorInfo.getReason());
                        if (!ApiErrorExtractor.INSTANCE.rateLimited(e) && !errorInfo.getReason().equals(BigQueryServicesImpl.QUOTA_EXCEEDED)) {
                            if (ApiErrorExtractor.INSTANCE.badRequest(e) && e.getMessage().contains(BigQueryServicesImpl.NO_ROWS_PRESENT)) {
                                LOG.error("No rows present in the request error likely caused by BigQuery Insert timing out. Update BigQueryOptions.setHTTPWriteTimeout to be longer, or 0 to disable timeouts", e.getCause());
                            }
                            throw e;
                        }
                        LOG.info(String.format("BigQuery insertAll error, retrying: %s", ApiErrorExtractor.INSTANCE.getErrorMessage(e)));
                        try {
                            long nextBackOffMillis = backoff1.nextBackOffMillis();
                            if (nextBackOffMillis == -1L) {
                                throw e;
                            }
                            this.sleeper.sleep(nextBackOffMillis);
                            long totalBackoffMillisSoFar = totalBackoffMillis += nextBackOffMillis;
                            this.maxThrottlingMsec.getAndUpdate(current -> Math.max(current, totalBackoffMillisSoFar));
                        }
                        catch (InterruptedException interrupted) {
                            throw new IOException("Interrupted while waiting before retrying insertAll");
                        }
                    }
                }
            }
        }
    }

    @VisibleForTesting
    static class JobServiceImpl
    implements BigQueryServices.JobService {
        private final ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
        private final Bigquery client;
        private final BigQueryIOMetadata bqIOMetadata;

        @VisibleForTesting
        JobServiceImpl(Bigquery client) {
            this.client = client;
            this.bqIOMetadata = BigQueryIOMetadata.create();
        }

        private JobServiceImpl(BigQueryOptions options) {
            this.client = BigQueryServicesImpl.newBigQueryClient(options).build();
            this.bqIOMetadata = BigQueryIOMetadata.create();
        }

        @Override
        public void startLoadJob(JobReference jobRef, JobConfigurationLoad loadConfig) throws InterruptedException, IOException {
            HashMap<String, String> labelMap = new HashMap<String, String>();
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setLoad(loadConfig).setLabels(this.bqIOMetadata.addAdditionalJobLabels(labelMap)));
            JobServiceImpl.startJob(job, this.errorExtractor, this.client);
        }

        @Override
        public void startLoadJob(JobReference jobRef, JobConfigurationLoad loadConfig, AbstractInputStreamContent stream) throws InterruptedException, IOException {
            HashMap<String, String> labelMap = new HashMap<String, String>();
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setLoad(loadConfig).setLabels(this.bqIOMetadata.addAdditionalJobLabels(labelMap)));
            JobServiceImpl.startJobStream(job, stream, this.errorExtractor, this.client, Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff());
        }

        @Override
        public void startExtractJob(JobReference jobRef, JobConfigurationExtract extractConfig) throws InterruptedException, IOException {
            HashMap<String, String> labelMap = new HashMap<String, String>();
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setExtract(extractConfig).setLabels(this.bqIOMetadata.addAdditionalJobLabels(labelMap)));
            JobServiceImpl.startJob(job, this.errorExtractor, this.client);
        }

        @Override
        public void startQueryJob(JobReference jobRef, JobConfigurationQuery queryConfig) throws IOException, InterruptedException {
            HashMap<String, String> labelMap = new HashMap<String, String>();
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setQuery(queryConfig).setLabels(this.bqIOMetadata.addAdditionalJobLabels(labelMap)));
            JobServiceImpl.startJob(job, this.errorExtractor, this.client);
        }

        @Override
        public void startCopyJob(JobReference jobRef, JobConfigurationTableCopy copyConfig) throws IOException, InterruptedException {
            HashMap<String, String> labelMap = new HashMap<String, String>();
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setCopy(copyConfig).setLabels(this.bqIOMetadata.addAdditionalJobLabels(labelMap)));
            JobServiceImpl.startJob(job, this.errorExtractor, this.client);
        }

        private static void startJob(Job job, ApiErrorExtractor errorExtractor, Bigquery client) throws IOException, InterruptedException {
            JobServiceImpl.startJob(job, errorExtractor, client, Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff());
        }

        @VisibleForTesting
        static void startJob(Job job, ApiErrorExtractor errorExtractor, Bigquery client, Sleeper sleeper, BackOff backoff) throws IOException, InterruptedException {
            JobReference jobRef = job.getJobReference();
            while (true) {
                try {
                    client.jobs().insert(jobRef.getProjectId(), job).setPrettyPrint(Boolean.valueOf(false)).execute();
                    LOG.info("Started BigQuery job: {}.\n{}", (Object)jobRef, (Object)JobServiceImpl.formatBqStatusCommand(jobRef.getProjectId(), jobRef.getJobId()));
                    return;
                }
                catch (IOException e) {
                    if (errorExtractor.itemAlreadyExists(e)) {
                        LOG.info("BigQuery job " + jobRef + " already exists, will not retry inserting it:", (Throwable)e);
                        return;
                    }
                    LOG.info("Failed to insert job " + jobRef + ", will retry:", (Throwable)e);
                    IOException lastException = e;
                    if (BigQueryServicesImpl.nextBackOff(sleeper, backoff)) continue;
                    throw new IOException(String.format("Unable to insert job: %s, aborting after %d .", jobRef.getJobId(), 9), lastException);
                }
                break;
            }
        }

        static void startJobStream(Job job, AbstractInputStreamContent streamContent, ApiErrorExtractor errorExtractor, Bigquery client, Sleeper sleeper, BackOff backOff) throws IOException, InterruptedException {
            JobReference jobReference = job.getJobReference();
            while (true) {
                try {
                    client.jobs().insert(jobReference.getProjectId(), job, streamContent).setPrettyPrint(Boolean.valueOf(false)).execute();
                    LOG.info("Started BigQuery job: {}.\n{}", (Object)jobReference, (Object)JobServiceImpl.formatBqStatusCommand(jobReference.getProjectId(), jobReference.getJobId()));
                    return;
                }
                catch (IOException e) {
                    if (errorExtractor.itemAlreadyExists(e)) {
                        LOG.info("BigQuery job " + jobReference + " already exists, will not retry inserting it:", (Throwable)e);
                        return;
                    }
                    LOG.info("Failed to insert job " + jobReference + ", will retry:", (Throwable)e);
                    IOException exception = e;
                    if (BigQueryServicesImpl.nextBackOff(sleeper, backOff)) continue;
                    throw new IOException(String.format("Unable to insert job: %s, aborting after %d .", jobReference.getJobId(), 9), exception);
                }
                break;
            }
        }

        @Override
        public Job pollJob(JobReference jobRef, int maxAttempts) throws InterruptedException {
            BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.withMaxRetries(maxAttempts).withInitialBackoff(INITIAL_JOB_STATUS_POLL_BACKOFF).withMaxBackoff(Duration.standardMinutes((long)1L)).backoff());
            return this.pollJob(jobRef, Sleeper.DEFAULT, backoff);
        }

        @VisibleForTesting
        @Nullable Job pollJob(JobReference jobRef, Sleeper sleeper, BackOff backoff) throws InterruptedException {
            do {
                try {
                    Job job = (Job)this.client.jobs().get(jobRef.getProjectId(), jobRef.getJobId()).setLocation(jobRef.getLocation()).setPrettyPrint(Boolean.valueOf(false)).execute();
                    if (job == null) {
                        LOG.info("Still waiting for BigQuery job {} to start", (Object)jobRef);
                        continue;
                    }
                    JobStatus status = job.getStatus();
                    if (status == null) {
                        LOG.info("Still waiting for BigQuery job {} to enter pending state", (Object)jobRef);
                        continue;
                    }
                    if ("DONE".equals(status.getState())) {
                        LOG.info("BigQuery job {} completed in state DONE", (Object)jobRef);
                        return job;
                    }
                    LOG.info("Still waiting for BigQuery job {}, currently in status {}\n{}", new Object[]{jobRef.getJobId(), status, JobServiceImpl.formatBqStatusCommand(jobRef.getProjectId(), jobRef.getJobId())});
                }
                catch (IOException e) {
                    LOG.info("Ignore the error and retry polling job status.", (Throwable)e);
                }
            } while (BigQueryServicesImpl.nextBackOff(sleeper, backoff));
            LOG.warn("Unable to poll job status: {}, aborting after reached max .", (Object)jobRef.getJobId());
            return null;
        }

        private static String formatBqStatusCommand(String projectId, String jobId) {
            return String.format("bq show -j --format=prettyjson --project_id=%s %s", projectId, jobId);
        }

        @Override
        public JobStatistics dryRunQuery(String projectId, JobConfigurationQuery queryConfig, @Nullable String location) throws InterruptedException, IOException {
            JobReference jobRef = new JobReference().setLocation(location).setProjectId(projectId);
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setQuery(queryConfig).setDryRun(Boolean.valueOf(true)));
            return ((Job)BigQueryServicesImpl.executeWithRetries(this.client.jobs().insert(projectId, job).setPrettyPrint(Boolean.valueOf(false)), String.format("Unable to dry run query: %s, aborting after %d retries.", queryConfig, 9), Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff(), ALWAYS_RETRY)).getStatistics();
        }

        @Override
        public Job getJob(JobReference jobRef) throws IOException, InterruptedException {
            return this.getJob(jobRef, Sleeper.DEFAULT, BigQueryServicesImpl.createDefaultBackoff());
        }

        @VisibleForTesting
        public @Nullable Job getJob(JobReference jobRef, Sleeper sleeper, BackOff backoff) throws IOException, InterruptedException {
            Throwable lastException;
            String jobId = jobRef.getJobId();
            do {
                try {
                    return (Job)this.client.jobs().get(jobRef.getProjectId(), jobId).setLocation(jobRef.getLocation()).setPrettyPrint(Boolean.valueOf(false)).execute();
                }
                catch (GoogleJsonResponseException e) {
                    if (this.errorExtractor.itemNotFound((IOException)((Object)e))) {
                        LOG.info("No BigQuery job with job id {} found in location {}.", (Object)jobId, (Object)jobRef.getLocation());
                        return null;
                    }
                    LOG.info("Ignoring the error encountered while trying to query the BigQuery job {}", (Object)jobId, (Object)e);
                    lastException = e;
                }
                catch (IOException e) {
                    LOG.info("Ignoring the error encountered while trying to query the BigQuery job {}", (Object)jobId, (Object)e);
                    lastException = e;
                }
            } while (BigQueryServicesImpl.nextBackOff(sleeper, backoff));
            throw new IOException(String.format("Unable to find BigQuery job: %s, aborting after %d retries.", jobRef, 9), lastException);
        }

        @Override
        public void close() throws Exception {
        }
    }
}

