/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.util.HashSet;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

class TransientBlobCleanupTask
extends TimerTask {
    private final Logger log;
    private final BiConsumer<JobID, TransientBlobKey> cleanupCallback;
    private ConcurrentMap<Tuple2<JobID, TransientBlobKey>, Long> blobExpiryTimes;

    TransientBlobCleanupTask(ConcurrentMap<Tuple2<JobID, TransientBlobKey>, Long> blobExpiryTimes, BiConsumer<JobID, TransientBlobKey> cleanupCallback, Logger log) {
        this.blobExpiryTimes = (ConcurrentMap)Preconditions.checkNotNull(blobExpiryTimes);
        this.cleanupCallback = (BiConsumer)Preconditions.checkNotNull(cleanupCallback);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
    }

    @Override
    public void run() {
        long currentTimeMillis = System.currentTimeMillis();
        HashSet entries = new HashSet(this.blobExpiryTimes.entrySet());
        for (Map.Entry entry : entries) {
            if (currentTimeMillis < (Long)entry.getValue()) continue;
            JobID jobId = (JobID)((Tuple2)entry.getKey()).f0;
            TransientBlobKey blobKey = (TransientBlobKey)((Tuple2)entry.getKey()).f1;
            this.cleanupCallback.accept(jobId, blobKey);
        }
    }
}

