/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.commitlog.CommitLogDescriptor;

public interface CommitLogReadHandler {
    public boolean shouldSkipSegmentOnError(CommitLogReadException var1) throws IOException;

    public void handleUnrecoverableError(CommitLogReadException var1) throws IOException;

    public void handleMutation(Mutation var1, int var2, int var3, CommitLogDescriptor var4);

    public static class CommitLogReadException
    extends IOException {
        public final CommitLogReadErrorReason reason;
        public final boolean permissible;

        CommitLogReadException(String message, CommitLogReadErrorReason reason, boolean permissible) {
            super(message);
            this.reason = reason;
            this.permissible = permissible;
        }
    }

    public static enum CommitLogReadErrorReason {
        RECOVERABLE_DESCRIPTOR_ERROR,
        UNRECOVERABLE_DESCRIPTOR_ERROR,
        MUTATION_ERROR,
        UNRECOVERABLE_UNKNOWN_ERROR,
        EOF;

    }
}

