/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.runners.core.construction.ReadTranslation;
import org.apache.beam.runners.core.serialization.Base64Serializer;
import org.apache.beam.runners.spark.structuredstreaming.translation.AbstractTranslationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.DatasetSourceBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.RowHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

class ReadSourceTranslatorBatch<T>
implements TransformTranslator<PTransform<PBegin, PCollection<T>>> {
    private static final String sourceProviderClass = DatasetSourceBatch.class.getCanonicalName();

    ReadSourceTranslatorBatch() {
    }

    @Override
    public void translateTransform(PTransform<PBegin, PCollection<T>> transform, AbstractTranslationContext context) {
        BoundedSource source;
        AppliedPTransform<?, ?, ?> rootTransform = context.getCurrentTransform();
        try {
            source = ReadTranslation.boundedSourceFromTransform(rootTransform);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SparkSession sparkSession = context.getSparkSession();
        String serializedSource = Base64Serializer.serializeUnchecked((Serializable)source);
        Dataset rowDataset = sparkSession.read().format(sourceProviderClass).option("beam-source", serializedSource).option("default-parallelism", String.valueOf(context.getSparkSession().sparkContext().defaultParallelism())).option("pipeline-options", context.getSerializableOptions().toString()).load();
        WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.FullWindowedValueCoder.of((Coder)source.getOutputCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
        Dataset dataset = rowDataset.map(RowHelpers.extractWindowedValueFromRowMapFunction(windowedValueCoder), EncoderHelpers.fromBeamCoder(windowedValueCoder));
        PCollection output = (PCollection)context.getOutput();
        context.putDataset((PValue)output, dataset);
    }
}

