/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup.readallcache;

import java.util.BitSet;
import java.util.Comparator;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.Index;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.SearchingContext;

class IsNullIndex
extends Index
implements Comparator<Index.IndexedValue> {
    private final boolean isMatchingNull;

    IsNullIndex(int column, IValueMeta valueMeta, int rowsAmount, boolean isMatchingNull) {
        super(column, valueMeta, rowsAmount);
        this.isMatchingNull = isMatchingNull;
    }

    @Override
    Comparator<Index.IndexedValue> createComparator() {
        return this;
    }

    @Override
    void doApply(SearchingContext context, IValueMeta lookupMeta, Object lookupValue) throws HopException {
        int artificialRow = this.isMatchingNull ? Integer.MAX_VALUE : -1;
        int afterLastValue = this.findInsertionPointOf(new Index.IndexedValue(null, artificialRow));
        if (afterLastValue == 0) {
            context.setEmpty();
        } else {
            int end;
            int start;
            int length = this.values.length;
            if (afterLastValue < length / 2) {
                start = 0;
                end = afterLastValue;
            } else {
                start = afterLastValue;
                end = length;
            }
            BitSet bitSet = context.getWorkingSet();
            for (int i = start; i < end; ++i) {
                bitSet.set(this.values[i].row, true);
            }
            context.intersect(bitSet, start != 0);
        }
    }

    @Override
    int getRestrictionPower() {
        return this.isMatchingNull ? -128 : 127;
    }

    @Override
    public int compare(Index.IndexedValue o1, Index.IndexedValue o2) {
        try {
            boolean null1 = this.valueMeta.isNull(o1.key);
            boolean null2 = this.valueMeta.isNull(o2.key);
            int c = null1 ? (null2 ? 0 : -1) : (null2 ? 1 : 0);
            if (c == 0) {
                return Integer.compare(o1.row, o2.row);
            }
            return this.isMatchingNull ? c : -c;
        }
        catch (HopException e) {
            throw new RuntimeException(e);
        }
    }
}

