/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hop.core.Condition;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.debug.transform.TransformDebugLevel;
import org.apache.hop.debug.util.DebugLevelUtil;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;

@ExtensionPoint(id="SetTransformDebugLevelExtensionPoint", description="Set Transform Debug Level Extension Point Plugin", extensionPointId="PipelineStartThreads")
public class SetTransformDebugLevelExtensionPoint
implements IExtensionPoint<IPipelineEngine<PipelineMeta>> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        Map transformLevelMap = (Map)pipeline.getPipelineMeta().getAttributesMap().get("debug_plugin");
        if (transformLevelMap != null) {
            log.logDetailed("Set debug level information on pipeline : " + pipeline.getPipelineMeta().getName());
            ArrayList<String> transformNames = new ArrayList<String>();
            for (String key : transformLevelMap.keySet()) {
                String transformName;
                int index = key.indexOf(" : ");
                if (index <= 0 || transformNames.contains(transformName = key.substring(0, index))) continue;
                transformNames.add(transformName);
            }
            for (String transformName : transformNames) {
                log.logDetailed("Handling debug level for transform : " + transformName);
                try {
                    final TransformDebugLevel debugLevel = DebugLevelUtil.getTransformDebugLevel(transformLevelMap, transformName);
                    if (debugLevel == null) continue;
                    log.logDetailed("Found debug level info for transform " + transformName);
                    List transformCopies = pipeline.getComponentCopies(transformName);
                    if (debugLevel.getStartRow() < 0 && debugLevel.getEndRow() < 0 && debugLevel.getCondition().isEmpty()) {
                        log.logDetailed("Set logging level for transform " + transformName + " to " + debugLevel.getLogLevel().getDescription());
                        for (final IEngineComponent transformCopy : transformCopies) {
                            LogLevel logLevel = debugLevel.getLogLevel();
                            transformCopy.getLogChannel().setLogLevel(logLevel);
                            log.logDetailed("Applied logging level " + logLevel.getDescription() + " on transform copy " + transformCopy.getName() + "." + transformCopy.getCopyNr());
                        }
                        continue;
                    }
                    for (final IEngineComponent transformCopy : transformCopies) {
                        final LogLevel baseLogLevel = transformCopy.getLogChannel().getLogLevel();
                        final AtomicLong rowCounter = new AtomicLong(0L);
                        transformCopy.addRowListener(new IRowListener(){

                            public void rowReadEvent(IRowMeta rowMeta, Object[] row) {
                                rowCounter.incrementAndGet();
                                boolean enabled = false;
                                Condition condition = debugLevel.getCondition();
                                if (debugLevel.getStartRow() > 0 && rowCounter.get() >= (long)debugLevel.getStartRow() && debugLevel.getEndRow() >= 0 && (long)debugLevel.getEndRow() >= rowCounter.get()) {
                                    enabled = true;
                                } else if (debugLevel.getStartRow() <= 0 && debugLevel.getEndRow() >= 0 && rowCounter.get() <= (long)debugLevel.getEndRow()) {
                                    enabled = true;
                                } else if (debugLevel.getEndRow() <= 0 && debugLevel.getStartRow() >= 0 && rowCounter.get() >= (long)debugLevel.getStartRow()) {
                                    enabled = true;
                                }
                                if ((debugLevel.getStartRow() <= 0 && debugLevel.getEndRow() <= 0 || enabled) && !condition.isEmpty()) {
                                    enabled = condition.evaluate(rowMeta, row);
                                }
                                if (enabled) {
                                    transformCopy.setLogLevel(debugLevel.getLogLevel());
                                }
                            }

                            public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                                transformCopy.getLogChannel().setLogLevel(baseLogLevel);
                            }

                            public void errorRowWrittenEvent(IRowMeta rowMeta, Object[] row) {
                            }
                        });
                    }
                }
                catch (Exception e) {
                    log.logError("Unable to handle specific debug level for transform : " + transformName, (Throwable)e);
                }
            }
        }
    }
}

