/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.s3.s3common;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.File;
import java.util.Collection;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.vfs.s3.amazon.s3.S3Util;
import org.apache.hop.vfs.s3.s3common.S3CommonFileProvider;
import org.apache.hop.vfs.s3.s3common.S3CommonFileSystemConfigBuilder;

public abstract class S3CommonFileSystem
extends AbstractFileSystem {
    private String awsAccessKeyCache;
    private String awsSecretKeyCache;
    private AmazonS3 client;

    protected S3CommonFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(S3CommonFileProvider.capabilities);
    }

    protected abstract FileObject createFile(AbstractFileName var1) throws Exception;

    public AmazonS3 getS3Client() {
        if (this.client == null && this.getFileSystemOptions() != null) {
            S3CommonFileSystemConfigBuilder s3CommonFileSystemConfigBuilder = new S3CommonFileSystemConfigBuilder(this.getFileSystemOptions());
            String accessKey = s3CommonFileSystemConfigBuilder.getAccessKey();
            String secretKey = s3CommonFileSystemConfigBuilder.getSecretKey();
            String sessionToken = s3CommonFileSystemConfigBuilder.getSessionToken();
            String region = s3CommonFileSystemConfigBuilder.getRegion();
            String credentialsFilePath = s3CommonFileSystemConfigBuilder.getCredentialsFile();
            String profileName = s3CommonFileSystemConfigBuilder.getProfileName();
            String endpoint = s3CommonFileSystemConfigBuilder.getEndpoint();
            String signatureVersion = s3CommonFileSystemConfigBuilder.getSignatureVersion();
            String pathStyleAccess = s3CommonFileSystemConfigBuilder.getPathStyleAccess();
            boolean access = pathStyleAccess == null || Boolean.parseBoolean(pathStyleAccess);
            ProfileCredentialsProvider awsCredentialsProvider = null;
            Regions regions = Regions.DEFAULT_REGION;
            if (!S3Util.isEmpty(accessKey) && !S3Util.isEmpty(secretKey)) {
                Object awsCredentials = S3Util.isEmpty(sessionToken) ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
                awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
                regions = S3Util.isEmpty(region) ? Regions.DEFAULT_REGION : Regions.fromName((String)region);
            } else if (!S3Util.isEmpty(credentialsFilePath)) {
                ProfilesConfigFile profilesConfigFile = new ProfilesConfigFile(credentialsFilePath);
                awsCredentialsProvider = new ProfileCredentialsProvider(profilesConfigFile, profileName);
            }
            if (!S3Util.isEmpty(endpoint)) {
                ClientConfiguration clientConfiguration = new ClientConfiguration();
                clientConfiguration.setSignerOverride(S3Util.isEmpty(signatureVersion) ? "aws.endpoint" : signatureVersion);
                this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, regions.getName()))).withPathStyleAccessEnabled(Boolean.valueOf(access))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).build();
            } else {
                this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).withRegion(regions)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).build();
            }
        }
        if (this.client == null || this.hasClientChangedCredentials()) {
            try {
                this.client = this.isRegionSet() ? (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).build() : (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).withRegion(Regions.DEFAULT_REGION)).build();
                this.awsAccessKeyCache = System.getProperty("aws.accessKeyId");
                this.awsSecretKeyCache = System.getProperty("aws.secretKey");
            }
            catch (Throwable t) {
                LogChannel.GENERAL.logError("Could not get an S3Client", t);
            }
        }
        return this.client;
    }

    private boolean hasClientChangedCredentials() {
        return this.client != null && (S3Util.hasChanged(this.awsAccessKeyCache, System.getProperty("aws.accessKeyId")) || S3Util.hasChanged(this.awsSecretKeyCache, System.getProperty("aws.secretKey")));
    }

    private boolean isRegionSet() {
        if (System.getenv("AWS_REGION") != null || System.getenv("AWS_CONFIG_FILE") != null) {
            return true;
        }
        File awsConfigFolder = new File(System.getProperty("user.home") + File.separator + ".aws" + File.separator + "config");
        return awsConfigFolder.exists();
    }
}

