/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.file.types.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.eclipse.swt.widgets.MessageBox;

public abstract class BaseExplorerFileTypeHandler
implements IHopFileTypeHandler {
    protected HopGui hopGui;
    protected ExplorerPerspective perspective;
    protected ExplorerFile explorerFile;

    public BaseExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        this.hopGui = hopGui;
        this.perspective = perspective;
        this.explorerFile = explorerFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String readTextFileContent(String encoding) throws HopException {
        String string;
        FileObject file = HopVfs.getFileObject((String)this.explorerFile.getFilename());
        if (!file.exists()) throw new HopException("File '" + this.explorerFile.getFilename() + "' doesn't exist");
        InputStream inputStream = HopVfs.getInputStream((FileObject)file);
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)encoding);
            string = writer.toString();
            if (inputStream == null) return string;
        }
        catch (Throwable throwable) {
            try {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new HopException("I/O exception while reading contents of file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
            }
        }
        inputStream.close();
        return string;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return Collections.emptyList();
    }

    @Override
    public Object getSubject() {
        return this.explorerFile;
    }

    @Override
    public String getName() {
        return this.explorerFile.getName();
    }

    @Override
    public void setName(String name) {
        this.explorerFile.setName(name);
    }

    @Override
    public IHopFileType getFileType() {
        return this.explorerFile.getFileType();
    }

    @Override
    public String getFilename() {
        return this.explorerFile.getFilename();
    }

    @Override
    public void setFilename(String filename) {
        this.explorerFile.setFilename(filename);
    }

    @Override
    public void save() throws HopException {
        throw new HopException("Saving file '" + this.getFilename() + " is not implemented.");
    }

    @Override
    public void saveAs(String filename) throws HopException {
        throw new HopException("Saving file '" + this.getFilename() + " is not implemented.");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void preview() {
    }

    @Override
    public void debug() {
    }

    @Override
    public void redraw() {
    }

    @Override
    public void updateGui() {
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void unselectAll() {
    }

    @Override
    public void copySelectedToClipboard() {
    }

    @Override
    public void cutSelectedToClipboard() {
    }

    @Override
    public void deleteSelected() {
    }

    @Override
    public void pasteFromClipboard() {
    }

    @Override
    public boolean isCloseable() {
        try {
            if (this.explorerFile.isChanged()) {
                MessageBox messageDialog = new MessageBox(this.hopGui.getShell(), 452);
                messageDialog.setText("Save file?");
                messageDialog.setMessage("Do you want to save file '" + this.explorerFile.getName() + "' before closing?");
                int answer = messageDialog.open();
                if ((answer & 0x40) != 0) {
                    this.save();
                    return true;
                }
                return (answer & 0x80) != 0;
            }
            return true;
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error preparing file close of '" + this.explorerFile.getName() + "'", e);
            return false;
        }
    }

    @Override
    public boolean hasChanged() {
        return this.explorerFile.isChanged();
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    @Override
    public Map<String, Object> getStateProperties() {
        return Collections.emptyMap();
    }

    @Override
    public void close() {
        this.perspective.closeFile(this.explorerFile);
    }

    @Override
    public void applyStateProperties(Map<String, Object> stateProperties) {
    }

    @Override
    public IVariables getVariables() {
        return this.hopGui.getVariables();
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public ExplorerPerspective getPerspective() {
        return this.perspective;
    }

    public void setPerspective(ExplorerPerspective perspective) {
        this.perspective = perspective;
    }

    public ExplorerFile getExplorerFile() {
        return this.explorerFile;
    }

    public void setExplorerFile(ExplorerFile explorerFile) {
        this.explorerFile = explorerFile;
    }
}

