/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.internal.Utils;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.export.AutoValue_Metric;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.export.MetricDescriptor;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.export.Point;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.export.TimeSeries;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.export.Value;

@Immutable
public abstract class Metric {
    Metric() {
    }

    public static Metric create(MetricDescriptor metricDescriptor, List<TimeSeries> timeSeriesList) {
        Utils.checkListElementNotNull(Utils.checkNotNull(timeSeriesList, "timeSeriesList"), "timeSeries");
        return Metric.createInternal(metricDescriptor, Collections.unmodifiableList(new ArrayList<TimeSeries>(timeSeriesList)));
    }

    public static Metric createWithOneTimeSeries(MetricDescriptor metricDescriptor, TimeSeries timeSeries) {
        return Metric.createInternal(metricDescriptor, Collections.singletonList(Utils.checkNotNull(timeSeries, "timeSeries")));
    }

    private static Metric createInternal(MetricDescriptor metricDescriptor, List<TimeSeries> timeSeriesList) {
        Utils.checkNotNull(metricDescriptor, "metricDescriptor");
        Metric.checkTypeMatch(metricDescriptor.getType(), timeSeriesList);
        return new AutoValue_Metric(metricDescriptor, timeSeriesList);
    }

    public abstract MetricDescriptor getMetricDescriptor();

    public abstract List<TimeSeries> getTimeSeriesList();

    private static void checkTypeMatch(MetricDescriptor.Type type, List<TimeSeries> timeSeriesList) {
        for (TimeSeries timeSeries : timeSeriesList) {
            for (Point point : timeSeries.getPoints()) {
                Value value = point.getValue();
                String valueClassName = "";
                if (value.getClass().getSuperclass() != null) {
                    valueClassName = value.getClass().getSuperclass().getSimpleName();
                }
                switch (type) {
                    case GAUGE_INT64: 
                    case CUMULATIVE_INT64: {
                        Utils.checkArgument(value instanceof Value.ValueLong, "Type mismatch: %s, %s.", new Object[]{type, valueClassName});
                        break;
                    }
                    case CUMULATIVE_DOUBLE: 
                    case GAUGE_DOUBLE: {
                        Utils.checkArgument(value instanceof Value.ValueDouble, "Type mismatch: %s, %s.", new Object[]{type, valueClassName});
                        break;
                    }
                    case GAUGE_DISTRIBUTION: 
                    case CUMULATIVE_DISTRIBUTION: {
                        Utils.checkArgument(value instanceof Value.ValueDistribution, "Type mismatch: %s, %s.", new Object[]{type, valueClassName});
                        break;
                    }
                    case SUMMARY: {
                        Utils.checkArgument(value instanceof Value.ValueSummary, "Type mismatch: %s, %s.", new Object[]{type, valueClassName});
                    }
                }
            }
        }
    }
}

