/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.Collection;
import org.apache.beam.runners.flink.translation.functions.FlinkAssignContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.joda.time.Instant;

public class FlinkAssignWindows<T, W extends BoundedWindow>
implements FlatMapFunction<WindowedValue<T>, WindowedValue<T>> {
    private final WindowFn<T, W> windowFn;

    public FlinkAssignWindows(WindowFn<T, W> windowFn) {
        this.windowFn = windowFn;
    }

    public void flatMap(WindowedValue<T> input, Collector<WindowedValue<T>> collector) throws Exception {
        Collection windows = this.windowFn.assignWindows(new FlinkAssignContext<T, W>(this.windowFn, input));
        for (BoundedWindow window : windows) {
            collector.collect((Object)WindowedValue.of((Object)input.getValue(), (Instant)input.getTimestamp(), (BoundedWindow)window, (PaneInfo)input.getPane()));
        }
    }
}

