/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.metrics.DoFnRunnerWithMetricsUpdate;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.translation.functions.FlinkDoFnFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkNoOpStepContext;
import org.apache.beam.runners.flink.translation.functions.FlinkSideInputReader;
import org.apache.beam.runners.flink.translation.utils.Workarounds;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class FlinkStatefulDoFnFunction<K, V, OutputT>
extends RichGroupReduceFunction<WindowedValue<KV<K, V>>, WindowedValue<RawUnionValue>> {
    private final DoFn<KV<K, V>, OutputT> dofn;
    private final boolean usesOnWindowExpiration;
    private String stepName;
    private final WindowingStrategy<?, ?> windowingStrategy;
    private final Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputs;
    private final SerializablePipelineOptions serializedOptions;
    private final Map<TupleTag<?>, Integer> outputMap;
    private final TupleTag<OutputT> mainOutputTag;
    private final Coder<KV<K, V>> inputCoder;
    private final Map<TupleTag<?>, Coder<?>> outputCoderMap;
    private final DoFnSchemaInformation doFnSchemaInformation;
    private final Map<String, PCollectionView<?>> sideInputMapping;
    private transient DoFnInvoker doFnInvoker;
    private transient FlinkMetricContainer metricContainer;

    public FlinkStatefulDoFnFunction(DoFn<KV<K, V>, OutputT> dofn, String stepName, WindowingStrategy<?, ?> windowingStrategy, Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputs, PipelineOptions pipelineOptions, Map<TupleTag<?>, Integer> outputMap, TupleTag<OutputT> mainOutputTag, Coder<KV<K, V>> inputCoder, Map<TupleTag<?>, Coder<?>> outputCoderMap, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
        this.dofn = dofn;
        this.usesOnWindowExpiration = DoFnSignatures.signatureForDoFn(dofn).onWindowExpiration() != null;
        this.stepName = stepName;
        this.windowingStrategy = windowingStrategy;
        this.sideInputs = sideInputs;
        this.serializedOptions = new SerializablePipelineOptions(pipelineOptions);
        this.outputMap = outputMap;
        this.mainOutputTag = mainOutputTag;
        this.inputCoder = inputCoder;
        this.outputCoderMap = outputCoderMap;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
    }

    public void reduce(Iterable<WindowedValue<KV<K, V>>> values, Collector<WindowedValue<RawUnionValue>> out) throws Exception {
        RuntimeContext runtimeContext = this.getRuntimeContext();
        DoFnRunners.OutputManager outputManager = this.outputMap.size() == 1 ? new FlinkDoFnFunction.DoFnOutputManager(out) : new FlinkDoFnFunction.MultiDoFnOutputManager(out, this.outputMap);
        Iterator<WindowedValue<KV<K, V>>> iterator = values.iterator();
        WindowedValue<KV<K, V>> currentValue = iterator.next();
        Object key = ((KV)currentValue.getValue()).getKey();
        final InMemoryStateInternals stateInternals = InMemoryStateInternals.forKey((Object)key);
        final InMemoryTimerInternals timerInternals = new InMemoryTimerInternals();
        timerInternals.advanceProcessingTime(Instant.now());
        timerInternals.advanceSynchronizedProcessingTime(Instant.now());
        HashSet windowsSeen = new HashSet();
        ArrayList additionalOutputTags = Lists.newArrayList(this.outputMap.keySet());
        DoFnRunnerWithMetricsUpdate doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)this.serializedOptions.get(), this.dofn, (SideInputReader)new FlinkSideInputReader(this.sideInputs, runtimeContext), (DoFnRunners.OutputManager)outputManager, this.mainOutputTag, (List)additionalOutputTags, (StepContext)new FlinkNoOpStepContext(){

            @Override
            public StateInternals stateInternals() {
                return stateInternals;
            }

            @Override
            public TimerInternals timerInternals() {
                return timerInternals;
            }
        }, this.inputCoder, this.outputCoderMap, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation, this.sideInputMapping);
        FlinkPipelineOptions pipelineOptions = (FlinkPipelineOptions)this.serializedOptions.get().as(FlinkPipelineOptions.class);
        if (!pipelineOptions.getDisableMetrics().booleanValue()) {
            doFnRunner = new DoFnRunnerWithMetricsUpdate(this.stepName, doFnRunner, this.metricContainer);
        }
        doFnRunner.startBundle();
        doFnRunner.processElement(currentValue);
        if (this.usesOnWindowExpiration) {
            windowsSeen.addAll(currentValue.getWindows());
        }
        while (iterator.hasNext()) {
            currentValue = iterator.next();
            if (this.usesOnWindowExpiration) {
                windowsSeen.addAll(currentValue.getWindows());
            }
            doFnRunner.processElement(currentValue);
        }
        timerInternals.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
        timerInternals.advanceProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
        timerInternals.advanceSynchronizedProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
        this.fireEligibleTimers(key, timerInternals, doFnRunner);
        if (this.usesOnWindowExpiration) {
            for (BoundedWindow window : windowsSeen) {
                doFnRunner.onWindowExpiration(window, window.maxTimestamp().minus((ReadableDuration)Duration.millis((long)1L)), key);
            }
        }
        doFnRunner.finishBundle();
    }

    private void fireEligibleTimers(K key, InMemoryTimerInternals timerInternals, DoFnRunner<KV<K, V>, OutputT> runner) throws Exception {
        boolean hasFired;
        do {
            TimerInternals.TimerData timer;
            hasFired = false;
            while ((timer = timerInternals.removeNextEventTimer()) != null) {
                hasFired = true;
                this.fireTimer(key, timer, runner);
            }
            while ((timer = timerInternals.removeNextProcessingTimer()) != null) {
                hasFired = true;
                this.fireTimer(key, timer, runner);
            }
            while ((timer = timerInternals.removeNextSynchronizedProcessingTimer()) != null) {
                hasFired = true;
                this.fireTimer(key, timer, runner);
            }
        } while (hasFired);
    }

    private void fireTimer(K key, TimerInternals.TimerData timer, DoFnRunner<KV<K, V>, OutputT> doFnRunner) {
        StateNamespace namespace = timer.getNamespace();
        Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
        BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
        doFnRunner.onTimer(timer.getTimerId(), timer.getTimerFamilyId(), key, window, timer.getTimestamp(), timer.getOutputTimestamp(), timer.getDomain());
    }

    public void open(Configuration parameters) {
        PipelineOptions options = this.serializedOptions.get();
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        this.metricContainer = new FlinkMetricContainer(this.getRuntimeContext());
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor(this.dofn, (PipelineOptions)options);
    }

    public void close() throws Exception {
        try {
            this.metricContainer.registerMetricsForPipelineResult();
            Optional.ofNullable(this.doFnInvoker).ifPresent(DoFnInvoker::invokeTeardown);
        }
        finally {
            Workarounds.deleteStaticCaches();
        }
    }
}

