/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.beam.runners.core.metrics.DistributionCell;

public class CheckpointStats {
    private final Map<Long, Long> checkpointDurations = new HashMap<Long, Long>();
    private final Supplier<DistributionCell> distributionCellSupplier;

    public CheckpointStats(Supplier<DistributionCell> distributionCellSupplier) {
        this.distributionCellSupplier = distributionCellSupplier;
    }

    public void snapshotStart(long checkpointId) {
        this.checkpointDurations.put(checkpointId, System.currentTimeMillis());
    }

    public void reportCheckpointDuration(long checkpointId) {
        Long checkpointStart = this.checkpointDurations.remove(checkpointId);
        if (checkpointStart != null) {
            long checkpointDuration = System.currentTimeMillis() - checkpointStart;
            this.distributionCellSupplier.get().update(checkpointDuration);
        }
    }
}

