/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.UnbufferedDataOutputStreamPlus;
import org.apache.cassandra.utils.FastByteOperations;

public class BufferedDataOutputStreamPlus
extends DataOutputStreamPlus {
    private static final int DEFAULT_BUFFER_SIZE = Integer.getInteger("cassandra.nio_data_output_stream_plus_buffer_size", 32768);
    protected ByteBuffer buffer;

    public BufferedDataOutputStreamPlus(RandomAccessFile ras) {
        this(ras.getChannel());
    }

    public BufferedDataOutputStreamPlus(RandomAccessFile ras, int bufferSize) {
        this((WritableByteChannel)ras.getChannel(), bufferSize);
    }

    public BufferedDataOutputStreamPlus(FileOutputStream fos) {
        this(fos.getChannel());
    }

    public BufferedDataOutputStreamPlus(FileOutputStream fos, int bufferSize) {
        this((WritableByteChannel)fos.getChannel(), bufferSize);
    }

    public BufferedDataOutputStreamPlus(WritableByteChannel wbc) {
        this(wbc, DEFAULT_BUFFER_SIZE);
    }

    public BufferedDataOutputStreamPlus(WritableByteChannel wbc, int bufferSize) {
        this(wbc, ByteBuffer.allocateDirect(bufferSize));
        Preconditions.checkNotNull((Object)wbc);
        Preconditions.checkArgument((bufferSize >= 8 ? 1 : 0) != 0, (Object)"Buffer size must be large enough to accommodate a long/double");
    }

    protected BufferedDataOutputStreamPlus(WritableByteChannel channel, ByteBuffer buffer) {
        super(channel);
        this.buffer = buffer;
    }

    protected BufferedDataOutputStreamPlus(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int copied = 0;
        while (copied < len) {
            if (this.buffer.hasRemaining()) {
                int toCopy = Math.min(len - copied, this.buffer.remaining());
                this.buffer.put(b, off + copied, toCopy);
                copied += toCopy;
                continue;
            }
            this.doFlush(len - copied);
        }
    }

    @Override
    public void write(ByteBuffer src) throws IOException {
        int trgAvailable;
        int srcCount;
        int srcPos = src.position();
        while ((srcCount = src.limit() - srcPos) > (trgAvailable = this.buffer.remaining())) {
            FastByteOperations.copy(src, srcPos, this.buffer, this.buffer.position(), trgAvailable);
            this.buffer.position(this.buffer.position() + trgAvailable);
            this.doFlush(src.limit() - (srcPos += trgAvailable));
        }
        FastByteOperations.copy(src, srcPos, this.buffer, this.buffer.position(), srcCount);
        this.buffer.position(this.buffer.position() + srcCount);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.doFlush(1);
        }
        this.buffer.put((byte)(b & 0xFF));
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.doFlush(1);
        }
        this.buffer.put(v ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeChar(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.buffer.remaining() < 2) {
            this.writeSlow(v, 2);
        } else {
            this.buffer.putChar((char)v);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.buffer.remaining() < 4) {
            this.writeSlow(v, 4);
        } else {
            this.buffer.putInt(v);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.buffer.remaining() < 8) {
            this.writeSlow(v, 8);
        } else {
            this.buffer.putLong(v);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    private void writeSlow(long bytes, int count) throws IOException {
        int origCount = count;
        if (ByteOrder.BIG_ENDIAN == this.buffer.order()) {
            while (count > 0) {
                this.writeByte((int)(bytes >>> 8 * --count));
            }
        } else {
            while (count > 0) {
                this.writeByte((int)(bytes >>> 8 * (origCount - count--)));
            }
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        for (int index = 0; index < s.length(); ++index) {
            this.writeByte(s.charAt(index));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        for (int index = 0; index < s.length(); ++index) {
            this.writeChar(s.charAt(index));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        UnbufferedDataOutputStreamPlus.writeUTF(s, this);
    }

    protected void doFlush(int count) throws IOException {
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            this.channel.write(this.buffer);
        }
        this.buffer.clear();
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(0);
    }

    @Override
    public void close() throws IOException {
        this.doFlush(0);
        this.channel.close();
        FileUtils.clean(this.buffer);
        this.buffer = null;
    }

    public BufferedDataOutputStreamPlus order(ByteOrder order) {
        this.buffer.order(order);
        return this;
    }
}

