/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;

public class UUIDSerializer
extends TypeSerializer<UUID> {
    public static final UUIDSerializer instance = new UUIDSerializer();

    @Override
    public <V> UUID deserialize(V value, ValueAccessor<V> accessor) {
        return accessor.isEmpty(value) ? null : accessor.toUUID(value);
    }

    @Override
    public ByteBuffer serialize(UUID value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : UUIDGen.toByteBuffer(value);
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 16 && !accessor.isEmpty(value)) {
            throw new MarshalException(String.format("UUID should be 16 or 0 bytes (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(UUID value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Class<UUID> getType() {
        return UUID.class;
    }
}

