/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ClickHouseDataSource
extends JdbcWrapper
implements DataSource {
    private final String url;
    private final Properties props;
    protected final ClickHouseDriver driver;
    protected final ClickHouseJdbcUrlParser.ConnectionInfo connInfo;
    protected PrintWriter printWriter;
    protected int loginTimeoutSeconds = 0;

    public ClickHouseDataSource(String url) throws SQLException {
        this(url, new Properties());
    }

    public ClickHouseDataSource(String url, Properties properties) throws SQLException {
        if (url == null) {
            throw new IllegalArgumentException("Incorrect ClickHouse jdbc url. It must be not null");
        }
        this.url = url;
        this.props = new Properties();
        if (properties != null && !properties.isEmpty()) {
            this.props.putAll((Map<?, ?>)properties);
        }
        this.driver = new ClickHouseDriver();
        this.connInfo = ClickHouseJdbcUrlParser.parse(url, properties);
    }

    @Override
    public ClickHouseConnection getConnection() throws SQLException {
        return new ClickHouseConnectionImpl(this.connInfo);
    }

    @Override
    public ClickHouseConnection getConnection(String username, String password) throws SQLException {
        if (username == null || username.isEmpty()) {
            throw SqlExceptionUtils.clientError("Non-empty user name is required");
        }
        if (password == null) {
            password = "";
        }
        if (username.equals(this.props.getProperty(ClickHouseDefaults.USER.getKey())) && password.equals(this.props.getProperty(ClickHouseDefaults.PASSWORD.getKey()))) {
            return new ClickHouseConnectionImpl(this.connInfo);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.props);
        properties.setProperty(ClickHouseDefaults.USER.getKey(), username);
        properties.setProperty(ClickHouseDefaults.PASSWORD.getKey(), password);
        return new ClickHouseConnectionImpl(this.url, properties);
    }

    @Deprecated
    public String getHost() {
        return this.connInfo.getServer().getHost();
    }

    @Deprecated
    public int getPort() {
        return this.connInfo.getServer().getPort();
    }

    @Deprecated
    public String getDatabase() {
        return this.connInfo.getServer().getDatabase().orElse((String)((Object)ClickHouseDefaults.DATABASE.getEffectiveDefaultValue()));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeoutSeconds = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeoutSeconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return ClickHouseDriver.parentLogger;
    }
}

