/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.engines.local;

import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.map.DatabaseConnectionMap;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.execution.ExecutionBuilder;
import org.apache.hop.execution.ExecutionDataBuilder;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionStateBuilder;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.workflow.IActionListener;
import org.apache.hop.workflow.Workflow;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEnginePlugin;
import org.apache.hop.workflow.engines.local.LocalWorkflowRunConfiguration;

@WorkflowEnginePlugin(id="Local", name="Hop local workflow engine", description="Executes your workflow locally")
public class LocalWorkflowEngine
extends Workflow
implements IWorkflowEngine<WorkflowMeta> {
    private ExecutionInfoLocation executionInfoLocation;
    private Timer executionInfoTimer;

    public LocalWorkflowEngine() {
        this.setDefaultRunConfiguration();
    }

    public LocalWorkflowEngine(WorkflowMeta workflowMeta) {
        super(workflowMeta);
        this.setDefaultRunConfiguration();
    }

    public LocalWorkflowEngine(WorkflowMeta workflowMeta, ILoggingObject parent) {
        super(workflowMeta, parent);
        this.setDefaultRunConfiguration();
    }

    @Override
    public IWorkflowEngineRunConfiguration createDefaultWorkflowEngineRunConfiguration() {
        return new LocalWorkflowRunConfiguration();
    }

    private void setDefaultRunConfiguration() {
        this.setWorkflowRunConfiguration(new WorkflowRunConfiguration("local", "", "", this.createDefaultWorkflowEngineRunConfiguration(), false));
    }

    @Override
    public Result startExecution() {
        if (!(this.workflowRunConfiguration.getEngineRunConfiguration() instanceof LocalWorkflowRunConfiguration)) {
            this.log.logError("Error starting workflow", (Throwable)new HopException("A local workflow execution expects a local workflow configuration, not an instance of class " + this.workflowRunConfiguration.getEngineRunConfiguration().getClass().getName()));
            this.result = new Result();
            this.result.setNrErrors(1L);
            return this.result;
        }
        LocalWorkflowRunConfiguration config = (LocalWorkflowRunConfiguration)this.workflowRunConfiguration.getEngineRunConfiguration();
        Object parentExtensionData = this.getParentPipeline();
        if (parentExtensionData == null) {
            parentExtensionData = this.getParentWorkflow();
        }
        Object connectionGroup = null;
        if (parentExtensionData != null && parentExtensionData.getExtensionDataMap() != null) {
            connectionGroup = (String)parentExtensionData.getExtensionDataMap().get("CONNECTION_GROUP");
        }
        if (config.isTransactional() && connectionGroup == null) {
            connectionGroup = this.getWorkflowMeta().getName() + " - " + String.valueOf(UUID.randomUUID());
            this.addWorkflowFinishedListener((IWorkflowEngine<WorkflowMeta> workflow) -> {
                String group = (String)workflow.getExtensionDataMap().get("CONNECTION_GROUP");
                List databases = DatabaseConnectionMap.getInstance().getDatabases(group);
                Result result = workflow.getResult();
                for (Database database : databases) {
                    try {
                        if (result.getResult() && !result.isStopped() && result.getNrErrors() == 0L) {
                            try {
                                database.commit(true);
                                workflow.getLogChannel().logBasic("All transactions of database connection '" + database.getDatabaseMeta().getName() + "' were committed at the end of the workflow!");
                            }
                            catch (HopDatabaseException e) {
                                workflow.getLogChannel().logError("Error committing database connection " + database.getDatabaseMeta().getName(), (Throwable)e);
                                result.setNrErrors(result.getNrErrors() + 1L);
                            }
                            continue;
                        }
                        try {
                            database.rollback(true);
                            workflow.getLogChannel().logBasic("All transactions of database connection '" + database.getDatabaseMeta().getName() + "' were rolled back at the end of the workflow!");
                        }
                        catch (HopDatabaseException e) {
                            workflow.getLogChannel().logError("Error rolling back database connection " + database.getDatabaseMeta().getName(), (Throwable)e);
                            result.setNrErrors(result.getNrErrors() + 1L);
                        }
                    }
                    finally {
                        try {
                            database.closeConnectionOnly();
                            workflow.getLogChannel().logDebug("Database connection '" + database.getDatabaseMeta().getName() + "' closed successfully!");
                        }
                        catch (HopDatabaseException hde) {
                            workflow.getLogChannel().logError("Error disconnecting from database - closeConnectionOnly failed:" + Const.CR + hde.getMessage());
                            workflow.getLogChannel().logError(Const.getStackTracker((Throwable)hde));
                        }
                        DatabaseConnectionMap.getInstance().removeConnection(group, null, database);
                    }
                }
            });
        }
        if (connectionGroup != null && this.getExtensionDataMap() != null) {
            this.getExtensionDataMap().put("CONNECTION_GROUP", connectionGroup);
        }
        this.addActionListener(new IActionListener(){

            public void beforeExecution(IWorkflowEngine workflow, ActionMeta actionMeta, IAction action) {
                String connectionGroup = (String)workflow.getExtensionDataMap().get("CONNECTION_GROUP");
                if (connectionGroup != null) {
                    action.getExtensionDataMap().put("CONNECTION_GROUP", connectionGroup);
                }
            }

            public void afterExecution(IWorkflowEngine workflow, ActionMeta actionMeta, IAction action, Result result) {
            }
        });
        this.lookupExecutionInformationLocation();
        this.addWorkflowStartedListener((IWorkflowEngine<WorkflowMeta> l) -> {
            this.registerWorkflowExecutionInformation();
            this.startExecutionInfoTimer();
        });
        return super.startExecution();
    }

    public void lookupExecutionInformationLocation() {
        try {
            String locationName = this.resolve(this.workflowRunConfiguration.getExecutionInfoLocationName());
            if (StringUtils.isNotEmpty((String)locationName)) {
                ExecutionInfoLocation location = (ExecutionInfoLocation)this.metadataProvider.getSerializer(ExecutionInfoLocation.class).load(locationName);
                if (location != null) {
                    this.executionInfoLocation = location;
                    IExecutionInfoLocation iLocation = this.executionInfoLocation.getExecutionInfoLocation();
                    iLocation.initialize(this, this.metadataProvider);
                } else {
                    this.log.logError("Execution information location '" + locationName + "' could not be found in the metadata (non-fatal)");
                }
            }
        }
        catch (Exception e) {
            this.log.logError("Error looking up execution information location (non-fatal error)", (Throwable)e);
        }
    }

    public void registerWorkflowExecutionInformation() {
        try {
            if (this.executionInfoLocation != null) {
                this.executionInfoLocation.getExecutionInfoLocation().registerExecution(ExecutionBuilder.fromExecutor(this).build());
            }
        }
        catch (Exception e) {
            this.log.logError("Error registering workflow execution information (non-fatal)", (Throwable)e);
        }
    }

    public void startExecutionInfoTimer() {
        if (this.executionInfoLocation == null) {
            return;
        }
        long delay = Const.toLong((String)this.resolve(this.executionInfoLocation.getDataLoggingDelay()), (long)2000L);
        long interval = Const.toLong((String)this.resolve(this.executionInfoLocation.getDataLoggingInterval()), (long)5000L);
        final AtomicInteger lastLogLineNr = new AtomicInteger(0);
        final IExecutionInfoLocation iLocation = this.executionInfoLocation.getExecutionInfoLocation();
        Variables referenceVariables = new Variables();
        referenceVariables.copyFrom((IVariables)this);
        TimerTask sampleTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ExecutionState executionState = ExecutionStateBuilder.fromExecutor(LocalWorkflowEngine.this, (Integer)lastLogLineNr.get()).build();
                    iLocation.updateExecutionState(executionState);
                    if (executionState.getLastLogLineNr() != null) {
                        lastLogLineNr.set(executionState.getLastLogLineNr());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error registering execution info data from transforms at location " + LocalWorkflowEngine.this.executionInfoLocation.getName(), e);
                }
            }
        };
        this.addActionListener((IActionListener)new ExecutionInfoActionListener(iLocation, (IVariables)referenceVariables, this.log));
        this.executionInfoTimer = new Timer();
        this.executionInfoTimer.schedule(sampleTask, delay, interval);
        this.addWorkflowFinishedListener((IWorkflowEngine<WorkflowMeta> listener) -> this.stopExecutionInfoTimer());
    }

    public void stopExecutionInfoTimer() throws HopException {
        if (this.executionInfoTimer != null) {
            this.executionInfoTimer.cancel();
        }
        if (this.executionInfoLocation == null) {
            return;
        }
        try {
            IExecutionInfoLocation iLocation = this.executionInfoLocation.getExecutionInfoLocation();
            ExecutionState executionState = ExecutionStateBuilder.fromExecutor(this, (Integer)-1).build();
            iLocation.updateExecutionState(executionState);
        }
        finally {
            this.executionInfoLocation.getExecutionInfoLocation().close();
        }
    }

    private static class ExecutionInfoActionListener
    implements IActionListener<WorkflowMeta> {
        private final IExecutionInfoLocation iLocation;
        private final IVariables referenceVariables;
        private final ILogChannel log;
        private IVariables beforeVariables;

        public ExecutionInfoActionListener(IExecutionInfoLocation iLocation, IVariables referenceVariables, ILogChannel log) {
            this.iLocation = iLocation;
            this.referenceVariables = referenceVariables;
            this.log = log;
            this.beforeVariables = null;
        }

        @Override
        public void beforeExecution(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionMeta, IAction action) {
            this.beforeVariables = new Variables();
            this.beforeVariables.copyFrom(workflow);
            try {
                this.iLocation.registerExecution(ExecutionBuilder.of().withId(action.getLogChannel().getLogChannelId()).withParentId(workflow.getLogChannelId()).withExecutionStartDate(new Date()).withRegistrationDate(new Date()).withExecutorType(ExecutionType.Action).withLogLevel(action.getLogChannel().getLogLevel()).build());
                this.iLocation.registerData(ExecutionDataBuilder.beforeActionExecution(workflow, actionMeta, action, this.referenceVariables).build());
                this.iLocation.registerExecution(ExecutionBuilder.fromAction(workflow, actionMeta, action, new Date()).build());
            }
            catch (Exception e) {
                this.log.logError("Error registering execution data before action " + actionMeta.getName() + " (non-fatal)", (Throwable)e);
            }
        }

        @Override
        public void afterExecution(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionMeta, IAction action, Result result) {
            ExecutionDataBuilder dataBuilder = ExecutionDataBuilder.afterActionExecution(workflow, actionMeta, action, result, this.referenceVariables, this.beforeVariables);
            try {
                this.iLocation.registerData(dataBuilder.build());
            }
            catch (Exception e) {
                this.log.logError("Error registering execution data after action " + actionMeta.getName() + " (non-fatal)", (Throwable)e);
            }
        }
    }
}

