/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.util.UUID;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class UuidLogicalType
implements Schema.LogicalType<UUID, Row> {
    public static final String IDENTIFIER = "beam:logical_type:uuid:v1";
    public static final String LEAST_SIGNIFICANT_BITS_FIELD_NAME = "LeastSignificantBits";
    public static final String MOST_SIGNIFICANT_BITS_FIELD_NAME = "MostSignificantBits";
    public static final Schema UUID_SCHEMA = Schema.builder().addInt64Field("MostSignificantBits").addInt64Field("LeastSignificantBits").build();

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Schema.FieldType getArgumentType() {
        return Schema.FieldType.STRING;
    }

    @Override
    public String getArgument() {
        return "";
    }

    @Override
    public Schema.FieldType getBaseType() {
        return Schema.FieldType.row(UUID_SCHEMA);
    }

    @Override
    public Row toBaseType(UUID input) {
        return Row.withSchema(UUID_SCHEMA).addValues(input.getMostSignificantBits(), input.getLeastSignificantBits()).build();
    }

    @Override
    public UUID toInputType(Row base) {
        Long leastSignificantBitsValue = base.getInt64(LEAST_SIGNIFICANT_BITS_FIELD_NAME);
        Long mostSignificantBitsValue = base.getInt64(MOST_SIGNIFICANT_BITS_FIELD_NAME);
        if (leastSignificantBitsValue == null || mostSignificantBitsValue == null) {
            throw new IllegalStateException(String.format("Most (%s) and least (%s) significant bits value shouldn't be null for UUID", mostSignificantBitsValue, leastSignificantBitsValue));
        }
        return new UUID(mostSignificantBitsValue, leastSignificantBitsValue);
    }
}

