/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.MergeOverlappingIntervalWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class Sessions
extends WindowFn<Object, IntervalWindow> {
    private final Duration gapDuration;

    public static Sessions withGapDuration(Duration gapDuration) {
        return new Sessions(gapDuration);
    }

    private Sessions(Duration gapDuration) {
        this.gapDuration = gapDuration;
    }

    @Override
    public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) {
        return Arrays.asList(new IntervalWindow(c.timestamp(), (ReadableDuration)this.gapDuration));
    }

    @Override
    public void mergeWindows(WindowFn.MergeContext c) throws Exception {
        MergeOverlappingIntervalWindows.mergeWindows(c);
    }

    @Override
    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        return other instanceof Sessions;
    }

    @Override
    public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("%s is only compatible with %s.", Sessions.class.getSimpleName(), Sessions.class.getSimpleName()));
        }
    }

    @Override
    public TypeDescriptor<IntervalWindow> getWindowTypeDescriptor() {
        return TypeDescriptor.of(IntervalWindow.class);
    }

    @Override
    public WindowMappingFn<IntervalWindow> getDefaultWindowMappingFn() {
        throw new UnsupportedOperationException("Sessions is not allowed in side inputs");
    }

    public Duration getGapDuration() {
        return this.gapDuration;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("gapDuration", this.gapDuration).withLabel("Session Gap Duration"));
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Sessions)) {
            return false;
        }
        Sessions other = (Sessions)object;
        return this.getGapDuration().equals((Object)other.getGapDuration());
    }

    public int hashCode() {
        return Objects.hash(this.gapDuration);
    }
}

