/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class RowWithStorage
extends Row {
    private final List<@Nullable Object> values;

    RowWithStorage(Schema schema, List<@Nullable Object> values) {
        super(schema);
        this.values = values;
    }

    @Override
    public <T> T getValue(int fieldIdx) {
        if (this.values.size() > fieldIdx) {
            return (T)this.values.get(fieldIdx);
        }
        throw new IllegalArgumentException("No field at index " + fieldIdx);
    }

    @Override
    public List<@Nullable Object> getValues() {
        return this.values;
    }

    @Override
    public int getFieldCount() {
        return this.values.size();
    }
}

